/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.code.maker.api.dto;

import com.cyberway.mp.bbc.code.maker.api.dto.CommonCodeDto;
import com.cyberway.mp.bbc.code.maker.api.enums.CodeType;
import com.cyberway.mp.bbc.code.maker.api.enums.IncrTiming;
import com.cyberway.mp.bbc.code.maker.api.enums.ResetTimeUnit;
import com.cyberway.mp.bbc.code.maker.api.enums.TimeUnit;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialCodeDto
extends CommonCodeDto {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Schema(title="\u957f\u5ea6")
    @NotNull
    private Integer length;
    @Schema(title="\u6b65\u957f")
    @NotNull
    private Integer increment;
    @Schema(title="\u521d\u59cb\u503c")
    @NotNull
    private Integer initial;
    @Schema(title="\u53d8\u66f4\u65f6\u673a\uff1aSAVE \u65b0\u589e\uff1bMODIFY \u7f16\u8f91")
    @NotNull
    private IncrTiming incrTiming;
    @Schema(title="\u65f6\u95f4\u6570\u5b57")
    @NotNull
    private Integer timeNums;
    @Schema(title="\u65f6\u95f4\u5355\u4f4d\uff1aTIME \u6b21\uff1bDAY \u5929 ")
    @NotNull
    private TimeUnit timeUnit;
    @Schema(title="\u6bcf\u591a\u5c11\u4e2a\u91cd\u7f6e\u65f6\u95f4\u5355\u4f4d\u91cd\u7f6e\u4e00\u6b21\u6d41\u6c34\u7801")
    private Integer resetTimeNums;
    @Schema(title="\u91cd\u7f6e\u65f6\u95f4\u5355\u4f4d")
    private ResetTimeUnit resetTimeUnit;
    @Schema(title="\u7f16\u7801\u7c7b\u578b")
    private CodeType codeType = CodeType.SERIAL;

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getIncrement() {
        return this.increment;
    }

    public void setIncrement(Integer increment) {
        this.increment = increment;
    }

    public Integer getInitial() {
        return this.initial;
    }

    public void setInitial(Integer initial) {
        this.initial = initial;
    }

    public IncrTiming getIncrTiming() {
        return this.incrTiming;
    }

    public void setIncrTiming(IncrTiming incrTiming) {
        this.incrTiming = incrTiming;
    }

    public Integer getTimeNums() {
        return this.timeNums;
    }

    public void setTimeNums(Integer timeNums) {
        this.timeNums = timeNums;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public Integer getResetTimeNums() {
        return this.resetTimeNums;
    }

    public void setResetTimeNums(Integer resetTimeNums) {
        this.resetTimeNums = resetTimeNums;
    }

    public ResetTimeUnit getResetTimeUnit() {
        return this.resetTimeUnit;
    }

    public void setResetTimeUnit(ResetTimeUnit resetTimeUnit) {
        this.resetTimeUnit = resetTimeUnit;
    }

    @Override
    public CodeType getCodeType() {
        return this.codeType;
    }

    @Override
    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
    }

    public Date expireAt(Integer resetTimeNums, ResetTimeUnit resetTimeUnit) {
        if (resetTimeNums == null) {
            this.logger.info("resetTimeNums\u4e3anull\uff0c\u5931\u6548\u65f6\u95f4\u4e3a\u7a7a");
            return null;
        }
        try {
            if (ResetTimeUnit.DAY.equals((Object)resetTimeUnit)) {
                if (resetTimeNums == 0) {
                    this.logger.warn("\u63090\u5929\u91cd\u7f6e\u6d41\u6c34\u7801\uff0c\u6d41\u6c34\u7801\u5c06\u6bcf\u6b21\u91cd\u7f6e\uff01");
                }
                return this.localDateTimeToDate(LocalDateTime.of(LocalDate.now().plusDays(resetTimeNums.intValue()), LocalTime.MIDNIGHT));
            }
            if (ResetTimeUnit.SECOND.equals((Object)resetTimeUnit)) {
                return DateUtils.addSeconds((Date)new Date(), (int)resetTimeNums);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u91cd\u7f6e\u65f6\u95f4\u5f02\u5e38", (Throwable)e);
            return null;
        }
        return null;
    }

    private Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

