/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.code.maker.api.infra.redis;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bbc.code.maker.api.constant.CodeRuleCacheKey;
import com.cyberway.mp.bbc.code.maker.api.constant.repository.CodeMakerRuleRepository;
import com.cyberway.mp.bbc.code.maker.api.dto.CodeRuleDto;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.util.CollectionUtils;

public class RedisCodeMakerRuleRepository
implements CodeMakerRuleRepository,
ApplicationContextAware {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, String> template;

    @Override
    public void saveCodeRule(CodeRuleDto codeRule) {
        this.template.opsForHash().put((Object)CodeRuleCacheKey.getCodeRuleKey(codeRule.getEntityCode()), (Object)codeRule.getEntityFieldCode(), (Object)JSON.toJSONString((Object)((Object)codeRule)));
    }

    @Override
    public CodeRuleDto findCodeRule(String entityCode, String fieldCode) {
        String rules = (String)this.template.opsForHash().get((Object)CodeRuleCacheKey.getCodeRuleKey(entityCode), (Object)fieldCode);
        if (StringUtils.isBlank((CharSequence)rules)) {
            return null;
        }
        return (CodeRuleDto)((Object)JSON.parseObject((String)rules, CodeRuleDto.class));
    }

    @Override
    public Map<String, CodeRuleDto> ruleEntry(String entityCode) {
        this.logger.info("\u4eceredis\u4e2d\u52a0\u8f7d\u5b9e\u4f53:[{}]\u7f16\u7801\u89c4\u5219", (Object)entityCode);
        HashOperations opsForHash = this.template.opsForHash();
        Map entries = opsForHash.entries((Object)CodeRuleCacheKey.getCodeRuleKey(entityCode));
        if (CollectionUtils.isEmpty((Map)entries)) {
            return Collections.emptyMap();
        }
        return entries.keySet().stream().collect(Collectors.toMap(Function.identity(), key -> (CodeRuleDto)((Object)((Object)JSON.parseObject((String)((String)entries.get(key)), CodeRuleDto.class)))));
    }

    @Override
    public void deleteRules(String entityCode, String ... fieldCodes) {
        this.template.opsForHash().delete((Object)CodeRuleCacheKey.getCodeRuleKey(entityCode), (Object[])fieldCodes);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.template = (RedisTemplate)applicationContext.getBean(StringRedisTemplate.class);
    }
}

