/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.code.maker.generate;

import com.cyberway.mp.bbc.code.maker.api.constant.CodeErrorCode;
import com.cyberway.mp.bbc.code.maker.api.dto.ReferenceCodeDto;
import com.cyberway.mp.bbc.code.maker.api.dto.ReferenceCodeGenerateDto;
import com.cyberway.mp.bbc.code.maker.generate.ReferenceCodeGenerateFeignClient;
import com.cyberway.mp.bbc.code.maker.generate.ReferenceCodeGenerator;
import com.cyberway.mp.bbc.code.maker.generate.ReferenceCodeValue;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ReferenceCodeFactory
implements ApplicationContextAware {
    @Value(value="${spring.application.name:}")
    private String serviceName;
    private final List<ReferenceCodeGenerator> generators;
    private FeignClientBuilder feignClientBuilder;
    private final Map<String, ReferenceCodeGenerateFeignClient> cacheMap = new ConcurrentHashMap<String, ReferenceCodeGenerateFeignClient>(16);

    public ReferenceCodeFactory(List<ReferenceCodeGenerator> generators) {
        this.generators = generators;
    }

    public List<ReferenceCodeValue> build(ReferenceCodeGenerateDto dto) {
        ReferenceCodeDto referenceCodeDto = dto.getReferenceCodeDto();
        if (StringUtils.isNotBlank((CharSequence)referenceCodeDto.getReferencedServiceName()) && !StringUtils.equals((CharSequence)this.serviceName, (CharSequence)referenceCodeDto.getReferencedServiceName())) {
            ReferenceCodeGenerateFeignClient client = this.getClient(referenceCodeDto.getReferencedServiceName());
            return (List)client.generate(dto).getData();
        }
        ReferenceCodeGenerator referenceCodeGenerator = this.generators.stream().filter(generator -> generator.supported(dto)).findFirst().orElse(null);
        if (null == referenceCodeGenerator) {
            throw new BaseException((ErrorCode)CodeErrorCode.REFERENCE_CODE_GENERATOR_NOT_FOUND, new Object[]{referenceCodeDto.getCode()});
        }
        return referenceCodeGenerator.generate(dto);
    }

    public ReferenceCodeGenerateFeignClient getClient(String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new IllegalArgumentException("serviceName must not blank");
        }
        if (this.cacheMap.containsKey(serviceName)) {
            return this.cacheMap.get(serviceName);
        }
        ReferenceCodeGenerateFeignClient feignClient = this.buildClient(serviceName);
        this.cacheMap.put(serviceName, feignClient);
        return feignClient;
    }

    private ReferenceCodeGenerateFeignClient buildClient(String serviceName) {
        return (ReferenceCodeGenerateFeignClient)this.feignClientBuilder.forType(ReferenceCodeGenerateFeignClient.class, serviceName).path("/api/referenceCodeGenerate").build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.feignClientBuilder = new FeignClientBuilder(applicationContext);
    }
}

