/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.data.auth.api.data.vo;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bbc.data.auth.api.data.constants.DataAuthConstant;
import com.cyberway.mp.bbc.data.auth.api.data.vo.RoleDataAuthConditionGroupVo;
import com.cyberway.mp.bbc.data.auth.api.data.vo.RoleDataAuthConditionVo;
import com.cyberway.mp.bbc.data.auth.api.template.vo.DataAuthTemplateDetailVo;
import com.cyberway.mp.bbc.data.auth.api.template.vo.DataAuthTemplateVo;
import com.cyberway.mp.bc.common.utils.BeanUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class RoleDataAuthListVo
extends DataAuthTemplateVo {
    @Schema(title="\u89d2\u8272\u6761\u4ef6\u7ec4\u5217\u8868")
    private List<RoleDataAuthConditionGroupVo> roleConditionGroups;

    public List<RoleDataAuthConditionGroupVo> getRoleConditionGroups() {
        if (CollectionUtils.isEmpty(this.roleConditionGroups)) {
            return this.buildConditionGroupFromDetail();
        }
        this.roleConditionGroups.forEach(group -> {
            Optional<DataAuthTemplateDetailVo> dicOpt;
            if (DataAuthConstant.ConditionType.FUNC.equals((Object)group.getConditionType())) {
                this.loadFuncGroup((RoleDataAuthConditionGroupVo)group);
            } else if (DataAuthConstant.ConditionType.DIC.equals((Object)group.getConditionType()) && (dicOpt = this.getDetails().stream().filter(detail -> DataAuthConstant.ConditionType.DIC.equals((Object)detail.getConditionType())).findFirst()).isPresent() && !CollectionUtils.isEmpty(group.getRoleConditions())) {
                DataAuthTemplateDetailVo dic = dicOpt.get();
                RoleDataAuthConditionVo conditionVo = group.getRoleConditions().get(0);
                if (!conditionVo.getConditionValueId().equals(dic.getConditionValueIds().get(0))) {
                    conditionVo.setConditionValueId(dic.getConditionValueIds().get(0));
                    conditionVo.setConditionValue(JSON.toJSONString(dic.getValues()));
                }
            }
        });
        return this.roleConditionGroups;
    }

    private void loadFuncGroup(RoleDataAuthConditionGroupVo group) {
        Optional<DataAuthTemplateDetailVo> funcOpt = this.getDetails().stream().filter(detail -> DataAuthConstant.ConditionType.FUNC.equals((Object)detail.getConditionType())).findFirst();
        if (funcOpt.isPresent()) {
            DataAuthTemplateDetailVo func = funcOpt.get();
            List funcIds = func.getConditionValueIds().stream().collect(Collectors.toList());
            List<RoleDataAuthConditionVo> before = group.getRoleConditions();
            List<RoleDataAuthConditionVo> after = before.stream().filter(each -> each.getConditionValueId() != null && funcIds.contains(each.getConditionValueId())).collect(Collectors.toList());
            group.setRoleConditions(after);
        }
    }

    public List<RoleDataAuthConditionGroupVo> buildConditionGroupFromDetail() {
        List<DataAuthTemplateDetailVo> details = this.getDetails();
        return details.stream().map(detail -> {
            RoleDataAuthConditionGroupVo conditionGroupVo = (RoleDataAuthConditionGroupVo)BeanUtils.copyProperties((Object)new RoleDataAuthConditionGroupVo(), (Object)detail);
            conditionGroupVo.setTemplateDetailId(detail.getId());
            conditionGroupVo.setCombineType(DataAuthConstant.CombineType.AND);
            if (DataAuthConstant.ConditionType.FUNC.equals((Object)conditionGroupVo.getConditionType())) {
                ArrayList<RoleDataAuthConditionVo> conditionVos = new ArrayList<RoleDataAuthConditionVo>(detail.getConditionValueIds().size());
                for (int i = 0; i < detail.getConditionValueIds().size(); ++i) {
                    Long conditionValueId = detail.getConditionValueIds().get(i);
                    String value = detail.getValues().get(i);
                    RoleDataAuthConditionVo conditionVo = (RoleDataAuthConditionVo)BeanUtils.copyProperties((Object)new RoleDataAuthConditionVo(), (Object)detail);
                    conditionVo.setTemplateDetailId(detail.getId());
                    conditionVo.setConditionValue(value);
                    conditionVo.setConditionValueId(conditionValueId);
                    conditionVo.setOperator(DataAuthConstant.Operator.IN);
                    conditionVo.setCombineType(DataAuthConstant.CombineType.OR);
                    conditionVo.setConditionType(DataAuthConstant.ConditionType.FUNC);
                    conditionVos.add(conditionVo);
                }
                conditionGroupVo.setRoleConditions(conditionVos);
            } else if (DataAuthConstant.ConditionType.DIC.equals((Object)conditionGroupVo.getConditionType()) && !CollectionUtils.isEmpty(detail.getConditionValueIds())) {
                Long dicId = detail.getConditionValueIds().get(0);
                RoleDataAuthConditionVo conditionVo = (RoleDataAuthConditionVo)BeanUtils.copyProperties((Object)new RoleDataAuthConditionVo(), (Object)detail);
                conditionVo.setTemplateDetailId(detail.getId());
                conditionVo.setConditionValue(JSON.toJSONString(detail.getValues()));
                conditionVo.setConditionValueId(dicId);
                conditionVo.setOperator(DataAuthConstant.Operator.IN);
                conditionVo.setCombineType(DataAuthConstant.CombineType.AND);
                conditionVo.setConditionType(DataAuthConstant.ConditionType.DIC);
                conditionGroupVo.setRoleConditions(Collections.singletonList(conditionVo));
            }
            return conditionGroupVo;
        }).collect(Collectors.toList());
    }

    public void setRoleConditionGroups(List<RoleDataAuthConditionGroupVo> roleConditionGroups) {
        this.roleConditionGroups = roleConditionGroups;
    }
}

