/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.data.auth.api.field.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cyberway.mp.basic.data.api.metadata.DataManageType;
import com.cyberway.mp.bbc.data.auth.api.data.constants.RoleDataAuthCacheKey;
import com.cyberway.mp.bbc.data.auth.api.data.dto.DataAuthTemplateDto;
import com.cyberway.mp.bbc.data.auth.api.data.dto.FieldAuthDto;
import com.cyberway.mp.bbc.data.auth.api.data.enums.ConditionTargetType;
import com.cyberway.mp.bbc.data.auth.api.data.enums.DataAuthStatus;
import com.cyberway.mp.bbc.data.auth.api.data.enums.DataAuthType;
import com.cyberway.mp.bbc.data.auth.api.data.enums.RestrictType;
import com.cyberway.mp.bc.common.api.enums.DataType;
import com.cyberway.mp.bc.common.config.SpringContextUtil;
import com.cyberway.mp.ca.auth.ExtraInfoMap;
import com.cyberway.mp.ca.auth.UserSession;
import com.cyberway.mp.entity.common.dto.EntityDto;
import com.cyberway.mp.entity.common.dto.EntityFieldDto;
import com.cyberway.mp.entity.common.dto.EntityFieldGroupDto;
import com.cyberway.mp.entity.common.service.EntityDataCacheService;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class FieldAuthHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldAuthHelper.class);
    private static final Map<RestrictType, Integer> RESTRICT_TYPE_MAP = new EnumMap<RestrictType, Integer>(RestrictType.class);

    private FieldAuthHelper() {
    }

    public static Map<String, List<FieldAuthDto>> toEntityFieldAuth(UserSession userSession, Long tenantId) {
        List<FieldAuthDto> fieldAuthRules = FieldAuthHelper.getAuthRules(userSession, tenantId);
        Collection<FieldAuthDto> fieldAuths = FieldAuthHelper.fieldCodeToField(fieldAuthRules, tenantId);
        return fieldAuths.stream().collect(Collectors.groupingBy(DataAuthTemplateDto::getEntityCode));
    }

    public static Map<String, List<FieldAuthDto>> toEntityFieldAuth(UserSession userSession, Long tenantId, DataManageType dataManageType) {
        if (dataManageType == null) {
            return FieldAuthHelper.toEntityFieldAuth(userSession, tenantId);
        }
        List<FieldAuthDto> fieldAuthRules = FieldAuthHelper.getAuthRules(userSession, tenantId);
        Collection<FieldAuthDto> fieldAuths = FieldAuthHelper.fieldCodeToField(fieldAuthRules, tenantId);
        return fieldAuths.stream().filter(fieldAuth -> dataManageType.equals((Object)fieldAuth.getDataManageType())).collect(Collectors.groupingBy(DataAuthTemplateDto::getEntityCode));
    }

    public static List<FieldAuthDto> toEntityFieldAuth(UserSession userSession, Long tenantId, String entityCode) {
        List<FieldAuthDto> fieldAuthRules = FieldAuthHelper.getAuthRules(userSession, tenantId);
        Collection<FieldAuthDto> fieldAuths = FieldAuthHelper.fieldCodeToField(fieldAuthRules, tenantId);
        return fieldAuths.stream().filter(fieldAuth -> entityCode.equals(fieldAuth.getEntityCode())).collect(Collectors.toList());
    }

    private static Collection<FieldAuthDto> fieldCodeToField(List<FieldAuthDto> allFieldAuthDto, Long tenantId) {
        if (CollectionUtils.isEmpty(allFieldAuthDto)) {
            return Collections.emptyList();
        }
        allFieldAuthDto = FieldAuthHelper.groupType2FieldType(allFieldAuthDto, tenantId);
        HashMap<CallSite, FieldAuthDto> temp = new HashMap<CallSite, FieldAuthDto>();
        for (FieldAuthDto fieldAuthDto : allFieldAuthDto) {
            String fieldCode;
            String entityCode = fieldAuthDto.getEntityCode();
            String key = entityCode + ":" + (fieldCode = fieldAuthDto.getConditionFieldCode());
            if (temp.containsKey(key)) {
                FieldAuthDto exist = (FieldAuthDto)temp.get(key);
                if (!FieldAuthHelper.greaterThen(fieldAuthDto, exist)) continue;
                temp.put((CallSite)((Object)key), fieldAuthDto);
                continue;
            }
            temp.put((CallSite)((Object)key), fieldAuthDto);
        }
        return temp.values();
    }

    private static List<FieldAuthDto> groupType2FieldType(List<FieldAuthDto> allFieldAuthDto, Long tenantId) {
        try {
            ArrayList<FieldAuthDto> resultList = new ArrayList<FieldAuthDto>();
            EntityDataCacheService entityDataCacheService = (EntityDataCacheService)SpringContextUtil.getBean(EntityDataCacheService.class);
            Map<String, List<FieldAuthDto>> groupByEntityCode = allFieldAuthDto.stream().collect(Collectors.groupingBy(DataAuthTemplateDto::getEntityCode));
            groupByEntityCode.forEach((entityCode, itemList) -> {
                EntityDto entityDto = entityDataCacheService.getFromCache(entityCode, tenantId);
                if (entityDto == null) {
                    return;
                }
                Map<String, EntityFieldDto> fieldMap = entityDto.getEntityFields().stream().collect(Collectors.toMap(EntityFieldDto::getCode, f -> f, (f1, f2) -> f1));
                for (FieldAuthDto fieldAuthDto : itemList) {
                    if (ConditionTargetType.FIELD.equals((Object)fieldAuthDto.getConditionTargetType()) && fieldMap.containsKey(fieldAuthDto.getConditionFieldCode()) && Boolean.TRUE.equals(fieldMap.get(fieldAuthDto.getConditionFieldCode()).getPermissionFlag())) {
                        resultList.add(fieldAuthDto);
                        continue;
                    }
                    if (!ConditionTargetType.GROUP.equals((Object)fieldAuthDto.getConditionTargetType())) continue;
                    resultList.addAll(FieldAuthHelper.group2Fields(entityDto, fieldAuthDto));
                }
            });
            return resultList;
        }
        catch (Exception e) {
            LOGGER.error("", (Throwable)e);
            return allFieldAuthDto;
        }
    }

    private static List<FieldAuthDto> group2Fields(EntityDto entityDto, FieldAuthDto groupTypeAuthDto) {
        if (null == entityDto || null == groupTypeAuthDto) {
            return Collections.emptyList();
        }
        EntityFieldGroupDto targetGroup = entityDto.getEntityFieldGroups().stream().filter(g -> g.getCode().equals(groupTypeAuthDto.getConditionFieldCode())).findFirst().orElse(null);
        if (null == targetGroup || CollectionUtils.isEmpty((Collection)targetGroup.getFieldCodes())) {
            return Collections.emptyList();
        }
        Map<String, EntityFieldDto> fieldMap = entityDto.getEntityFields().stream().collect(Collectors.toMap(EntityFieldDto::getCode, f -> f, (f1, f2) -> f1));
        return targetGroup.getFieldCodes().stream().filter(fieldMap::containsKey).filter(f -> Boolean.TRUE.equals(((EntityFieldDto)fieldMap.get(f)).getPermissionFlag())).map(fieldCode -> {
            FieldAuthDto fieldAuthDto = new FieldAuthDto();
            BeanUtils.copyProperties((Object)groupTypeAuthDto, (Object)fieldAuthDto);
            EntityFieldDto fieldDto = (EntityFieldDto)fieldMap.get(fieldCode);
            fieldAuthDto.setConditionTargetType(ConditionTargetType.FIELD);
            fieldAuthDto.setConditionFieldCode((String)fieldCode);
            fieldAuthDto.setConditionFieldName(fieldDto.getName());
            fieldAuthDto.setConditionFieldType(DataType.getByName((String)fieldDto.getDataType()));
            return fieldAuthDto;
        }).collect(Collectors.toList());
    }

    public static boolean greaterThen(FieldAuthDto newDto, FieldAuthDto oldDto) {
        return FieldAuthHelper.greaterThen(newDto.getRestrictType(), oldDto.getRestrictType());
    }

    public static boolean greaterThen(RestrictType newRestrictType, RestrictType oldRestrictType) {
        return RESTRICT_TYPE_MAP.get((Object)newRestrictType) > RESTRICT_TYPE_MAP.get((Object)oldRestrictType);
    }

    private static List<FieldAuthDto> getAuthRules(UserSession userSession, Long tenantId) {
        Set unVisibleEntityCodes;
        String unVisibleEntityCodesJson;
        Map fieldAuthRules;
        ExtraInfoMap userExtraInfo;
        ArrayList<FieldAuthDto> allFieldAuthDto = new ArrayList<FieldAuthDto>();
        if (userSession == null || (userExtraInfo = userSession.getTenantExtraInfo()) == null) {
            return Collections.emptyList();
        }
        String userRoleFieldAuth = (String)userExtraInfo.get((Object)RoleDataAuthCacheKey.getRoleFieldRuleCacheKey(tenantId));
        if (StringUtils.isNotBlank((CharSequence)userRoleFieldAuth) && (fieldAuthRules = (Map)JSON.parseObject((String)userRoleFieldAuth, (TypeReference)new TypeReference<Map<Long, List<FieldAuthDto>>>(){}, (Feature[])new Feature[0])) != null) {
            allFieldAuthDto.addAll(fieldAuthRules.values().stream().flatMap(Collection::stream).collect(Collectors.toList()));
        }
        if (StringUtils.isNotBlank((CharSequence)(unVisibleEntityCodesJson = (String)userExtraInfo.get((Object)RoleDataAuthCacheKey.getRoleUnVisibleEntityCacheKey(tenantId)))) && CollectionUtils.isNotEmpty((Collection)(unVisibleEntityCodes = (Set)JSON.parseObject((String)unVisibleEntityCodesJson, (TypeReference)new TypeReference<Set<String>>(){}, (Feature[])new Feature[0])))) {
            EntityDataCacheService entityDataCacheService = (EntityDataCacheService)SpringContextUtil.getBean(EntityDataCacheService.class);
            for (String unVisibleEntityCode : unVisibleEntityCodes) {
                List unVisibleFields;
                EntityDto entityDto = entityDataCacheService.getFromCache(unVisibleEntityCode, tenantId);
                if (null == entityDto || !Boolean.TRUE.equals(entityDto.getControlEnabled()) || !CollectionUtils.isNotEmpty(unVisibleFields = entityDto.getEntityFields().stream().filter(f -> Boolean.TRUE.equals(f.getPermissionFlag())).map(f -> FieldAuthHelper.entityFiled2FieldAuth(entityDto, f, RestrictType.UN_VISIBLE)).collect(Collectors.toList()))) continue;
                allFieldAuthDto.addAll(unVisibleFields);
            }
        }
        return allFieldAuthDto;
    }

    public static Map<String, List<FieldAuthDto>> userEntityFieldAuthOnlyUnVisible(UserSession userSession, Long tenantId) {
        HashMap<String, List<FieldAuthDto>> result = new HashMap<String, List<FieldAuthDto>>();
        Map<String, List<FieldAuthDto>> userEntityFieldAuth = FieldAuthHelper.toEntityFieldAuth(userSession, tenantId);
        userEntityFieldAuth.forEach((entityCode, fieldAuths) -> {
            if (fieldAuths == null || fieldAuths.isEmpty()) {
                return;
            }
            List unVisibleFields = fieldAuths.stream().filter(fieldAuth -> RestrictType.UN_VISIBLE.equals((Object)fieldAuth.getRestrictType())).collect(Collectors.toList());
            result.put((String)entityCode, unVisibleFields);
        });
        return result;
    }

    private static FieldAuthDto entityFiled2FieldAuth(EntityDto entityDto, EntityFieldDto entityField, RestrictType restrictType) {
        FieldAuthDto fieldAuthDto = new FieldAuthDto();
        fieldAuthDto.setDataManageType(DataManageType.getByName((String)entityDto.getDataManageType()));
        fieldAuthDto.setRestrictType(restrictType);
        fieldAuthDto.setStatus(DataAuthStatus.ENABLED);
        fieldAuthDto.setConditionTargetType(ConditionTargetType.FIELD);
        fieldAuthDto.setDomainCode(entityDto.getDomainCode());
        fieldAuthDto.setEntityCode(entityDto.getCode());
        fieldAuthDto.setEntityName(entityDto.getName());
        fieldAuthDto.setConditionEntityCode(entityDto.getCode());
        fieldAuthDto.setConditionFieldCode(entityField.getCode());
        fieldAuthDto.setConditionFieldName(entityField.getName());
        fieldAuthDto.setConditionFieldType(DataType.getByName((String)entityField.getDataType()));
        fieldAuthDto.setType(DataAuthType.FIELD);
        return fieldAuthDto;
    }

    static {
        RESTRICT_TYPE_MAP.put(RestrictType.UN_VISIBLE, 0);
        RESTRICT_TYPE_MAP.put(RestrictType.VISIBLE, 1);
        RESTRICT_TYPE_MAP.put(RestrictType.ACTIONABLE, 2);
    }
}

