/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.config;

import com.cyberway.mp.basic.data.api.metadata.FunctionProviderDefinitionApi;
import com.cyberway.mp.entity.common.config.EntityCommonProperties;
import com.cyberway.mp.entity.common.excel.EmptyEntityEnumDataLoader;
import com.cyberway.mp.entity.common.excel.EntityEnumDataLoader;
import com.cyberway.mp.entity.common.feign.CategoryFeignClient;
import com.cyberway.mp.entity.common.feign.EntityDataFeignClient;
import com.cyberway.mp.entity.common.function.ExtFunctionProviderLoader;
import com.cyberway.mp.entity.common.function.FunctionProvider;
import com.cyberway.mp.entity.common.function.loader.DefaultFunctionProviderLoader;
import com.cyberway.mp.entity.common.service.CategoryCacheService;
import com.cyberway.mp.entity.common.service.EntityDataCacheService;
import com.cyberway.mp.entity.common.service.EntityFlowConfigCacheService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@ConditionalOnProperty(prefix="mp.entity-data", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableFeignClients(basePackages={"com.cyberway.mp.entity.common.feign"})
@Configuration
@ComponentScan(basePackages={"com.cyberway.mp.entity.common.controller"})
@Import(value={EntityCommonProperties.class})
public class EntityCommonConfiguration {
    @Bean
    @ConditionalOnMissingBean(name={"entityDataCacheService"})
    public EntityDataCacheService entityDataCacheService(EntityDataFeignClient entityDataFeignClient, EntityCommonProperties entityCommonProperties) {
        return new EntityDataCacheService(entityDataFeignClient, entityCommonProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public CategoryCacheService categoryCacheService(CategoryFeignClient categoryFeignClient) {
        return new CategoryCacheService(categoryFeignClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityFlowConfigCacheService entityFlowConfigCacheService(EntityDataFeignClient entityDataFeignClient) {
        return new EntityFlowConfigCacheService(entityDataFeignClient);
    }

    @Bean
    @ConditionalOnMissingBean
    public EntityEnumDataLoader emptyEntityEnumDataLoader() {
        return new EmptyEntityEnumDataLoader();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExtFunctionProviderLoader functionProviderLoader(@Autowired(required=false) FunctionProviderDefinitionApi functionProviderDefinitionApi, List<FunctionProvider> functionProviders, EntityCommonProperties entityCommonProperties) {
        DefaultFunctionProviderLoader defaultFunctionProviderLoader = new DefaultFunctionProviderLoader(functionProviderDefinitionApi, entityCommonProperties);
        for (FunctionProvider functionProvider : functionProviders) {
            defaultFunctionProviderLoader.registerFunctionProvider(functionProvider);
        }
        return defaultFunctionProviderLoader;
    }
}

