/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.constants;

import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.entity.common.EntityToolErrorCode;
import java.util.Set;

public class EntityConstant {
    public static final Integer DATA_STATUS_INACTIVATED = 0;
    public static final Integer DATA_STATUS_ACTIVATED = 1;
    public static final Integer DATA_STATUS_DISABLED = 9;
    public static final Integer FLOW_STATUS_DRAFT = 0;
    public static final Integer FLOW_STATUS_RUNNING = 1;
    public static final Integer FLOW_STATUS_PASS = 2;
    public static final Integer FLOW_STATUS_REJECTED = 3;
    public static final Integer FLOW_STATUS_WITHDRAW = 4;
    public static final Integer FLOW_STATUS_CLOSED = 5;
    public static final Integer LOCK_FLAG_LOCKED = 1;
    public static final Integer LOCK_FLAG_UN_LOCKED = 0;
    public static final String FLOW_TYPE_VAR_KEY = "entityFlowType";
    public static final String ENTITY_OBJ_VAR_KEY = "entityObj";
    public static final String RELATE_OBJS_VAR_KEY = "relateObjs";
    public static final String ENUM_OBJ_VAR_KEY = "enumObj";
    public static final String SPEC_OBJ_VAR_KEY = "specObj";
    public static final String ENTITY_MODIFY_RELATE_CODES_VAR_KEY = "entityModifyRelateCodes";
    public static final String ENTITY_OLD_NEW_SNAPSHOT_KEY = "entityOldNewSnapshot";
    public static final String FLOW_TYPE_ADD_DATA = "addData";
    public static final String FLOW_TYPE_MODIFY_DATA = "modifyData";
    public static final String FLOW_TYPE_DEL_DATA = "delData";
    public static final String FLOW_TYPE_DISABLE_DATA = "disableData";
    public static final String FLOW_TYPE_FREEZE_DATA = "freezeData";
    public static final String FLOW_TYPE_UNFREEZE_DATA = "unfreezeData";
    public static final String FLOW_INSTANCE_ID_FIELD_CODE = "flowInstanceId";
    public static final String FLOW_STATUS_FIELD_CODE = "flowStatus";
    public static final String MODIFY_FLAG_FIELD_CODE = "modifyFlag";
    public static final String DATA_STATUS_FIELD_CODE = "dataStatus";
    public static final String LOCK_FLAG_FIELD_CODE = "lockStatus";
    public static final String DATA_STATUS_COL_NAME = "data_status";
    public static final String FREEZE_STATUS_FIELD_CODE = "freezeStatus";
    public static final String FREEZE_STATUS_COL_NAME = "freeze_status";
    public static final Integer FREEZE_STATUS_UNFREEZE = 0;
    public static final Integer FREEZE_STATUS_FREEZE = 1;
    public static final String CREATED_TIME_FIELD_CODE = "createdTime";
    public static final String CREATED_USER_NAME = "createdUserName";
    public static final String CREATED_USER_ID = "createdUserId";
    public static final String RELATE_VALUE_TYPE_FIELD = "type";
    public static final String RELATE_VALUE_VALUE_FIELD = "data";
    public static final String RELATE_VALUE_TYPE_ITEM = "item";
    public static final String RELATE_VALUE_TYPE_ITEMS = "items";
    public static final String RELATE_VALUE_TYPE_KEY = "key";
    public static final String RELATE_VALUE_TYPE_KEYS = "keys";
    public static final String ID_FIELD_CODE = "id";
    public static final String STATUS_FIELD_CODE = "status";
    public static final String COL_NAME_VERSION_NO = "version_no";
    public static final String COL_NAME_MODIFY_FLAG = "modify_flag";
    public static final String COL_NAME_LAST_EDITOR_ID = "last_editor_id";
    public static final String COL_NAME_REAL_ID = "real_id";
    public static final String COL_NAME_CURRENT_FLAG = "current_flag";
    public static final String COL_NAME_MAIN_ID = "main_id";
    public static final String COL_NAME_MAIN_START_ID = "main_start_id";
    public static final String COL_NAME_MAIN_REAL_START_VER = "main_real_start_ver";
    public static final String COL_NAME_MAIN_START_VER = "main_start_ver";
    public static final String COL_NAME_MAIN_END_VER = "main_end_ver";
    public static final String COL_NAME_RELATE_ID = "relate_id";
    public static final String COL_NAME_RELATE_START_ID = "relate_start_id";
    public static final String COL_NAME_RELATE_REAL_START_VER = "relate_real_start_ver";
    public static final String COL_NAME_RELATE_START_VER = "relate_start_ver";
    public static final String COL_NAME_RELATE_END_VER = "relate_end_ver";
    public static final String COL_NAME_DRAFT_FLAG = "draft_flag";
    public static final String COL_NAME_TREE_PARENT_ID = "tree_parent_id";
    public static final String COL_NAME_TREE_PARENT_VID = "tree_parent_vid";
    public static final String COL_NAME_TREE_LEFT_NO = "tree_left_no";
    public static final String COL_NAME_TREE_RIGHT_NO = "tree_right_no";
    public static final Integer DRAFT_FLAG_CURRENT_ENABLED = 0;
    public static final Integer DRAFT_FLAG_CURRENT_DISABLED = 1;
    public static final Integer DRAFT_FLAG_MAIN_DRAFT = 2;
    public static final Integer DRAFT_FLAG_RELATE_DRAFT = 3;
    public static final String COL_NAME_DELETED = "deleted";
    public static final String FIELD_NAME_BOM_ENTITY_CODE = "bomEntityCode";
    public static final String COL_NAME_BOM_ENTITY_CODE = "bom_entity_code";
    public static final String FIELD_NAME_CHILDREN = "children";
    public static final String STRUCT_TYPE_TREE = "TREE";
    public static final String DATA_MANAGE_TYPE_SYSTEM = "SYSTEM";
    public static final String DATA_MANAGE_TYPE_SELF = "SELF";
    public static final Integer IMPORT_TYPE_ALL = 0;
    public static final Integer IMPORT_TYPE_ONLY_ADD = 1;
    public static final Integer IMPORT_TYPE_ONLY_UPDATE = 2;
    public static final Integer MAX_PAGE_SIZE = 5000;
    public static final Integer MAX_EXPORT_SIZE = 100000;
    public static final Integer ENTITY_CHANGE_TYPE_ADD = 0;
    public static final Integer ENTITY_CHANGE_TYPE_EDIT = 1;
    public static final Integer ENTITY_CHANGE_TYPE_DEL = 2;
    public static final Integer RELATE_LOG_CHANGE_LOG_IN_MAIN = 1;
    public static final Integer RELATE_LOG_CHANGE_LOG_IN_RELATE = 0;
    public static final String TABLE_NAME_IMPORT_LOG = "entity_import_log";
    public static final String TABLE_NAME_DATA_LOG = "entity_data_log";
    public static final String TABLE_NAME_CATEGORY_PROPERTY_VALUE = "entity_category_property_value";
    public static final Integer ALLOW_ENUM_NO = 0;
    public static final Integer ALLOW_ENUM_SIMPLE = 1;
    public static final Integer ALLOW_ENUM_DICT = 2;
    public static final Integer ALLOW_ENUM_ENTITY = 3;
    public static final Integer RELATE_DELETE_TYPE_NO = 0;
    public static final Integer RELATE_DELETE_TYPE_MAIN = 1;
    public static final Integer RELATE_DELETE_TYPE_RELATE = 2;
    public static final Integer RELATE_DELETE_TYPE_ALL = 3;
    public static final String ENTITY_DATA_PARAM_KEY = "$obj";
    public static final String GEO_COL_SUFFIX = "_geo";
    public static final String GEO_JSON_LAT = "lat";
    public static final String GEO_JSON_LNG = "lng";
    public static final int GEO_DEFAULT_SRID = 4326;
    public static final String DATABASE_ID_MSSQL = "Microsoft SQL Server";
    public static final String DATABASE_ID_PGSQL = "PostgreSQL";
    public static final String FLOW_TASK_INFO_FIELD_KEY = "flowTaskInfo";
    public static final String FLOW_TASK_INFO_FILTER_PREFIX = "flowTaskInfo.";
    public static final String FLOW_TASK_ID_EXCEL_TITLE = "\u4efb\u52a1ID";
    public static final Set<String> NOT_ALLOW_FIELD_CODES = Set.of("current_flag", EntityConstant.underlineToCamel("current_flag"), "real_id", EntityConstant.underlineToCamel("real_id"), "modify_flag", EntityConstant.underlineToCamel("modify_flag"), "last_editor_id", EntityConstant.underlineToCamel("last_editor_id"), "version_no", EntityConstant.underlineToCamel("version_no"), "tree_parent_id", EntityConstant.underlineToCamel("tree_parent_id"), "tree_left_no", EntityConstant.underlineToCamel("tree_left_no"), "tree_right_no", EntityConstant.underlineToCamel("tree_right_no"), "children");
    public static final Set<String> EXPORT_IGNORE_FIELD = Set.of("current_flag", "real_id", "modify_flag", "last_editor_id", "version_no", "deleted", "tree_parent_id", "tree_left_no", "tree_right_no");

    private EntityConstant() {
    }

    private static String underlineToCamel(String source) {
        StringBuilder result = new StringBuilder();
        boolean prevIsUnderline = false;
        for (char c : source.toCharArray()) {
            if (prevIsUnderline) {
                result.append(Character.toUpperCase(c));
                prevIsUnderline = false;
                continue;
            }
            if (c == '_') {
                prevIsUnderline = true;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String getBomTableName(String bomEntityRealTableName) {
        AssertUtil.notBlank((String)bomEntityRealTableName, (ErrorCode)EntityToolErrorCode.EMPTY_VALUE, (Object[])new Object[]{"bomEntityRealTableName"});
        return String.format("sys_%s_bom", bomEntityRealTableName);
    }

    public static String getRelateTableName(String relateCode) {
        AssertUtil.notBlank((String)relateCode, (ErrorCode)EntityToolErrorCode.EMPTY_VALUE, (Object[])new Object[]{"relateCode"});
        return String.format("sys_relate_%s", relateCode);
    }
}

