/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.dto;

import com.cyberway.mp.basic.data.api.metadata.DataManageType;
import com.cyberway.mp.basic.data.api.metadata.EntityOwnerConfig;
import com.cyberway.mp.basic.data.api.metadata.FieldPropertyType;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityCascadedUpdateConfigDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntitySelectConfigDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntitySyncConfigDto;
import com.cyberway.mp.basic.data.api.rule.dto.SimilarityRuleDto;
import com.cyberway.mp.bc.common.utils.BeanUtils;
import com.cyberway.mp.entity.common.dto.EntityBomConfigDto;
import com.cyberway.mp.entity.common.dto.EntityFieldDto;
import com.cyberway.mp.entity.common.dto.EntityFieldGroupDto;
import com.cyberway.mp.entity.common.dto.EntityRelateDto;
import com.cyberway.mp.entity.common.dto.FunctionNodeMetaDto;
import com.cyberway.mp.entity.common.dto.RuleExpressionDto;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class EntityDto {
    private static final String TYPE_LONG = "Long";
    private static final String TYPE_INTEGER = "Integer";
    private Long tenantId;
    private String domainName;
    private String domainCode;
    private String centerCode;
    private String name;
    private String code;
    private String realTableName;
    private Boolean logChange = false;
    private Boolean supportVersion;
    private String versionHisTableName;
    private String versionEditTableName;
    private Boolean logicDelete = false;
    private String structType;
    private String dataManageType;
    private Boolean controlEnabled;
    private List<EntityFieldDto> entityFields;
    private List<EntityFieldGroupDto> entityFieldGroups;
    private List<EntityRelateDto> entityRelates;
    private List<RuleExpressionDto> ruleExpressions;
    private Map<String, String> fieldCodeToColumnName;
    private Set<String> geoFieldCodes;
    private String codeRuleEntityCode;
    private Map<String, List<FunctionNodeMetaDto>> entityFunctionMap;
    private Boolean extendEnabled;
    private Boolean hasCategoryFields;
    @Schema(title="\u5b9e\u4f53bom\u914d\u7f6e")
    private EntityBomConfigDto entityBomConfig;
    private List<EntitySelectConfigDto> entitySelectConfigDto;
    private SimilarityRuleDto similarityRuleDto;
    private Boolean validateDraftEditor;
    private EntitySyncConfigDto entitySyncConfigDto;
    private Boolean enableOwnerCheck;
    private EntityOwnerConfig ownerConfig;
    private Boolean enableFlowTaskData;
    private Map<String, EntityCascadedUpdateConfigDto> cascadedUpdateConfig;
    private Boolean enableI18n;

    public static EntityDto buildVersionRelateEntityDto(EntityDto mainEntityDto, EntityRelateDto relateDto) {
        EntityDto relateEntityDto = new EntityDto();
        relateEntityDto.setRealTableName(relateDto.getRelateTableName());
        ArrayList<EntityFieldDto> fields = new ArrayList<EntityFieldDto>();
        fields.add(EntityDto.buildSimpleField("id", TYPE_LONG));
        fields.add(EntityDto.buildSimpleField("main_id", TYPE_LONG));
        fields.add(EntityDto.buildSimpleField("main_start_id", TYPE_LONG));
        fields.add(EntityDto.buildSimpleField("main_real_start_ver", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("main_start_ver", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("main_end_ver", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("relate_id", TYPE_LONG));
        fields.add(EntityDto.buildSimpleField("relate_start_id", TYPE_LONG));
        fields.add(EntityDto.buildSimpleField("relate_real_start_ver", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("relate_start_ver", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("relate_end_ver", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("draft_flag", TYPE_INTEGER));
        relateEntityDto.setEntityFields(fields);
        relateEntityDto.setDataManageType(DataManageType.SYSTEM.name());
        relateEntityDto.setCenterCode(mainEntityDto.getCenterCode());
        return relateEntityDto;
    }

    public static EntityFieldDto buildSimpleField(String code) {
        return EntityDto.buildSimpleField(code, "String");
    }

    public static EntityFieldDto buildSimpleField(String code, String dataType) {
        EntityFieldDto field = new EntityFieldDto();
        field.setCode(code);
        field.setRealColName(code);
        field.setDataType(dataType);
        return field;
    }

    public static EntityDto buildEditEntityDto(EntityDto currentEntityDto) {
        EntityDto editEntityDto = (EntityDto)BeanUtils.copyProperties((Object)new EntityDto(), (Object)currentEntityDto);
        editEntityDto.setRealTableName(currentEntityDto.getVersionEditTableName());
        editEntityDto.setCodeRuleEntityCode(currentEntityDto.getCode());
        ArrayList<EntityFieldDto> fields = new ArrayList<EntityFieldDto>();
        fields.add(EntityDto.buildSimpleField("version_no", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("modify_flag", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("last_editor_id", TYPE_LONG));
        List<EntityFieldDto> mainFields = currentEntityDto.getEntityFields();
        if (!CollectionUtils.isEmpty(mainFields)) {
            fields.addAll(mainFields);
        }
        editEntityDto.setEntityFields(fields);
        return editEntityDto;
    }

    public static EntityDto buildHisEntityDto(EntityDto currentEntityDto) {
        List<EntityFieldDto> mainFields;
        EntityDto editEntityDto = (EntityDto)BeanUtils.copyProperties((Object)new EntityDto(), (Object)currentEntityDto);
        editEntityDto.setRealTableName(currentEntityDto.getVersionHisTableName());
        ArrayList<EntityFieldDto> fields = new ArrayList<EntityFieldDto>();
        fields.add(EntityDto.buildSimpleField("version_no", TYPE_INTEGER));
        fields.add(EntityDto.buildSimpleField("real_id", TYPE_LONG));
        fields.add(EntityDto.buildSimpleField("current_flag", TYPE_INTEGER));
        if ("TREE".equals(currentEntityDto.getStructType())) {
            fields.add(EntityDto.buildSimpleField("tree_parent_vid", TYPE_LONG));
        }
        if (!CollectionUtils.isEmpty(mainFields = currentEntityDto.getEntityFields())) {
            fields.addAll(mainFields);
        }
        editEntityDto.setEntityFields(fields);
        return editEntityDto;
    }

    public void addEntityField(EntityFieldDto entityFieldDto) {
        if (CollectionUtils.isEmpty(this.entityFields)) {
            this.entityFields = new ArrayList<EntityFieldDto>();
        }
        this.entityFields.add(entityFieldDto);
    }

    public Map<String, String> returnFieldCodeToColumnName() {
        if (!CollectionUtils.isEmpty(this.fieldCodeToColumnName)) {
            return this.fieldCodeToColumnName;
        }
        return this.entityFields.stream().filter(f -> !FieldPropertyType.RELATE.equals((Object)f.getFieldPropertyType())).collect(Collectors.toMap(EntityFieldDto::getCode, fieldDto -> fieldDto.getRealColName() == null ? "" : fieldDto.getRealColName()));
    }

    public Set<String> returnGeoFieldCodes() {
        if (this.geoFieldCodes == null) {
            this.geoFieldCodes = this.entityFields.stream().filter(f -> FieldPropertyType.GEO.equals((Object)f.getFieldPropertyType())).map(EntityFieldDto::getCode).collect(Collectors.toSet());
        }
        return this.geoFieldCodes;
    }

    public List<EntityFieldDto> returnEntityNameFields() {
        if (CollectionUtils.isEmpty(this.entityFields)) {
            return Collections.emptyList();
        }
        return this.entityFields.stream().filter(field -> Boolean.TRUE.equals(field.getNameField())).collect(Collectors.toList());
    }

    public Map<String, EntityFieldDto> returnFieldCodeToEntityField() {
        return this.entityFields.stream().collect(Collectors.toMap(EntityFieldDto::getCode, Function.identity()));
    }

    public Map<String, EntityFieldDto> returnTableFieldCodeToEntityField() {
        return this.entityFields.stream().filter(f -> !FieldPropertyType.RELATE.equals((Object)f.getFieldPropertyType())).collect(Collectors.toMap(EntityFieldDto::getCode, Function.identity()));
    }

    public Boolean returnCodeFlag() {
        if (CollectionUtils.isEmpty(this.entityFields)) {
            return false;
        }
        for (EntityFieldDto entityField : this.entityFields) {
            if (entityField.getCodeFlag() == null || !entityField.getCodeFlag().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Map<String, EntityRelateDto> relateDtoMap() {
        if (CollectionUtils.isEmpty(this.entityRelates)) {
            return Collections.emptyMap();
        }
        return this.entityRelates.stream().collect(Collectors.toMap(EntityRelateDto::getRelateCode, Function.identity()));
    }

    public String fieldClassType(String fieldName) {
        if (!CollectionUtils.isEmpty(this.entityFields)) {
            for (EntityFieldDto entityField : this.entityFields) {
                if (!entityField.getName().equals(fieldName)) continue;
                return entityField.getDataType();
            }
        }
        return null;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Map<String, List<FunctionNodeMetaDto>> getEntityFunctionMap() {
        return this.entityFunctionMap;
    }

    public void setEntityFunctionMap(Map<String, List<FunctionNodeMetaDto>> entityFunctionMap) {
        this.entityFunctionMap = entityFunctionMap;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }

    public String getDomainCode() {
        return this.domainCode;
    }

    public void setDomainCode(String domainCode) {
        this.domainCode = domainCode;
    }

    public String getCenterCode() {
        return this.centerCode;
    }

    public void setCenterCode(String centerCode) {
        this.centerCode = centerCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getRealTableName() {
        return this.realTableName;
    }

    public void setRealTableName(String realTableName) {
        this.realTableName = realTableName;
    }

    public Boolean getLogChange() {
        return this.logChange;
    }

    public void setLogChange(Boolean logChange) {
        this.logChange = logChange;
    }

    public Boolean getSupportVersion() {
        return this.supportVersion;
    }

    public void setSupportVersion(Boolean supportVersion) {
        this.supportVersion = supportVersion;
    }

    public String getVersionHisTableName() {
        return this.versionHisTableName;
    }

    public void setVersionHisTableName(String versionHisTableName) {
        this.versionHisTableName = versionHisTableName;
    }

    public String getVersionEditTableName() {
        return this.versionEditTableName;
    }

    public void setVersionEditTableName(String versionEditTableName) {
        this.versionEditTableName = versionEditTableName;
    }

    public Boolean getLogicDelete() {
        return this.logicDelete;
    }

    public void setLogicDelete(Boolean logicDelete) {
        this.logicDelete = logicDelete;
    }

    public String getStructType() {
        return this.structType;
    }

    public void setStructType(String structType) {
        this.structType = structType;
    }

    public String getDataManageType() {
        return this.dataManageType;
    }

    public void setDataManageType(String dataManageType) {
        this.dataManageType = dataManageType;
    }

    public Boolean getControlEnabled() {
        return this.controlEnabled;
    }

    public void setControlEnabled(Boolean controlEnabled) {
        this.controlEnabled = controlEnabled;
    }

    public List<EntityFieldDto> getEntityFields() {
        return this.entityFields;
    }

    public void setEntityFields(List<EntityFieldDto> entityFields) {
        this.entityFields = entityFields;
    }

    public List<EntityFieldGroupDto> getEntityFieldGroups() {
        return this.entityFieldGroups;
    }

    public void setEntityFieldGroups(List<EntityFieldGroupDto> entityFieldGroups) {
        this.entityFieldGroups = entityFieldGroups;
    }

    public List<EntityRelateDto> getEntityRelates() {
        return this.entityRelates;
    }

    public void setEntityRelates(List<EntityRelateDto> entityRelates) {
        this.entityRelates = entityRelates;
    }

    public List<RuleExpressionDto> getRuleExpressions() {
        return this.ruleExpressions;
    }

    public void setRuleExpressions(List<RuleExpressionDto> ruleExpressions) {
        this.ruleExpressions = ruleExpressions;
    }

    public Map<String, String> getFieldCodeToColumnName() {
        return this.fieldCodeToColumnName;
    }

    public void setFieldCodeToColumnName(Map<String, String> fieldCodeToColumnName) {
        this.fieldCodeToColumnName = fieldCodeToColumnName;
    }

    public String getCodeRuleEntityCode() {
        return this.codeRuleEntityCode;
    }

    public void setCodeRuleEntityCode(String codeRuleEntityCode) {
        this.codeRuleEntityCode = codeRuleEntityCode;
    }

    public Boolean getExtendEnabled() {
        return this.extendEnabled;
    }

    public void setExtendEnabled(Boolean extendEnabled) {
        this.extendEnabled = extendEnabled;
    }

    public Boolean returnPermissionFlag() {
        if (CollectionUtils.isEmpty(this.entityFields)) {
            return false;
        }
        for (EntityFieldDto entityField : this.entityFields) {
            if (entityField.getPermissionFlag() == null || !entityField.getPermissionFlag().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public List<EntityFieldDto> returnPermissionFields() {
        if (CollectionUtils.isEmpty(this.entityFields)) {
            return Collections.emptyList();
        }
        return this.entityFields.stream().filter(f -> Boolean.TRUE.equals(f.getPermissionFlag())).collect(Collectors.toList());
    }

    public EntityFieldDto returnCategoryField() {
        if (null == this.getEntityFields()) {
            return null;
        }
        return this.getEntityFields().stream().filter(f -> FieldPropertyType.CATEGORY_PROPERTY.equals((Object)f.getFieldPropertyType())).findFirst().orElse(null);
    }

    public Boolean getHasCategoryFields() {
        if (this.hasCategoryFields == null) {
            if (this.entityFields == null) {
                return false;
            }
            this.hasCategoryFields = this.entityFields.stream().anyMatch(f -> FieldPropertyType.CATEGORY_PROPERTY.equals((Object)f.getFieldPropertyType()));
        }
        return this.hasCategoryFields;
    }

    public void setHasCategoryFields(Boolean hasCategoryFields) {
        this.hasCategoryFields = hasCategoryFields;
    }

    public EntityBomConfigDto getEntityBomConfig() {
        return this.entityBomConfig;
    }

    public void setEntityBomConfig(EntityBomConfigDto entityBomConfig) {
        this.entityBomConfig = entityBomConfig;
    }

    public List<EntitySelectConfigDto> getEntitySelectConfigDto() {
        return this.entitySelectConfigDto;
    }

    public void setEntitySelectConfigDto(List<EntitySelectConfigDto> entitySelectConfigDto) {
        this.entitySelectConfigDto = entitySelectConfigDto;
    }

    public SimilarityRuleDto getSimilarityRuleDto() {
        return this.similarityRuleDto;
    }

    public void setSimilarityRuleDto(SimilarityRuleDto similarityRuleDto) {
        this.similarityRuleDto = similarityRuleDto;
    }

    public Boolean getValidateDraftEditor() {
        return this.validateDraftEditor;
    }

    public void setValidateDraftEditor(Boolean validateDraftEditor) {
        this.validateDraftEditor = validateDraftEditor;
    }

    public EntitySyncConfigDto getEntitySyncConfigDto() {
        return this.entitySyncConfigDto;
    }

    public void setEntitySyncConfigDto(EntitySyncConfigDto entitySyncConfigDto) {
        this.entitySyncConfigDto = entitySyncConfigDto;
    }

    public Boolean getEnableOwnerCheck() {
        return this.enableOwnerCheck;
    }

    public void setEnableOwnerCheck(Boolean enableOwnerCheck) {
        this.enableOwnerCheck = enableOwnerCheck;
    }

    public EntityOwnerConfig getOwnerConfig() {
        return this.ownerConfig;
    }

    public void setOwnerConfig(EntityOwnerConfig ownerConfig) {
        this.ownerConfig = ownerConfig;
    }

    public Boolean getEnableFlowTaskData() {
        return this.enableFlowTaskData;
    }

    public void setEnableFlowTaskData(Boolean enableFlowTaskData) {
        this.enableFlowTaskData = enableFlowTaskData;
    }

    public Map<String, EntityCascadedUpdateConfigDto> getCascadedUpdateConfig() {
        return this.cascadedUpdateConfig;
    }

    public void setCascadedUpdateConfig(Map<String, EntityCascadedUpdateConfigDto> cascadedUpdateConfig) {
        this.cascadedUpdateConfig = cascadedUpdateConfig;
    }

    public Boolean getEnableI18n() {
        return this.enableI18n;
    }

    public void setEnableI18n(Boolean enableI18n) {
        this.enableI18n = enableI18n;
    }
}

