/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.excel;

import com.cyberway.mp.basic.data.api.dict.DictApi;
import com.cyberway.mp.basic.data.api.dict.DictType;
import com.cyberway.mp.basic.data.api.dict.dto.DictItemTreeQueryDto;
import com.cyberway.mp.basic.data.api.dict.vo.DictItemTreeVo;
import com.cyberway.mp.basic.data.api.metadata.EntityMetadataApi;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityDatasetConfigDto;
import com.cyberway.mp.basic.data.api.metadata.dto.EntityFieldEnumDto;
import com.cyberway.mp.basic.data.api.metadata.vo.BaseEntityEditVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityFieldVo;
import com.cyberway.mp.basic.data.api.metadata.vo.EntityPropertyVo;
import com.cyberway.mp.bc.common.config.SpringContextUtil;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.entity.common.constants.EntityConstant;
import com.cyberway.mp.entity.common.excel.EntityEnumDataLoader;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class EntityExcelHelper {
    private EntityExcelHelper() {
        throw new IllegalStateException("Utility class");
    }

    public static List<List<Object>> getExcelInstruction() {
        return List.of(Collections.singletonList("1.\u5b57\u6bb5\u540d\u5e26*\u4e3a\u5fc5\u586b\u9879"), Collections.singletonList("2.\u5b57\u6bb5\u5e95\u8272\u7f6e\u7070\u7684\u4e3a\u4e0d\u80fd\u4fee\u6539\u7684\u5185\u5bb9"), Collections.singletonList("3.\u5b57\u6bb5\u5e95\u8272\u662f\u767d\u8272\u662f\u53ef\u586b\u5199\u9879"));
    }

    public static Map<String, List<List<Object>>> getExcelTemplateEnumData(String entityCode, Set<String> mainColumnFieldCodes, Map<String, Set<String>> relateFieldCodes) {
        LinkedHashMap<String, List<List<Object>>> excelTemplateEnumData = new LinkedHashMap<String, List<List<Object>>>();
        EntityMetadataApi entityMetadataApi = (EntityMetadataApi)SpringContextUtil.getBean(EntityMetadataApi.class);
        EntityPropertyVo mainEntityPropertyVo = entityMetadataApi.getPropertyByEntityCode(entityCode);
        EntityExcelHelper.appendExcelTemplateEnumData(excelTemplateEnumData, mainEntityPropertyVo, mainColumnFieldCodes);
        relateFieldCodes.forEach((relateEntityCode, relateColumnFieldCodes) -> {
            EntityPropertyVo relateEntityPropertyVo = entityMetadataApi.getPropertyByEntityCode(relateEntityCode);
            EntityExcelHelper.appendExcelTemplateEnumData(excelTemplateEnumData, relateEntityPropertyVo, relateColumnFieldCodes);
        });
        return excelTemplateEnumData;
    }

    private static List<List<Object>> initExcelTemplateEnumDataList() {
        ArrayList list = Lists.newArrayList();
        list.add(Lists.newArrayList((Object[])new Object[]{"\u9009\u9879\u7f16\u7801", "\u9009\u9879\u540d\u79f0", "\u6240\u5c5e\u5c42\u7ea7"}));
        return list;
    }

    private static void appendExcelTemplateEnumData(Map<String, List<List<Object>>> excelTemplateEnumData, EntityPropertyVo entityPropertyVo, Collection<String> excelColumnFieldCodes) {
        entityPropertyVo.getFields().stream().filter(entityFieldDto -> !EntityConstant.ALLOW_ENUM_NO.equals(entityFieldDto.getAllowEnum()) && excelColumnFieldCodes.contains(entityFieldDto.getCode())).collect(Collectors.groupingBy(f -> (String)StringUtils.defaultIfBlank((CharSequence)f.getDictCode(), (CharSequence)""))).forEach((dictCode, entityFieldDtoList) -> EntityExcelHelper.appendExcelTemplateEnumData(excelTemplateEnumData, dictCode, entityPropertyVo.getEntity(), entityFieldDtoList));
    }

    private static void appendExcelTemplateEnumData(Map<String, List<List<Object>>> excelTemplateEnumData, String dictCode, BaseEntityEditVo baseEntityEditVo, List<EntityFieldVo> entityFieldDtoList) {
        String displayFormat = baseEntityEditVo.getName() + "(%s)";
        if (StringUtils.isBlank((CharSequence)dictCode)) {
            for (EntityFieldVo entityFieldVo : entityFieldDtoList) {
                if (EntityConstant.ALLOW_ENUM_SIMPLE.equals(entityFieldVo.getAllowEnum()) && CollectionUtils.isNotEmpty((Collection)entityFieldVo.getEnumsConfig())) {
                    String fieldTitle = String.format(displayFormat, entityFieldVo.getName());
                    List<List<Object>> list = EntityExcelHelper.initExcelTemplateEnumDataList();
                    excelTemplateEnumData.put(EntityExcelHelper.formatSheetName(fieldTitle), list);
                    for (EntityFieldEnumDto entityFieldEnumDto : entityFieldVo.getEnumsConfig()) {
                        list.add(Lists.newArrayList((Object[])new Object[]{entityFieldEnumDto.getCode(), entityFieldEnumDto.getName()}));
                    }
                    continue;
                }
                if (!EntityConstant.ALLOW_ENUM_ENTITY.equals(entityFieldVo.getAllowEnum()) || entityFieldVo.getEntityDatasetConfig() == null) continue;
                EntityEnumDataLoader loader = (EntityEnumDataLoader)SpringContextUtil.getBean(EntityEnumDataLoader.class);
                EntityDatasetConfigDto config = entityFieldVo.getEntityDatasetConfig();
                String fieldTitle = String.format(displayFormat, entityFieldVo.getName());
                List<List<Object>> list = EntityExcelHelper.initExcelTemplateEnumDataList();
                list.addAll(loader.load(config));
                if (list.size() <= 1) continue;
                excelTemplateEnumData.put(EntityExcelHelper.formatSheetName(fieldTitle), list);
            }
        } else {
            String[] dictCodeSplit = dictCode.split(":");
            DictItemTreeQueryDto treeQueryDto = new DictItemTreeQueryDto(ServiceContext.getContext().getRequestTenantId(), null, Boolean.valueOf(true), Boolean.valueOf(true), null);
            treeQueryDto.setIncludeRootItem(Boolean.valueOf(false));
            treeQueryDto.setReturnAllLevel(Boolean.valueOf(true));
            treeQueryDto.setCode(dictCodeSplit[0]);
            if (dictCodeSplit.length == 3) {
                String type = dictCodeSplit[2];
                if (DictType.ITEM.name().equalsIgnoreCase(type)) {
                    treeQueryDto.setRootItemValue(dictCodeSplit[1]);
                }
            }
            List dictItems = ((DictApi)SpringContextUtil.getBean(DictApi.class)).dictItemTree(treeQueryDto);
            List<List<Object>> list = EntityExcelHelper.initExcelTemplateEnumDataList();
            EntityExcelHelper.appendExcelTemplateDictData(list, "", dictItems);
            entityFieldDtoList.stream().map(f -> String.format(displayFormat, f.getName())).forEach(s -> excelTemplateEnumData.put(EntityExcelHelper.formatSheetName(s), list));
        }
    }

    private static void appendExcelTemplateDictData(List<List<Object>> excelTemplateEnumData, String parentLevelDesc, List<DictItemTreeVo> dictItems) {
        if (CollectionUtils.isNotEmpty(dictItems)) {
            for (DictItemTreeVo dictItem : dictItems) {
                String currentLevelDesc = parentLevelDesc + "/" + dictItem.getDisplayName();
                excelTemplateEnumData.add(Lists.newArrayList((Object[])new Object[]{dictItem.getItemValue(), dictItem.getDisplayName(), currentLevelDesc}));
                EntityExcelHelper.appendExcelTemplateDictData(excelTemplateEnumData, currentLevelDesc, dictItem.getChildren());
            }
        }
    }

    private static String formatSheetName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return name.replaceAll("[\\\\/?*\\[\\]`:]", "_");
    }
}

