/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.excel;

import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.context.CellWriteHandlerContext;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;

public class ReadOnlyCellWriteHandler
implements CellWriteHandler {
    private Set<Integer> enableSheetNoSet;
    private Set<String> enableSheetNameSet;
    private Set<Integer> readOnlyColumnIndexSet;
    private Set<Integer> ignoreRows;
    private CellStyle readOnlyCellStyle;
    private WriteCellStyle writeCellStyle;

    public ReadOnlyCellWriteHandler(Set<Integer> readOnlyColumnIndexSet) {
        this(readOnlyColumnIndexSet, Collections.singleton(0), Collections.singleton(0), Collections.emptySet());
    }

    public ReadOnlyCellWriteHandler(Set<Integer> readOnlyColumnIndexSet, Set<Integer> ignoreRows, Set<Integer> enableSheetNoSet, Set<String> enableSheetNameSet) {
        this.readOnlyColumnIndexSet = readOnlyColumnIndexSet == null ? Collections.emptySet() : readOnlyColumnIndexSet;
        this.ignoreRows = ignoreRows == null ? Collections.emptySet() : ignoreRows;
        this.enableSheetNoSet = enableSheetNoSet == null ? Collections.emptySet() : enableSheetNoSet;
        this.enableSheetNameSet = enableSheetNameSet == null ? Collections.emptySet() : enableSheetNameSet;
    }

    public void afterCellDispose(CellWriteHandlerContext context) {
        Integer columnIndex = context.getColumnIndex();
        Integer rowIndex = context.getRowIndex();
        Integer sheetNo = context.getWriteSheetHolder().getSheetNo();
        String sheetName = context.getWriteSheetHolder().getSheetName();
        if ((this.enableSheetNoSet.contains(sheetNo) || this.enableSheetNameSet.contains(sheetName)) && this.readOnlyColumnIndexSet.contains(columnIndex) && !this.ignoreRows.contains(rowIndex)) {
            if (null == this.readOnlyCellStyle) {
                Workbook workbook = context.getWriteWorkbookHolder().getWorkbook();
                this.readOnlyCellStyle = workbook.createCellStyle();
                this.readOnlyCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                this.readOnlyCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                this.writeCellStyle = new WriteCellStyle();
                this.writeCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
                this.writeCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            }
            if (null == context.getFirstCellData().getWriteCellStyle()) {
                context.getFirstCellData().setWriteCellStyle(this.writeCellStyle);
            } else {
                WriteCellStyle customCellStyle = context.getFirstCellData().getWriteCellStyle();
                customCellStyle.setFillForegroundColor(Short.valueOf(IndexedColors.GREY_25_PERCENT.getIndex()));
                customCellStyle.setFillPatternType(FillPatternType.SOLID_FOREGROUND);
            }
            context.getCell().setCellStyle(this.readOnlyCellStyle);
        }
    }

    public Set<Integer> getEnableSheetNoSet() {
        return this.enableSheetNoSet;
    }

    public Set<String> getEnableSheetNameSet() {
        return this.enableSheetNameSet;
    }

    public Set<Integer> getReadOnlyColumnIndexSet() {
        return this.readOnlyColumnIndexSet;
    }

    public Set<Integer> getIgnoreRows() {
        return this.ignoreRows;
    }

    public CellStyle getReadOnlyCellStyle() {
        return this.readOnlyCellStyle;
    }

    public void setReadOnlyCellStyle(CellStyle readOnlyCellStyle) {
        this.readOnlyCellStyle = readOnlyCellStyle;
    }

    public void setEnableSheetNoSet(Set<Integer> enableSheetNoSet) {
        this.enableSheetNoSet = enableSheetNoSet;
    }

    public void setEnableSheetNameSet(Set<String> enableSheetNameSet) {
        this.enableSheetNameSet = enableSheetNameSet;
    }

    public void setReadOnlyColumnIndexSet(Set<Integer> readOnlyColumnIndexSet) {
        this.readOnlyColumnIndexSet = readOnlyColumnIndexSet;
    }

    public void setIgnoreRows(Set<Integer> ignoreRows) {
        this.ignoreRows = ignoreRows;
    }
}

