/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.function.loader;

import com.cyberway.mp.basic.data.api.metadata.FunctionProviderDefinitionApi;
import com.cyberway.mp.basic.data.api.metadata.vo.FunctionProviderDefinitionVo;
import com.cyberway.mp.entity.common.config.EntityCommonProperties;
import com.cyberway.mp.entity.common.function.ExtFunctionProviderLoader;
import com.cyberway.mp.entity.common.function.loader.JarDownloadExtFunctionProvider;
import java.util.List;
import org.springframework.boot.CommandLineRunner;

public class DefaultFunctionProviderLoader
extends JarDownloadExtFunctionProvider
implements ExtFunctionProviderLoader,
CommandLineRunner {
    private final FunctionProviderDefinitionApi functionProviderDefinitionApi;
    private final EntityCommonProperties entityCommonProperties;

    public DefaultFunctionProviderLoader(FunctionProviderDefinitionApi functionProviderDefinitionApi, EntityCommonProperties entityCommonProperties) {
        this.functionProviderDefinitionApi = functionProviderDefinitionApi;
        this.entityCommonProperties = entityCommonProperties;
    }

    @Override
    public void registerExtFunctionProvider() {
        if (this.entityCommonProperties.getLoadFunctionProviderAtStartDelaySeconds() > 0L) {
            try {
                Thread.sleep(this.entityCommonProperties.getLoadFunctionProviderAtStartDelaySeconds() * 1000L);
            }
            catch (InterruptedException e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        List functionProviderDefinitionVoList = this.functionProviderDefinitionApi.listEnableFunctionProviders();
        for (FunctionProviderDefinitionVo definition : functionProviderDefinitionVoList) {
            this.logger.info("registerExtFunctionProvider:{}", (Object)definition.getProviderKey());
            try {
                this.registerFunctionProvider(this.load(definition));
            }
            catch (Exception e) {
                this.logger.error("registerFunctionProvider error!", (Throwable)e);
            }
        }
    }

    public void run(String ... args) throws Exception {
        new Thread(() -> {
            try {
                this.registerExtFunctionProvider();
            }
            catch (Exception e) {
                this.logger.error("registerExtFunctionProvider error!", (Throwable)e);
            }
        }).start();
    }
}

