/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.function.loader;

import com.cyberway.mp.basic.data.api.metadata.vo.FunctionProviderDefinitionVo;
import com.cyberway.mp.entity.common.function.ExtFunctionProviderLoader;
import com.cyberway.mp.entity.common.function.FunctionProvider;
import com.cyberway.mp.entity.common.function.loader.LocalJarExtFunctionProvider;
import java.io.File;
import java.io.FileOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.springframework.beans.BeanUtils;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

public abstract class JarDownloadExtFunctionProvider
extends LocalJarExtFunctionProvider
implements ExtFunctionProviderLoader {
    private final RestTemplate restTemplate;
    private final File tempPath;

    protected JarDownloadExtFunctionProvider() {
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory();
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build();
            DefaultClientTlsStrategy defaultClientTlsStrategy = new DefaultClientTlsStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)defaultClientTlsStrategy).build();
            CloseableHttpClient httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).build();
            requestFactory.setHttpClient((HttpClient)httpClient);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        this.restTemplate = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        this.tempPath = new File(System.getProperty("function.provider.temp.path", "../data/providers"));
        this.tempPath.mkdirs();
    }

    @Override
    public FunctionProvider load(FunctionProviderDefinitionVo functionProviderDefinition) {
        FunctionProviderDefinitionVo newDef = new FunctionProviderDefinitionVo();
        BeanUtils.copyProperties((Object)functionProviderDefinition, (Object)newDef);
        String location = functionProviderDefinition.getLocation();
        if (StringUtils.isBlank((CharSequence)location)) {
            throw new IllegalArgumentException("location is null or empty");
        }
        if (location.startsWith("http")) {
            String urlMd5 = DigestUtils.md5Hex((String)location);
            File file = new File(this.tempPath, newDef.getProviderKey() + "_" + urlMd5 + ".jar");
            newDef.setLocation(file.getAbsolutePath());
            this.logger.debug("file is exists:{}", (Object)file.exists());
            if (file.exists() && file.length() > 0L) {
                return super.load(newDef);
            }
            byte[] jarByteArr = (byte[])this.restTemplate.getForEntity(location, byte[].class, new Object[0]).getBody();
            try (FileOutputStream fos = new FileOutputStream(file);){
                fos.write(jarByteArr);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            return super.load(newDef);
        }
        return super.load(newDef);
    }
}

