/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.function.loader;

import com.cyberway.mp.basic.data.api.metadata.vo.FunctionProviderDefinitionVo;
import com.cyberway.mp.entity.common.function.ExtFunctionProviderLoader;
import com.cyberway.mp.entity.common.function.FunctionProvider;
import com.cyberway.mp.entity.common.function.loader.FunctionProviderClassLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalJarExtFunctionProvider
implements ExtFunctionProviderLoader {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, FunctionProviderClassLoader> classLoaders = new ConcurrentHashMap<String, FunctionProviderClassLoader>();
    private final Map<String, FunctionProvider> loadedProviderMap = new ConcurrentHashMap<String, FunctionProvider>();

    @Override
    public FunctionProvider getByProviderKey(String providerKey) {
        if (!StringUtils.isBlank((CharSequence)providerKey)) {
            for (FunctionProvider value : this.loadedProviderMap.values()) {
                if (!providerKey.equals(value.getProviderKey())) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public List<FunctionProvider> getLoadedFunctionProviders() {
        return new ArrayList<FunctionProvider>(this.loadedProviderMap.values());
    }

    @Override
    public FunctionProvider getByProviderClassName(String providerClassName) {
        return this.loadedProviderMap.get(providerClassName);
    }

    @Override
    public void registerFunctionProvider(FunctionProvider functionProvider) {
        if (null == functionProvider) {
            throw new IllegalArgumentException("functionProvider is not allow null");
        }
        String functionProviderClassName = functionProvider.getClass().getName();
        FunctionProvider existFunctionProvider = this.loadedProviderMap.get(functionProviderClassName);
        if (null != existFunctionProvider) {
            throw new IllegalArgumentException("functionProviderClassName [" + functionProviderClassName + "] is repeat");
        }
        functionProvider.init();
        this.loadedProviderMap.put(functionProviderClassName, functionProvider);
    }

    @Override
    public FunctionProvider load(FunctionProviderDefinitionVo functionProviderDefinition) {
        String location = functionProviderDefinition.getLocation();
        if (StringUtils.isBlank((CharSequence)location)) {
            throw new IllegalArgumentException("location is null or empty");
        }
        if (StringUtils.isBlank((CharSequence)functionProviderDefinition.getProviderKey())) {
            throw new IllegalArgumentException("providerKey is null or empty");
        }
        try {
            FunctionProvider functionProvider;
            URL url = !location.contains("://") ? new File(location).toURI().toURL() : new URL("jar:" + location + "!/");
            URL fLocation = url;
            FunctionProviderClassLoader classLoader = this.classLoaders.compute(functionProviderDefinition.getProviderKey(), (key, old) -> {
                if (null != old) {
                    this.closeClassLoader((FunctionProviderClassLoader)old);
                }
                return this.createClassLoader(fLocation);
            });
            this.logger.debug("load functionProvider from : {}", (Object)location);
            String providerClassName = functionProviderDefinition.getProviderClassName();
            if (StringUtils.isNotBlank((CharSequence)providerClassName)) {
                FunctionProvider existFunctionProvider = this.loadedProviderMap.remove(functionProviderDefinition.getProviderClassName());
                if (null != existFunctionProvider) {
                    existFunctionProvider.dispose();
                }
                functionProvider = (FunctionProvider)Class.forName(providerClassName, true, classLoader).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            } else {
                functionProvider = ServiceLoader.load(FunctionProvider.class, classLoader).iterator().next();
            }
            return functionProvider;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void enable(FunctionProviderDefinitionVo functionProviderDefinition) {
        this.registerFunctionProvider(this.load(functionProviderDefinition));
    }

    @Override
    public void disable(FunctionProviderDefinitionVo functionProviderDefinition) {
        FunctionProvider existFunctionProvider = null;
        if (null != functionProviderDefinition && StringUtils.isNotBlank((CharSequence)functionProviderDefinition.getProviderClassName())) {
            existFunctionProvider = this.loadedProviderMap.remove(functionProviderDefinition.getProviderClassName());
        } else if (null != functionProviderDefinition && StringUtils.isNotBlank((CharSequence)functionProviderDefinition.getProviderKey())) {
            String providerClassName = "";
            for (FunctionProvider value : this.loadedProviderMap.values()) {
                if (!functionProviderDefinition.getProviderKey().equals(value.getProviderKey())) continue;
                providerClassName = value.getClass().getName();
                break;
            }
            existFunctionProvider = this.loadedProviderMap.remove(providerClassName);
        }
        if (null != existFunctionProvider) {
            existFunctionProvider.dispose();
            FunctionProviderClassLoader classLoader = this.classLoaders.remove(existFunctionProvider.getProviderKey());
            if (null != classLoader) {
                this.closeClassLoader(classLoader);
            }
        }
    }

    private FunctionProviderClassLoader createClassLoader(URL fLocation) {
        return new FunctionProviderClassLoader(new URL[]{fLocation}, this.getClass().getClassLoader());
    }

    protected void closeClassLoader(FunctionProviderClassLoader classLoader) {
        try {
            classLoader.close();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

