/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.service;

import com.cyberway.mp.bbc.remotejob.handler.RemoteJobHandler;
import com.cyberway.mp.bbc.remotejob.vo.RemoteJobResultVo;
import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.entity.common.EntityToolErrorCode;
import com.cyberway.mp.entity.common.dto.CategoryTreeNodeCache;
import com.cyberway.mp.entity.common.feign.CategoryFeignClient;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class CategoryCacheService
implements RemoteJobHandler {
    public static final String CATEGORY_CACHE_REFRESH_JOB = "CategoryCacheRefreshJob";
    private static final CategoryTreeNodeCache NULL_CACHE = new CategoryTreeNodeCache();
    private final CategoryFeignClient categoryFeignClient;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, CategoryTreeNodeCache> categoryCache = new ConcurrentHashMap<String, CategoryTreeNodeCache>(16);

    public CategoryCacheService(CategoryFeignClient categoryFeignClient) {
        this.categoryFeignClient = categoryFeignClient;
    }

    public CategoryTreeNodeCache getCategoryCache(String categoryCode) {
        CategoryTreeNodeCache result;
        String cacheKey = this.buildCacheKey(this.getCurrentNotNullTenantId(), categoryCode);
        if (this.categoryCache.containsKey(cacheKey)) {
            result = this.categoryCache.get(cacheKey);
        } else {
            this.refreshCache(null);
            result = this.categoryCache.computeIfAbsent(cacheKey, k -> NULL_CACHE);
        }
        if (result == null || result.equals(NULL_CACHE)) {
            return null;
        }
        return result;
    }

    public void refreshCache(String typeCode) {
        long tenantId = this.getCurrentNotNullTenantId();
        List categoryTreeNodeCaches = (List)this.categoryFeignClient.getTreeByTypeCode(typeCode, tenantId).getData();
        this.refreshCategoryCache(tenantId, categoryTreeNodeCaches);
        this.logger.debug("refreshCache:{}", (Object)typeCode);
    }

    private void refreshCategoryCache(long tenantId, List<CategoryTreeNodeCache> categoryTreeNodeCaches) {
        if (CollectionUtils.isEmpty(categoryTreeNodeCaches)) {
            return;
        }
        for (CategoryTreeNodeCache categoryTreeNodeCache : categoryTreeNodeCaches) {
            String cacheKey = this.buildCacheKey(tenantId, categoryTreeNodeCache.getCode());
            this.categoryCache.put(cacheKey, categoryTreeNodeCache);
            this.refreshCategoryCache(tenantId, categoryTreeNodeCache.getSubCategoryList());
        }
    }

    private String buildCacheKey(long tenantId, String code) {
        return tenantId + ":" + code;
    }

    public boolean supportHandler(String jobType) {
        return CATEGORY_CACHE_REFRESH_JOB.equalsIgnoreCase(jobType);
    }

    public RemoteJobResultVo handle(String typeCode) {
        this.refreshCache(typeCode);
        return new RemoteJobResultVo();
    }

    public String getHandlerId() {
        return null;
    }

    private long getCurrentNotNullTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        AssertUtil.notNull((Object)tenantId, (ErrorCode)EntityToolErrorCode.USER_NOT_CHOOSE_TENANT, (Object[])new Object[0]);
        return tenantId;
    }
}

