/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.service;

import com.cyberway.mp.basic.data.api.metadata.FieldPropertyType;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.entity.common.config.EntityCommonProperties;
import com.cyberway.mp.entity.common.dto.EntityDto;
import com.cyberway.mp.entity.common.dto.EntityDtoForChange;
import com.cyberway.mp.entity.common.dto.EntityFieldDto;
import com.cyberway.mp.entity.common.dto.EntityRelateDto;
import com.cyberway.mp.entity.common.dto.FieldDtoForChange;
import com.cyberway.mp.entity.common.feign.EntityDataFeignClient;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;

public class EntityDataCacheService {
    private static final String DATA_TYPE_INTEGER = "Integer";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final EntityDataFeignClient entityDataFeignClient;
    private final ConcurrentHashMap<String, EntityDto> entityDtoCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> nullableEntityCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, EntityDtoForChange> dataChangeDtoCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> tableNameMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, EntityRelateDto> enableLoggingRelateTableCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, String> tableNameEntityCodeMap = new ConcurrentHashMap();
    @Value(value="${spring.application.name:}")
    private String registerName;

    public EntityDataCacheService(EntityDataFeignClient entityDataFeignClient, EntityCommonProperties entityCommonProperties) {
        this.entityDataFeignClient = entityDataFeignClient;
        if (entityCommonProperties.isLoadEntityCacheAtStart()) {
            ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(1, r -> {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                thread.setName(this.getClass().getName() + "PullCacheTask");
                return thread;
            });
            scheduledExecutorService.schedule(this.getPullTask(), entityCommonProperties.getLoadEntityCacheAtStartDelaySeconds(), TimeUnit.SECONDS);
        }
    }

    private String buildTenantCacheKey(String sourceKey, Long tenantId) {
        return ObjectUtils.defaultIfNull((Object)tenantId, (Object)0L) + "_" + sourceKey;
    }

    protected Runnable getPullTask() {
        return new DefaultPullTack();
    }

    public EntityDto getFromTableName(String tableName) {
        String entityCode = this.tableNameEntityCodeMap.get(this.buildTenantCacheKey(tableName, ServiceContext.getContext().getRequestTenantId()));
        if (null == entityCode) {
            return null;
        }
        return this.getFromCache(entityCode);
    }

    public EntityDto getFromCache(String entityCode) {
        return this.getFromCache(entityCode, ServiceContext.getContext().getRequestTenantId());
    }

    public EntityDto getFromCache(String entityCode, Long tenantId) {
        String key = this.buildTenantCacheKey(entityCode, tenantId);
        if (this.nullableEntityCache.contains(key)) {
            return null;
        }
        EntityDto entityDto = this.entityDtoCache.get(key);
        if (entityDto == null) {
            return this.refreshEntityCache(entityCode, tenantId);
        }
        return entityDto;
    }

    public EntityDtoForChange getChangeDtoByTableName(String tableName) {
        return this.getChangeDtoByTableName(tableName, ServiceContext.getContext().getRequestTenantId());
    }

    public EntityDtoForChange getChangeDtoByTableName(String tableName, Long tenantId) {
        return this.dataChangeDtoCache.get(this.buildTenantCacheKey(tableName.toLowerCase(), tenantId));
    }

    public EntityDtoForChange getChangeDtoByCode(String entityCode) {
        return this.getChangeDtoByCode(entityCode, ServiceContext.getContext().getRequestTenantId());
    }

    public EntityDtoForChange getChangeDtoByCode(String entityCode, Long tenantId) {
        String tableName = this.tableNameMap.get(this.buildTenantCacheKey(entityCode, tenantId));
        if (tableName == null) {
            return null;
        }
        return this.getChangeDtoByTableName(tableName, tenantId);
    }

    public EntityRelateDto getEnableLoggingRelateDto(String tableName) {
        return this.getEnableLoggingRelateDto(tableName, ServiceContext.getContext().getRequestTenantId());
    }

    public EntityRelateDto getEnableLoggingRelateDto(String tableName, Long tenantId) {
        return this.enableLoggingRelateTableCache.get(this.buildTenantCacheKey(tableName.toLowerCase(), tenantId));
    }

    public void putCache(String entityCode, EntityDto entityDto) {
        this.logger.info("\u5b9e\u4f53\u5143\u6570\u636e[{}, {}]\u653e\u5165\u7f13\u5b58", (Object)entityCode, (Object)entityDto.getTenantId());
        this.entityDtoCache.put(this.buildTenantCacheKey(entityCode, entityDto.getTenantId()), entityDto);
        String tableName = entityDto.getRealTableName();
        if (StringUtils.isNotBlank((CharSequence)tableName)) {
            this.tableNameEntityCodeMap.put(this.buildTenantCacheKey(tableName, entityDto.getTenantId()), entityCode);
        }
    }

    public void deleteCache(String entityCode, Long tenantId) {
        this.entityDtoCache.remove(this.buildTenantCacheKey(entityCode, tenantId));
    }

    public void refreshEntityCacheByRegisterName(String registerName) {
        List entityDtoList = (List)this.entityDataFeignClient.loadReleaseEntityMetadataForToolByRegisterName(registerName).getData();
        entityDtoList.forEach(this::putCacheAndHandleVersion);
    }

    public void putCacheAndHandleVersion(EntityDto entityDto) {
        if ("TREE".equals(entityDto.getStructType())) {
            entityDto.addEntityField(EntityDto.buildSimpleField("tree_parent_id", "Long"));
            entityDto.addEntityField(EntityDto.buildSimpleField("tree_left_no", DATA_TYPE_INTEGER));
            entityDto.addEntityField(EntityDto.buildSimpleField("tree_right_no", DATA_TYPE_INTEGER));
        }
        if (!"SELF".equals(entityDto.getDataManageType())) {
            String entityCodeCacheKey;
            if (Boolean.TRUE.equals(entityDto.getLogicDelete())) {
                entityDto.addEntityField(EntityDto.buildSimpleField("deleted", DATA_TYPE_INTEGER));
            }
            if (this.tableNameMap.containsKey(entityCodeCacheKey = this.buildTenantCacheKey(entityDto.getCode(), entityDto.getTenantId()))) {
                String oldTableNameCacheKey = this.buildTenantCacheKey(this.tableNameMap.remove(entityCodeCacheKey), entityDto.getTenantId());
                this.dataChangeDtoCache.remove(oldTableNameCacheKey);
            }
            if (Boolean.TRUE.equals(entityDto.getSupportVersion())) {
                EntityDto editEntityDto = EntityDto.buildEditEntityDto(entityDto);
                this.putCache(entityDto.getVersionEditTableName(), editEntityDto);
                this.putCache(entityDto.getVersionHisTableName(), EntityDto.buildHisEntityDto(entityDto));
                entityDto.addEntityField(EntityDto.buildSimpleField("version_no", DATA_TYPE_INTEGER));
                if (Boolean.TRUE.equals(entityDto.getLogChange())) {
                    String lowerCaseTableName = entityDto.getVersionEditTableName().toLowerCase();
                    this.tableNameMap.put(entityCodeCacheKey, lowerCaseTableName);
                    this.dataChangeDtoCache.put(this.buildTenantCacheKey(lowerCaseTableName, entityDto.getTenantId()), this.buildDtoForChange(editEntityDto));
                }
            } else if (Boolean.TRUE.equals(entityDto.getLogChange())) {
                String lowerCaseTableName = entityDto.getRealTableName().toLowerCase();
                this.tableNameMap.put(entityCodeCacheKey, lowerCaseTableName);
                this.dataChangeDtoCache.put(this.buildTenantCacheKey(lowerCaseTableName, entityDto.getTenantId()), this.buildDtoForChange(entityDto));
            }
            this.buildEnableLoggingRelateTableCache(entityDto);
        }
        this.putCache(entityDto.getCode(), entityDto);
    }

    private EntityDtoForChange buildDtoForChange(EntityDto entityDto) {
        EntityDtoForChange entity = new EntityDtoForChange();
        BeanUtils.copyProperties((Object)entityDto, (Object)entity);
        HashMap<String, String> colNameMap = new HashMap<String, String>(16);
        this.initEntityColsInfo(entityDto, colNameMap, entity);
        this.getEnableEnableLoggingRelates(entityDto).forEach(r -> entity.getLogDetailRelates().add((EntityRelateDto)r));
        return entity;
    }

    private void initEntityColsInfo(EntityDto entityDto, Map<String, String> colNameMap, EntityDtoForChange entity) {
        if (entityDto.getEntityFields() == null) {
            return;
        }
        for (EntityFieldDto entityField : entityDto.getEntityFields()) {
            colNameMap.put(entityField.getCode(), entityField.getRealColName().toLowerCase());
            if (!"id".equals(entityField.getCode()) && !Boolean.TRUE.equals(entityField.getNameField()) && !Boolean.TRUE.equals(entityField.getLogChange()) && !Boolean.TRUE.equals(entityField.getLogDetail())) continue;
            FieldDtoForChange field = new FieldDtoForChange();
            BeanUtils.copyProperties((Object)entityField, (Object)field);
            entity.getFieldMap().put(field.getRealColName(), field);
            if (Boolean.TRUE.equals(entityField.getNameField()) && StringUtils.isNotBlank((CharSequence)entityField.getRealColName())) {
                entity.getNameCols().add(field.getRealColName());
            }
            if (Boolean.TRUE.equals(entityField.getLogChange()) && StringUtils.isNotBlank((CharSequence)entityField.getRealColName()) && !FieldPropertyType.RELATE.equals((Object)entityField.getFieldPropertyType())) {
                entity.getChangeCols().add(field.getRealColName());
            }
            if (!Boolean.TRUE.equals(entityField.getLogDetail()) || !StringUtils.isNotBlank((CharSequence)entityField.getRealColName())) continue;
            entity.getDetailCols().add(field.getRealColName());
        }
    }

    private void buildEnableLoggingRelateTableCache(EntityDto entityDto) {
        this.getEnableEnableLoggingRelates(entityDto).forEach(r -> this.enableLoggingRelateTableCache.put(this.buildTenantCacheKey(r.getRelateTableName().toLowerCase(), entityDto.getTenantId()), (EntityRelateDto)r));
    }

    private List<EntityRelateDto> getEnableEnableLoggingRelates(EntityDto entityDto) {
        if (entityDto.getEntityRelates() != null) {
            Set enableLogRelateCode = entityDto.getEntityFields().stream().filter(f -> FieldPropertyType.RELATE.equals((Object)f.getFieldPropertyType()) && null != f.getRelateId()).filter(f -> Boolean.TRUE.equals(f.getLogChange()) || Boolean.TRUE.equals(f.getLogDetail())).map(f -> String.valueOf(f.getRelateId())).collect(Collectors.toSet());
            return entityDto.getEntityRelates().stream().filter(r -> enableLogRelateCode.contains(r.getRelateCode())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public EntityDto refreshEntityCache(String entityCode, Long tenantId) {
        EntityDto entityDto = this.loadRelease(entityCode, tenantId);
        String key = this.buildTenantCacheKey(entityCode, tenantId);
        if (entityDto != null) {
            this.nullableEntityCache.remove(key);
            this.putCacheAndHandleVersion(entityDto);
        } else {
            this.nullableEntityCache.put(key, entityCode);
        }
        return entityDto;
    }

    public EntityDto loadRelease(String entityCode, Long tenantId) {
        return (EntityDto)this.entityDataFeignClient.loadReleaseEntityMetadataForTool(entityCode, tenantId).getData();
    }

    public List<EntityDto> listByCenterCode(String centerCode) {
        return this.entityDtoCache.values().stream().filter(entityDto -> centerCode.equals(entityDto.getCenterCode())).collect(Collectors.toList());
    }

    class DefaultPullTack
    implements Runnable {
        DefaultPullTack() {
        }

        @Override
        public void run() {
            if (StringUtils.isBlank((CharSequence)EntityDataCacheService.this.registerName)) {
                EntityDataCacheService.this.logger.info("registerName\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u5b9e\u4f53\u5143\u6570\u636e\u7684\u62c9\u53d6");
                return;
            }
            EntityDataCacheService.this.logger.info("\u62c9\u53d6\u5b9e\u4f53\u5143\u6570\u636e\u4efb\u52a1\u5f00\u59cb,\u670d\u52a1\u6ce8\u518c\u540d\u79f0:{}", (Object)EntityDataCacheService.this.registerName);
            try {
                EntityDataCacheService.this.refreshEntityCacheByRegisterName(EntityDataCacheService.this.registerName);
            }
            catch (Exception e) {
                EntityDataCacheService.this.logger.error("\u62c9\u53d6\u4efb\u52a1\u5f02\u5e38", (Throwable)e);
            }
            EntityDataCacheService.this.logger.info("\u62c9\u53d6\u5b9e\u4f53\u5143\u6570\u636e\u4efb\u52a1\u7ed3\u675f...");
        }
    }
}

