/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.mp.bbc.remotejob.handler.RemoteJobHandler;
import com.cyberway.mp.bbc.remotejob.vo.RemoteJobResultVo;
import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.entity.common.EntityToolErrorCode;
import com.cyberway.mp.entity.common.dto.EntityFlowConfigDto;
import com.cyberway.mp.entity.common.feign.EntityDataFeignClient;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityFlowConfigCacheService
implements RemoteJobHandler {
    public static final String ENTITY_FLOW_CONFIG_CACHE_REFRESH_JOB = "EntityFlowConfigCacheRefreshJob";
    private final EntityDataFeignClient entityDataFeignClient;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<String, List<EntityFlowConfigDto>> flowConfigCache = new ConcurrentHashMap<String, List<EntityFlowConfigDto>>(16);

    public EntityFlowConfigCacheService(EntityDataFeignClient entityDataFeignClient) {
        this.entityDataFeignClient = entityDataFeignClient;
    }

    public List<EntityFlowConfigDto> getFlowConfigCache(String entityCode) {
        long tenantId = this.getCurrentNotNullTenantId();
        String cacheKey = this.buildCacheKey(tenantId, entityCode);
        if (this.flowConfigCache.containsKey(cacheKey)) {
            return this.flowConfigCache.get(cacheKey);
        }
        this.refreshCache(entityCode, tenantId);
        if (!this.flowConfigCache.containsKey(cacheKey)) {
            this.flowConfigCache.put(cacheKey, Collections.emptyList());
        }
        return this.flowConfigCache.get(cacheKey);
    }

    public void refreshCache(String entityCode, Long tenantId) {
        List data = (List)this.entityDataFeignClient.getFlowConfigByEntityCode(entityCode, tenantId).getData();
        this.putCache(entityCode, tenantId, data);
    }

    public void putCache(String entityCode, Long tenantId, List<EntityFlowConfigDto> data) {
        String cacheKey = this.buildCacheKey(tenantId, entityCode);
        this.flowConfigCache.put(cacheKey, data == null ? Collections.emptyList() : data);
        this.logger.debug("putEntityFlowConfigCache: entityCode: {}, tenantId: {}", (Object)entityCode, (Object)tenantId);
    }

    private String buildCacheKey(long tenantId, String code) {
        return tenantId + ":" + code;
    }

    public boolean supportHandler(String jobType) {
        return ENTITY_FLOW_CONFIG_CACHE_REFRESH_JOB.equalsIgnoreCase(jobType);
    }

    public RemoteJobResultVo handle(String json) {
        JSONObject jsonObject = JSON.parseObject((String)json);
        this.refreshCache(jsonObject.getString("entityCode"), jsonObject.getLong("tenantId"));
        return new RemoteJobResultVo();
    }

    public String getHandlerId() {
        return null;
    }

    private long getCurrentNotNullTenantId() {
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        AssertUtil.notNull((Object)tenantId, (ErrorCode)EntityToolErrorCode.USER_NOT_CHOOSE_TENANT, (Object[])new Object[0]);
        return tenantId;
    }
}

