/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.entity.common.util;

import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class CaseUtils {
    private CaseUtils() {
    }

    public static BigDecimal caseBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return new BigDecimal(value.toString());
    }

    public static Long caseLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return Long.parseLong(value.toString());
    }

    public static Date caseDate(Object value) throws ParseException {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof LocalDateTime) {
            return Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
        }
        if (value instanceof LocalDate) {
            return Date.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return DateUtils.parseDate((String)value.toString(), (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ssXXX", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.sss", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd"});
    }

    public static Integer castInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return Integer.parseInt(value.toString());
    }

    public static Double castDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return Double.parseDouble(value.toString());
    }

    public static Float castFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    public static Short castShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return Short.parseShort(value.toString());
    }

    public static Boolean castBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (StringUtils.isBlank((CharSequence)value.toString())) {
            return null;
        }
        return Boolean.parseBoolean(value.toString()) || "1".equals(value.toString());
    }
}

