/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.application.service;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.cyberway.mp.bbc.api.api.ApiDatasourceApi;
import com.cyberway.mp.bbc.api.api.ApiErrorCode;
import com.cyberway.mp.bbc.api.api.dto.ApiBundleCreateForEntityCreateDto;
import com.cyberway.mp.bbc.api.api.dto.ApiChangeStatusDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourceCreateDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourceModifyDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourcePageDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourceSelectDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDocExtractDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDocImportDto;
import com.cyberway.mp.bbc.api.api.vo.ApiDatasourceListVo;
import com.cyberway.mp.bbc.api.api.vo.ApiDatasourceVo;
import com.cyberway.mp.bbc.api.api.vo.ApiDocImportVo;
import com.cyberway.mp.bbc.api.api.vo.ApiEntityFieldEnumDto;
import com.cyberway.mp.bbc.api.api.vo.ApiEntityFieldVo;
import com.cyberway.mp.bbc.api.api.vo.ApiEntityVo;
import com.cyberway.mp.bbc.api.domain.entity.ApiDatasource;
import com.cyberway.mp.bbc.api.domain.service.ApiDatasourceCacheService;
import com.cyberway.mp.bbc.api.domain.service.ApiDatasourceService;
import com.cyberway.mp.bbc.api.infra.utils.OpenDocUtil;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.enums.DataType;
import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class ApiDatasourceApplicationService
implements ApiDatasourceApi {
    private static final String WIDGET_INPUT = "input";
    private final ApiDatasourceService apiDatasourceService;
    private final ApiDatasourceCacheService cacheService;

    public ApiDatasourceApplicationService(ApiDatasourceService apiDatasourceService, @Autowired(required=false) ApiDatasourceCacheService cacheService) {
        this.apiDatasourceService = apiDatasourceService;
        this.cacheService = cacheService;
    }

    @Override
    public long createApi(ApiDatasourceCreateDto dto) {
        ApiDatasource apiDatasource = ApiDatasource.fromApiDatasourceCreateDto(dto);
        this.apiDatasourceService.createApi(apiDatasource);
        this.saveCache(apiDatasource);
        return (Long)apiDatasource.getId();
    }

    @Override
    public void modifyApi(ApiDatasourceModifyDto dto) {
        ApiDatasource apiDatasource = ApiDatasource.fromApiDatasourceCreateDto(dto);
        apiDatasource.setId(dto.getId());
        this.apiDatasourceService.modifyApi(apiDatasource);
        this.saveCache(apiDatasource);
    }

    @Override
    public void deleteApi(long id) {
        this.apiDatasourceService.deleteApi(id);
        this.removeCache(id);
    }

    @Override
    public void batchDeleteApi(List<Long> ids) {
        this.apiDatasourceService.batchDeleteApi(ids);
        this.removeCaches(ids);
    }

    @Override
    public ApiDatasourceVo getApi(long id) {
        ApiDatasource api = this.findCache(id);
        if (api == null) {
            api = this.apiDatasourceService.getApi(id);
            AssertUtil.notNull((Object)((Object)api), (ErrorCode)ApiErrorCode.OBJECT_NOT_FOUND, (Object[])new Object[]{id});
            this.saveCache(api);
        }
        return api.toVo();
    }

    @Override
    public List<ApiDatasourceVo> batchGetApi(Collection<Long> ids) {
        return this.apiDatasourceService.findByIds(ids).stream().map(ApiDatasource::toVo).collect(Collectors.toList());
    }

    @Override
    public List<ApiDatasourceVo> batchGetApiByCodes(Collection<String> codes) {
        return this.apiDatasourceService.findByCodes(codes).stream().map(ApiDatasource::toVo).collect(Collectors.toList());
    }

    @Override
    public List<ApiDatasourceVo> batchGetApiByPaths(Collection<String> paths) {
        return this.apiDatasourceService.findByPaths(paths).stream().map(ApiDatasource::toVo).collect(Collectors.toList());
    }

    @Override
    public Page<ApiDatasourceListVo> pageQueryApi(ApiDatasourcePageDto dto) {
        return this.apiDatasourceService.pageQueryApi(dto);
    }

    @Override
    public List<ApiDatasourceListVo> listApi(ApiDatasourcePageDto dto) {
        return this.apiDatasourceService.listApi(dto).stream().map(ApiDatasource::toListVo).collect(Collectors.toList());
    }

    @Override
    public void changeStatus(ApiChangeStatusDto dto) {
        ApiDatasource apiDatasource = new ApiDatasource();
        apiDatasource.setId(dto.getId());
        apiDatasource.setStatus(dto.getStatus());
        this.apiDatasourceService.modifyApi(apiDatasource);
        this.saveCache(apiDatasource);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bundleCreateForEntity(ApiBundleCreateForEntityCreateDto dto) {
        this.apiDatasourceService.bundleCreateForEntity(dto);
    }

    @Override
    public List<ApiDatasourceSelectDto> extractApiDoc(ApiDocExtractDto dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getDocContent())) {
            return OpenDocUtil.extractSelectApisByContent(dto.getDocContent());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getDocUrl())) {
            return OpenDocUtil.extractSelectApisByUrl(dto.getDocUrl());
        }
        return Collections.emptyList();
    }

    @Override
    public ApiDocImportVo importApiDoc(ApiDocImportDto dto) {
        List<ApiDatasource> list;
        ApiDocImportVo vo = new ApiDocImportVo();
        if (StringUtils.isNotBlank((CharSequence)dto.getDocContent())) {
            list = OpenDocUtil.buildApiDatasourceFromDocContent(dto.getServiceName(), dto.getRoutePath(), dto.getDocContent(), dto.getSelectApis());
        } else if (StringUtils.isNotBlank((CharSequence)dto.getDocUrl())) {
            list = OpenDocUtil.buildApiDatasourceFromDocUrl(dto.getServiceName(), dto.getRoutePath(), dto.getDocUrl(), dto.getSelectApis());
        } else {
            return vo;
        }
        if (list.isEmpty()) {
            return vo;
        }
        List<ApiDatasource> oldList = this.apiDatasourceService.listInService(dto.getServiceName());
        Map<String, List<ApiDatasource>> oldApiMapByCode = oldList.stream().collect(Collectors.groupingBy(ApiDatasource::getCode));
        Set<String> selectKeys = dto.getSelectApis() != null ? dto.getSelectApis().stream().map(ApiDatasourceSelectDto::toKey).collect(Collectors.toSet()) : Collections.emptySet();
        list.forEach(api -> {
            if (oldApiMapByCode.containsKey(api.getCode())) {
                List oldApis = (List)oldApiMapByCode.get(api.getCode());
                if (oldApis.size() > 1) {
                    vo.setFailNum(vo.getFailNum() + 1);
                    vo.getFailReason().put(new ApiDatasourceSelectDto(api.getMethod(), api.getPath()), "\u670d\u52a1[" + dto.getServiceName() + "]\u5b58\u5728\u591a\u4e2a\u8bf7\u6c42\u65b9\u6cd5\u4e3a[" + api.getMethod() + "], \u8def\u5f84\u4e3a[" + api.getPath() + "]\u7684\u63a5\u53e3");
                    return;
                }
                ApiDatasource oldApi = (ApiDatasource)((Object)((Object)oldApis.get(0)));
                BeanUtil.copyProperties((Object)api, (Object)((Object)oldApi), (CopyOptions)new CopyOptions().ignoreNullValue().setIgnoreProperties(new String[]{"status", "fieldAuthEnabled"}));
                this.apiDatasourceService.modifyApi(oldApi);
                vo.setUpdateNum(vo.getUpdateNum() + 1);
                return;
            }
            this.apiDatasourceService.createApi((ApiDatasource)((Object)api));
            vo.setAddNum(vo.getAddNum() + 1);
        });
        if (!selectKeys.isEmpty()) {
            vo.setFailNum(vo.getFailNum() + selectKeys.size());
            selectKeys.forEach(key -> vo.getFailReason().put(ApiDatasourceSelectDto.fromKey(key), "\u6587\u6863\u4e2d\u627e\u4e0d\u5230\u8be5\u63a5\u53e3"));
        }
        return vo;
    }

    @Override
    public ApiEntityVo loadApiEntityMetadata(String apiCode) {
        JSONObject param;
        int i;
        List<ApiDatasource> apis = this.apiDatasourceService.findByCodes(Collections.singleton(apiCode));
        if (apis.isEmpty()) {
            return null;
        }
        ApiDatasource apiDatasource = apis.get(0);
        ApiEntityVo vo = new ApiEntityVo();
        vo.setName(apiDatasource.getName());
        vo.setCode(apiDatasource.getCode());
        vo.setUrlPrefix(apiDatasource.getRoutePath());
        vo.setDescription(apiDatasource.getDescription());
        ArrayList<ApiEntityFieldVo> requestFields = new ArrayList<ApiEntityFieldVo>();
        ArrayList<ApiEntityFieldVo> responseFields = new ArrayList<ApiEntityFieldVo>();
        vo.setRequestFields(requestFields);
        vo.setResponseFields(responseFields);
        JSONObject paramSchemas = StringUtils.isNotBlank((CharSequence)apiDatasource.getParamSchema()) ? JSON.parseObject((String)apiDatasource.getParamSchema(), (Feature[])new Feature[]{Feature.DisableCircularReferenceDetect}) : new JSONObject();
        JSONArray array = JSON.parseArray((String)apiDatasource.getPathParams(), (Feature[])new Feature[]{Feature.DisableCircularReferenceDetect});
        for (i = 0; i < array.size(); ++i) {
            param = array.getJSONObject(i);
            this.addParamApiField(requestFields, param, "path", paramSchemas);
        }
        array = JSON.parseArray((String)apiDatasource.getUrlParams(), (Feature[])new Feature[]{Feature.DisableCircularReferenceDetect});
        for (i = 0; i < array.size(); ++i) {
            param = array.getJSONObject(i);
            this.addParamApiField(requestFields, param, "url", paramSchemas);
        }
        if (StringUtils.isNotBlank((CharSequence)apiDatasource.getRequestBody())) {
            JSONObject requestBody = JSON.parseObject((String)apiDatasource.getRequestBody(), (Feature[])new Feature[]{Feature.DisableCircularReferenceDetect});
            this.addBodyApiField(requestFields, requestBody, paramSchemas);
        }
        if (StringUtils.isNotBlank((CharSequence)apiDatasource.getResponseBody())) {
            JSONObject responseBody = JSON.parseObject((String)apiDatasource.getResponseBody(), (Feature[])new Feature[]{Feature.DisableCircularReferenceDetect});
            this.addBodyApiField(responseFields, responseBody, paramSchemas);
        }
        return vo;
    }

    private void addParamApiField(ArrayList<ApiEntityFieldVo> fields, JSONObject param, String codePrefix, JSONObject paramSchemas) {
        String code = param.getString("name");
        String description = param.getString("description");
        String name = (String)StringUtils.defaultIfBlank((CharSequence)description, (CharSequence)code);
        JSONObject schema = param.getJSONObject("schema");
        boolean required = Boolean.TRUE.equals(param.getBoolean("required"));
        ApiEntityFieldVo sampleVo = this.buildApiField(code, name, description, codePrefix);
        sampleVo.setAllowEmpty(!required);
        this.addApiField(fields, schema, sampleVo, paramSchemas);
    }

    private void addBodyApiField(ArrayList<ApiEntityFieldVo> fields, JSONObject body, JSONObject paramSchemas) {
        JSONObject schema = body.getJSONObject("schema");
        ApiEntityFieldVo sampleVo = this.buildApiField("", "", "", "body");
        sampleVo.setAllowEmpty(true);
        this.addApiField(fields, schema, sampleVo, paramSchemas);
    }

    private void addPropertyApiField(ArrayList<ApiEntityFieldVo> fields, JSONObject param, String codePrefix, JSONObject paramSchemas) {
        JSONObject properties = param.getJSONObject("properties");
        HashSet<String> requiredKeys = new HashSet<String>();
        JSONArray required = param.getJSONArray("required");
        if (required != null) {
            for (int i = 0; i < required.size(); ++i) {
                requiredKeys.add(required.getString(i));
            }
        }
        properties.keySet().forEach(key -> {
            JSONObject property = properties.getJSONObject(key);
            String name = (String)StringUtils.defaultIfBlank((CharSequence)property.getString("title"), (CharSequence)key);
            String description = property.getString("description");
            ApiEntityFieldVo sampleVo = this.buildApiField((String)key, name, description, codePrefix);
            sampleVo.setAllowEmpty(!requiredKeys.contains(key));
            this.addApiField(fields, property, sampleVo, paramSchemas);
        });
    }

    private void addApiField(ArrayList<ApiEntityFieldVo> fields, JSONObject schema, ApiEntityFieldVo sampleVo, JSONObject paramSchemas) {
        String ref = schema.getString("$ref");
        String type = schema.getString("type");
        if (StringUtils.isNotBlank((CharSequence)ref)) {
            JSONObject refSchema = paramSchemas.getJSONObject(ref = ref.replace("#/components/schemas/", ""));
            if (refSchema != null && refSchema.containsKey((Object)"properties")) {
                this.addPropertyApiField(fields, refSchema, sampleVo.getCode(), paramSchemas);
            } else if (refSchema != null && refSchema.containsKey((Object)"enum")) {
                this.addApiField(fields, refSchema, sampleVo, paramSchemas);
            }
            return;
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            return;
        }
        if ("array".equals(type)) {
            JSONObject items = schema.getJSONObject("items");
            sampleVo.setCode(sampleVo.getCode() + "[]");
            this.addApiField(fields, items, sampleVo, paramSchemas);
            return;
        }
        if ("object".equals(type)) {
            this.addPropertyApiField(fields, schema, sampleVo.getCode(), paramSchemas);
            return;
        }
        ApiDatasourceApplicationService.addSimpleApiField(fields, schema, sampleVo, type);
    }

    private static void addSimpleApiField(ArrayList<ApiEntityFieldVo> fields, JSONObject schema, ApiEntityFieldVo sampleVo, String type) {
        String format = StringUtils.defaultString((String)schema.getString("format"));
        ApiEntityFieldVo fieldVo = new ApiEntityFieldVo();
        BeanUtils.copyProperties((Object)sampleVo, (Object)fieldVo);
        if (schema.containsKey((Object)"enum")) {
            JSONArray enumArray = schema.getJSONArray("enum");
            fieldVo.setAllowEnum(1);
            ArrayList<ApiEntityFieldEnumDto> enumsConfig = new ArrayList<ApiEntityFieldEnumDto>();
            fieldVo.setEnumsConfig(enumsConfig);
            for (int i = 0; i < enumArray.size(); ++i) {
                ApiEntityFieldEnumDto enumDto = new ApiEntityFieldEnumDto();
                enumDto.setCode(enumArray.getString(i));
                enumDto.setName(enumDto.getCode());
                enumsConfig.add(enumDto);
            }
        }
        switch (type) {
            case "boolean": {
                fieldVo.setDataType(DataType.Boolean);
                fieldVo.setFormWidgetType("radio");
                fields.add(fieldVo);
                break;
            }
            case "integer": {
                if ("int64".equals(format)) {
                    fieldVo.setDataType(DataType.Long);
                } else {
                    fieldVo.setDataType(DataType.Integer);
                }
                fieldVo.setDataType(DataType.Integer);
                fieldVo.setFormWidgetType("fd-input-number");
                fields.add(fieldVo);
                break;
            }
            case "number": {
                fieldVo.setDataType(DataType.BigDecimal);
                fields.add(fieldVo);
                fieldVo.setFormWidgetType(WIDGET_INPUT);
                break;
            }
            case "string": {
                switch (format) {
                    case "date": 
                    case "date-time": {
                        fieldVo.setDataType(DataType.Date);
                        fieldVo.setFormWidgetType("time");
                        break;
                    }
                    case "byte": {
                        fieldVo.setDataType(DataType.Integer);
                        fieldVo.setFormWidgetType("fd-input-number");
                        fieldVo.setCode(fieldVo.getCode() + "[]");
                        break;
                    }
                    case "binary": {
                        fieldVo.setDataType(DataType.String);
                        fieldVo.setFieldPropertyType("FILE");
                        fieldVo.setFormWidgetType("fd-upload");
                        break;
                    }
                    default: {
                        fieldVo.setFormWidgetType(WIDGET_INPUT);
                        fieldVo.setDataType(DataType.String);
                    }
                }
                fields.add(fieldVo);
                break;
            }
            default: {
                fieldVo.setFormWidgetType(WIDGET_INPUT);
                fieldVo.setDataType(DataType.String);
                fields.add(fieldVo);
            }
        }
    }

    private ApiEntityFieldVo buildApiField(String code, String name, String description, String codePrefix) {
        ApiEntityFieldVo field = new ApiEntityFieldVo();
        field.setRealCode(code);
        if (StringUtils.isNotBlank((CharSequence)code)) {
            field.setCode(codePrefix + "." + field.getRealCode());
        } else {
            field.setCode(codePrefix);
        }
        field.setName(name);
        field.setDescription(description);
        field.setFieldPropertyType("BASIC");
        return field;
    }

    private ApiDatasource findCache(long id) {
        if (null != this.cacheService) {
            return this.cacheService.findCache(id);
        }
        return null;
    }

    private void saveCache(ApiDatasource apiDatasource) {
        if (null != this.cacheService && null != apiDatasource) {
            this.cacheService.saveCache(apiDatasource);
        }
    }

    private void removeCache(long id) {
        if (null != this.cacheService) {
            this.cacheService.removeCache(id);
        }
    }

    private void removeCaches(List<Long> ids) {
        if (null != ids) {
            ids.forEach(this::removeCache);
        }
    }
}

