/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.controller;

import com.cyberway.mp.bbc.api.api.ApiDatasourceApi;
import com.cyberway.mp.bbc.api.api.dto.ApiBundleCreateForEntityCreateDto;
import com.cyberway.mp.bbc.api.api.dto.ApiCallDto;
import com.cyberway.mp.bbc.api.api.dto.ApiChangeStatusDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourceCreateDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourceModifyDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourcePageDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourceSelectDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDocExtractDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDocImportDto;
import com.cyberway.mp.bbc.api.api.vo.ApiDatasourceListVo;
import com.cyberway.mp.bbc.api.api.vo.ApiDatasourceVo;
import com.cyberway.mp.bbc.api.api.vo.ApiDocImportVo;
import com.cyberway.mp.bbc.api.api.vo.ApiEntityVo;
import com.cyberway.mp.bbc.api.domain.service.ApiCallService;
import com.cyberway.mp.bbc.api.infra.http.HttpResponse;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.Collection;
import java.util.List;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/apiDatasource"})
@Tag(name="apiDatasource")
public class ApiDatasourceController {
    private final ApiDatasourceApi apiDatasourceApi;
    private final ApiCallService apiCallService;

    public ApiDatasourceController(ApiDatasourceApi apiDatasourceApi, ApiCallService apiCallService) {
        this.apiDatasourceApi = apiDatasourceApi;
        this.apiCallService = apiCallService;
    }

    @Operation(summary="\u521b\u5efa\u63a5\u53e3\u6570\u636e\u6e90")
    @PostMapping
    public ResponseResult<Long> createApi(@RequestBody ApiDatasourceCreateDto dto) {
        return ResponseResult.successResult((Object)this.apiDatasourceApi.createApi(dto));
    }

    @Operation(summary="\u4fee\u6539\u63a5\u53e3\u6570\u636e\u6e90")
    @PutMapping(value={"/{id}"})
    public ResponseResult<Void> modifyApi(@PathVariable(value="id") Long id, @RequestBody ApiDatasourceCreateDto dto) {
        this.apiDatasourceApi.modifyApi(ApiDatasourceModifyDto.fromApiDatasourceCreateDto(id, dto));
        return ResponseResult.successResult();
    }

    @Operation(summary="\u5220\u9664\u63a5\u53e3\u6570\u636e\u6e90")
    @DeleteMapping(value={"/{id}"})
    public ResponseResult<Void> deleteApi(@PathVariable(value="id") Long id) {
        this.apiDatasourceApi.deleteApi(id);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u6279\u91cf\u5220\u9664\u63a5\u53e3\u6570\u636e\u6e90")
    @DeleteMapping(value={"/batchDelete"})
    public ResponseResult<Void> batchDeleteApi(@RequestBody List<Long> ids) {
        this.apiDatasourceApi.batchDeleteApi(ids);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u83b7\u53d6\u63a5\u53e3\u6570\u636e\u6e90\u8be6\u60c5")
    @GetMapping(value={"/{id}"})
    public ResponseResult<ApiDatasourceVo> getApi(@PathVariable(value="id") Long id) {
        return ResponseResult.successResult((Object)this.apiDatasourceApi.getApi(id));
    }

    @Operation(summary="\u6279\u91cf\u83b7\u53d6api")
    @PostMapping(value={"/batchGetApi"})
    public ResponseResult<List<ApiDatasourceVo>> batchGetApi(@RequestBody Collection<Long> ids) {
        return ResponseResult.successResult(this.apiDatasourceApi.batchGetApi(ids));
    }

    @Operation(summary="\u901a\u8fc7Code\u6279\u91cf\u83b7\u53d6api")
    @PostMapping(value={"/batchGetApiByCodes"})
    public ResponseResult<List<ApiDatasourceVo>> batchGetApiByCodes(@RequestBody Collection<String> codes) {
        return ResponseResult.successResult(this.apiDatasourceApi.batchGetApiByCodes(codes));
    }

    @Operation(summary="\u901a\u8fc7path\u6279\u91cf\u83b7\u53d6api")
    @PostMapping(value={"/batchGetApiByPaths"})
    public ResponseResult<List<ApiDatasourceVo>> batchGetApiByPaths(@RequestBody Collection<String> paths) {
        return ResponseResult.successResult(this.apiDatasourceApi.batchGetApiByPaths(paths));
    }

    @Operation(summary="\u5206\u9875\u67e5\u8be2\u63a5\u53e3\u6570\u636e\u6e90")
    @PostMapping(value={"query"})
    public ResponseResult<Page<ApiDatasourceListVo>> pageQueryApi(@RequestBody ApiDatasourcePageDto dto) {
        return ResponseResult.successResult(this.apiDatasourceApi.pageQueryApi(dto));
    }

    @Operation(summary="\u5217\u8868\u67e5\u8be2\u63a5\u53e3\u6570\u636e\u6e90")
    @PostMapping(value={"listQuery"})
    public ResponseResult<List<ApiDatasourceListVo>> listApi(@RequestBody ApiDatasourcePageDto dto) {
        return ResponseResult.successResult(this.apiDatasourceApi.listApi(dto));
    }

    @Operation(summary="\u66f4\u6539\u72b6\u6001")
    @PutMapping(value={"/changeStatus"})
    public ResponseResult<Void> changeStatus(@RequestBody ApiChangeStatusDto dto) {
        this.apiDatasourceApi.changeStatus(dto);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u4e3a\u5b9e\u4f53\u521b\u5efaAPI")
    @PostMapping(value={"/bundleCreateForEntity"})
    public ResponseResult<Void> bundleCreateForEntity(@RequestBody ApiBundleCreateForEntityCreateDto dto) {
        this.apiDatasourceApi.bundleCreateForEntity(dto);
        return ResponseResult.successResult();
    }

    @Operation(summary="\u8c03\u7528API")
    @PostMapping(value={"/callApi"})
    public String callApi(@Valid @RequestBody ApiCallDto dto) {
        HttpResponse httpResponse = this.apiCallService.callAsync(dto.getApiId(), dto.getHeaders(), dto.getPathParams(), dto.getUrlParams(), dto.getCustomParams(), dto.getBody(), dto.getTimeoutSeconds(), null);
        return Boolean.TRUE.equals(httpResponse.getSuccess()) ? httpResponse.getContent() : httpResponse.getErrorMsg();
    }

    @Operation(summary="\u89e3\u6790\u6587\u6863\u83b7\u53d6\u53ef\u9009API")
    @PostMapping(value={"/extractApiDoc"})
    public ResponseResult<List<ApiDatasourceSelectDto>> extractApiDoc(@RequestBody ApiDocExtractDto dto) {
        return ResponseResult.successResult(this.apiDatasourceApi.extractApiDoc(dto));
    }

    @Operation(summary="\u5bfc\u5165\u6587\u6863\u751f\u6210API")
    @PostMapping(value={"/importApiDoc"})
    public ResponseResult<ApiDocImportVo> importApiDoc(@RequestBody ApiDocImportDto dto) {
        return ResponseResult.successResult((Object)this.apiDatasourceApi.importApiDoc(dto));
    }

    @Operation(summary="\u83b7\u53d6API\u4eff\u5b9e\u4f53\u7ed3\u6784")
    @GetMapping(value={"/loadApiEntityMetadata"})
    public ResponseResult<ApiEntityVo> loadApiEntityMetadata(@RequestParam(value="code") String code) {
        return ResponseResult.successResult((Object)this.apiDatasourceApi.loadApiEntityMetadata(code));
    }
}

