/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.domain.entity;

import com.cyberway.mp.bbc.api.domain.entity.ApiDatasource;
import com.cyberway.mp.bbc.api.infra.http.HttpResponse;
import com.cyberway.mp.bc.common.utils.JsonUtils;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Table(name="bbc_api_call_log")
public class ApiCallLog
extends BusinessEntityWithAppInstance {
    private String apiName;
    private Long apiId;
    private String apiCode;
    private String url;
    private String httpMethod;
    private Date requestTime;
    private Date responseTime;
    private Long executeTime;
    private Integer httpStatus;
    private String headers;
    private String customParams;
    private String urlParams;
    private String requestBody;
    private String responseBody;
    private Boolean success;
    private String msg;

    public static ApiCallLog init(ApiDatasource api, String url, Map<String, String> headers, Map<String, String> urlParams, Map<String, Object> customParams, String body) {
        ApiCallLog apiCallLog = new ApiCallLog();
        apiCallLog.setApiName(api.getName());
        apiCallLog.setApiId((Long)api.getId());
        apiCallLog.setApiCode(api.getCode());
        apiCallLog.setHttpMethod(api.getMethod());
        apiCallLog.setRequestTime(new Date());
        apiCallLog.setUrl(url);
        apiCallLog.setUrlParams(ApiCallLog.convertText(urlParams));
        apiCallLog.setHeaders(ApiCallLog.convertText(headers));
        apiCallLog.setCustomParams(ApiCallLog.convertText(customParams));
        apiCallLog.setRequestBody(ApiCallLog.convertText(body));
        return apiCallLog;
    }

    public void callSuccess(HttpResponse result) {
        this.setResponseTime(new Date());
        this.setExecuteTime(this.getResponseTime().getTime() - this.getRequestTime().getTime());
        this.setHttpStatus(result.getCode());
        this.setResponseBody(ApiCallLog.convertText(result.getContent()));
        this.setSuccess(result.getSuccess());
    }

    public void callError(Exception e) {
        this.setResponseTime(new Date());
        this.setExecuteTime(this.getResponseTime().getTime() - this.getRequestTime().getTime());
        this.setSuccess(false);
        this.setMsg(ApiCallLog.convertText(ExceptionUtils.getMessage((Throwable)e)));
    }

    private static String convertText(Object obj) {
        if (obj == null) {
            return "";
        }
        String targetStr = obj instanceof String ? (String)obj : JsonUtils.toJson((Object)obj);
        if (targetStr.length() > 2000) {
            return targetStr.substring(0, 2000);
        }
        return targetStr;
    }

    public String getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setApiName(String apiName) {
        this.apiName = apiName;
    }

    public Long getApiId() {
        return this.apiId;
    }

    public void setApiId(Long apiId) {
        this.apiId = apiId;
    }

    public String getApiCode() {
        return this.apiCode;
    }

    public void setApiCode(String apiCode) {
        this.apiCode = apiCode;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Date getRequestTime() {
        return this.requestTime;
    }

    public void setRequestTime(Date requestTime) {
        this.requestTime = requestTime;
    }

    public Date getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(Date responseTime) {
        this.responseTime = responseTime;
    }

    public Long getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(Long executeTime) {
        this.executeTime = executeTime;
    }

    public Integer getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(Integer httpStatus) {
        this.httpStatus = httpStatus;
    }

    public String getHeaders() {
        return this.headers;
    }

    public void setHeaders(String headers) {
        this.headers = headers;
    }

    public String getCustomParams() {
        return this.customParams;
    }

    public void setCustomParams(String customParams) {
        this.customParams = customParams;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }
}

