/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.domain.service;

import cn.hutool.core.net.url.UrlBuilder;
import com.cyberway.dp.api.plugin.ApiPlugin;
import com.cyberway.dp.api.plugin.ApiSpiHelper;
import com.cyberway.dp.api.plugin.BaseHttpParameter;
import com.cyberway.mp.bbc.api.api.ApiErrorCode;
import com.cyberway.mp.bbc.api.api.dto.AuthConfigDto;
import com.cyberway.mp.bbc.api.domain.entity.ApiCallLog;
import com.cyberway.mp.bbc.api.domain.entity.ApiDatasource;
import com.cyberway.mp.bbc.api.domain.repository.ApiCallLogRepository;
import com.cyberway.mp.bbc.api.domain.service.ApiDatasourceService;
import com.cyberway.mp.bbc.api.infra.http.HttpClientProvider;
import com.cyberway.mp.bbc.api.infra.http.HttpResponse;
import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.utils.JsonUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiCallService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ExecutorService executorService;
    private final ApiDatasourceService apiDatasourceService;
    private final ApiCallLogRepository apiCallLogRepository;
    private final HttpClientProvider httpClientProvider = new HttpClientProvider();

    public ApiCallService(ExecutorService executorService, ApiDatasourceService apiDatasourceService, ApiCallLogRepository apiCallLogRepository) {
        this.executorService = executorService;
        this.apiDatasourceService = apiDatasourceService;
        this.apiCallLogRepository = apiCallLogRepository;
    }

    public HttpResponse call(Long apiId, Map<String, String> headers, Map<String, String> pathParams, Map<String, String> urlParams, Map<String, Object> customParams, String body) {
        ApiDatasource api = this.apiDatasourceService.getApi(apiId);
        AssertUtil.notNull((Object)((Object)api), (ErrorCode)ApiErrorCode.OBJECT_NOT_FOUND, (Object[])new Object[]{apiId});
        String url = api.getAccessUrl();
        AssertUtil.notBlank((String)url, (ErrorCode)ApiErrorCode.MISSING_ACCESS_URL, (Object[])new Object[0]);
        if (MapUtils.isNotEmpty(pathParams)) {
            for (Map.Entry<String, String> entry : pathParams.entrySet()) {
                String string = entry.getKey();
                url = url.replace("{" + string + "}", pathParams.get(string));
            }
        }
        UrlBuilder urlBuilder = UrlBuilder.of((String)url);
        if (null != urlParams && !urlParams.isEmpty()) {
            for (Map.Entry<String, String> entry : urlParams.entrySet()) {
                urlBuilder.addQuery(entry.getKey(), (Object)entry.getValue());
            }
        }
        BaseHttpParameter baseHttpParameter = new BaseHttpParameter();
        baseHttpParameter.setUrl(url);
        baseHttpParameter.setHeaders(headers);
        baseHttpParameter.setParams(urlParams);
        baseHttpParameter.setBody(body);
        this.preRequest(api, baseHttpParameter);
        ApiCallLog apiCallLog = ApiCallLog.init(api, baseHttpParameter.getUrl(), baseHttpParameter.getHeaders(), baseHttpParameter.getParams(), customParams, baseHttpParameter.getBody());
        try {
            HttpResponse result = this.httpClientProvider.execute(baseHttpParameter.getUrl(), api.getMethod(), baseHttpParameter.getHeaders(), baseHttpParameter.getParams(), baseHttpParameter.getBody());
            apiCallLog.callSuccess(result);
            this.apiCallLogRepository.save((Object)apiCallLog);
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            apiCallLog.callError(e);
            this.apiCallLogRepository.save((Object)apiCallLog);
            return HttpResponse.error(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private void preRequest(ApiDatasource api, BaseHttpParameter httpParameter) {
        String authOptions = api.getAuthOptions();
        ApiPlugin apiPlugin = null;
        HashMap<String, String> pluginConfig = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)authOptions)) {
            AuthConfigDto authConfig = (AuthConfigDto)JsonUtils.toObject((String)authOptions, AuthConfigDto.class);
            apiPlugin = ApiSpiHelper.getInstance((String)authConfig.getAuthMethod());
            List<AuthConfigDto.AuthParam> authParams = authConfig.getAuthParams();
            if (CollectionUtils.isNotEmpty(authParams)) {
                for (AuthConfigDto.AuthParam authParam : authParams) {
                    pluginConfig.put(authParam.getKey(), authParam.getValue());
                }
            }
        }
        if (null != apiPlugin) {
            apiPlugin.preRequest(httpParameter, pluginConfig);
        }
    }

    public HttpResponse callAsync(Long apiId, Map<String, String> headers, Map<String, String> pathParams, Map<String, String> urlParams, Map<String, Object> customParams, String body, int timeoutSeconds, Consumer<HttpResponse> callBack) {
        AssertUtil.notNull((Object)this.executorService, (ErrorCode)ApiErrorCode.MISSING_API_CALL_EXECUTOR, (Object[])new Object[0]);
        Future<HttpResponse> future = this.executorService.submit(() -> {
            HttpResponse httpResponse = this.call(apiId, headers, pathParams, urlParams, customParams, body);
            if (null != callBack) {
                callBack.accept(httpResponse);
            }
            return httpResponse;
        });
        try {
            return future.get(timeoutSeconds, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return HttpResponse.error("API\u8c03\u7528\u8d85\u65f6");
        }
        catch (InterruptedException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
            Thread.currentThread().interrupt();
            return HttpResponse.error("API\u8c03\u7528\u4e2d\u65ad");
        }
    }
}

