/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.domain.service;

import com.cyberway.mp.bbc.api.domain.entity.ApiDatasource;
import com.cyberway.mp.bc.cache.CacheService;
import com.cyberway.mp.bc.cache.annotation.PosType;

public class ApiDatasourceCacheService {
    private static final String API_CACHE_NAME = "BBC_API_CACHE";
    private static final String API_CACHE_KEY = "api:";
    private final CacheService cacheService;

    public ApiDatasourceCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public ApiDatasource findCache(long id) {
        return (ApiDatasource)((Object)this.cacheService.get(API_CACHE_NAME, (Object)this.buildCacheKey(id), ApiDatasource.class, PosType.REMOTE));
    }

    public void saveCache(ApiDatasource apiDatasource) {
        this.cacheService.put(API_CACHE_NAME, (Object)this.buildCacheKey((Long)apiDatasource.getId()), (Object)apiDatasource, PosType.REMOTE);
    }

    public void removeCache(long id) {
        this.cacheService.evict(API_CACHE_NAME, (Object)this.buildCacheKey(id), PosType.REMOTE);
    }

    private String buildCacheKey(long id) {
        return API_CACHE_KEY + id;
    }
}

