/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.domain.service;

import com.cyberway.mp.bbc.api.domain.entity.ApiDatasource;
import com.cyberway.mp.bbc.api.domain.repository.ApiDatasourceRepository;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ApiDatasourceLocalCacheService {
    private static final String CACHE_KEY = "api_info";
    private final Cache<String, List<ApiDatasource>> localCache;

    public ApiDatasourceLocalCacheService(int expireSeconds) {
        this.localCache = Caffeine.newBuilder().expireAfterWrite((long)expireSeconds, TimeUnit.SECONDS).build();
    }

    public List<ApiDatasource> findByIdIn(Collection<Long> ids, ApiDatasourceRepository repository) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        HashSet<Long> idSet = new HashSet<Long>(ids);
        return Objects.requireNonNull((List)this.localCache.get((Object)CACHE_KEY, key -> repository.findAll())).stream().filter(i -> idSet.contains(i.getId())).collect(Collectors.toList());
    }

    public List<ApiDatasource> findByCodeIn(Collection<String> codes, ApiDatasourceRepository repository) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        HashSet<String> codeSet = new HashSet<String>(codes);
        return Objects.requireNonNull((List)this.localCache.get((Object)CACHE_KEY, key -> repository.findAll())).stream().filter(i -> codeSet.contains(i.getCode())).collect(Collectors.toList());
    }

    public List<ApiDatasource> findByPathIn(Collection<String> paths, ApiDatasourceRepository repository) {
        if (CollectionUtils.isEmpty(paths)) {
            return Collections.emptyList();
        }
        HashSet<String> pathSet = new HashSet<String>(paths);
        return Objects.requireNonNull((List)this.localCache.get((Object)CACHE_KEY, key -> repository.findAll())).stream().filter(i -> pathSet.contains(i.getPath())).collect(Collectors.toList());
    }
}

