/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.domain.service;

import com.cyberway.mp.bbc.api.api.dto.ApiBundleCreateForEntityCreateDto;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourcePageDto;
import com.cyberway.mp.bbc.api.api.enums.ApiSource;
import com.cyberway.mp.bbc.api.api.enums.ApiType;
import com.cyberway.mp.bbc.api.api.enums.ShelfStatus;
import com.cyberway.mp.bbc.api.api.vo.ApiDatasourceListVo;
import com.cyberway.mp.bbc.api.domain.entity.ApiDatasource;
import com.cyberway.mp.bbc.api.domain.repository.ApiDatasourceRepository;
import com.cyberway.mp.bbc.api.domain.repository.query.ApiDatasourceQueryBean;
import com.cyberway.mp.bbc.api.domain.service.ApiDatasourceLocalCacheService;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ApiDatasourceService {
    private final ApiDatasourceRepository repository;
    private final ApiDatasourceLocalCacheService cacheService;

    public ApiDatasourceService(ApiDatasourceRepository repository, ApiDatasourceLocalCacheService cacheService) {
        this.repository = repository;
        this.cacheService = cacheService;
    }

    public void createApi(ApiDatasource apiDatasource) {
        apiDatasource.initCode();
        this.repository.save((Object)apiDatasource);
    }

    public void modifyApi(ApiDatasource apiDatasource) {
        if (null != apiDatasource) {
            this.repository.updateById((Object)apiDatasource, (Long)apiDatasource.getId());
        }
    }

    public void deleteApi(long id) {
        this.repository.delete(id);
    }

    public ApiDatasource getApi(long id) {
        return (ApiDatasource)((Object)this.repository.findOne(id));
    }

    public Page<ApiDatasourceListVo> pageQueryApi(ApiDatasourcePageDto dto) {
        ApiDatasourceQueryBean queryBean = ApiDatasourceQueryBean.fromApiDatasourcePageDto(dto);
        long countResult = this.repository.countByQueryBean(queryBean);
        if (countResult < 1L) {
            return new Page(dto.getCurrent(), dto.getPageSize(), 0L, Collections.emptyList());
        }
        List<ApiDatasource> list = this.repository.searchPageByQueryBean(queryBean, (PageParam)dto);
        return new Page(dto.getCurrent(), dto.getPageSize(), countResult, list.stream().map(ApiDatasource::toListVo).collect(Collectors.toList()));
    }

    public List<ApiDatasource> listApi(ApiDatasourcePageDto dto) {
        ApiDatasourceQueryBean queryBean = ApiDatasourceQueryBean.fromApiDatasourcePageDto(dto);
        return this.repository.searchListByQueryBean(queryBean);
    }

    public List<ApiDatasource> findByIds(Collection<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        return this.cacheService.findByIdIn(ids, this.repository);
    }

    public List<ApiDatasource> findByCodes(Collection<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        return this.cacheService.findByCodeIn(codes, this.repository);
    }

    public List<ApiDatasource> findByPaths(Collection<String> paths) {
        if (CollectionUtils.isEmpty(paths)) {
            return Collections.emptyList();
        }
        return this.cacheService.findByPathIn(paths, this.repository);
    }

    public List<ApiDatasource> listInService(String service) {
        return this.repository.findByService(service);
    }

    public void bundleCreateForEntity(ApiBundleCreateForEntityCreateDto dto) {
        ApiDatasourceQueryBean queryBean = new ApiDatasourceQueryBean();
        queryBean.setSource(ApiSource.LOW_CODE);
        queryBean.setTag(dto.getTag());
        queryBean.setService(dto.getService());
        List<ApiDatasource> oldApiList = this.repository.searchListByQueryBean(queryBean);
        Set existedApiSet = oldApiList.stream().map(api -> api.getMethod().toUpperCase() + ":" + api.getPath()).collect(Collectors.toSet());
        List newApiList = dto.getApiInfos().stream().filter(apiInfo -> !existedApiSet.contains(apiInfo.getMethod().toUpperCase() + ":" + apiInfo.getPath())).map(apiInfo -> {
            ApiDatasource api = new ApiDatasource();
            api.setMethod(apiInfo.getMethod().toUpperCase());
            api.setPath(apiInfo.getPath());
            api.setAccessUrl(apiInfo.getAccessUrl());
            api.setService(dto.getService());
            api.setSource(ApiSource.LOW_CODE);
            api.setType(ApiType.INTERNAL);
            api.setTag(dto.getTag());
            api.setStatus(ShelfStatus.ON);
            api.setDocGroup(dto.getDocGroup());
            api.setHeaders("[]");
            api.setRequestBody("{}");
            api.setResponseBody("{}");
            api.setParamSchema("{}");
            api.setUrlParams("[]");
            api.setPathParams("[]");
            api.setName(apiInfo.getName());
            api.setRequestContentType(apiInfo.getRequestContentType());
            api.setResponseContentType(apiInfo.getResponseContentType());
            api.setDescription(StringUtils.defaultString((String)apiInfo.getDescription()));
            api.initCode();
            return api;
        }).collect(Collectors.toList());
        if (!newApiList.isEmpty()) {
            List partition = Lists.partition(newApiList, (int)50);
            for (List apiDatasources : partition) {
                this.repository.batchInsert(apiDatasources);
            }
        }
    }

    public void batchDeleteApi(List<Long> ids) {
        if (CollectionUtils.isNotEmpty(ids)) {
            this.repository.deleteByIdIn(ids);
        }
    }
}

