/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.infra.config;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.cyberway.mp.bbc.api.api.ApiDatasourceApi;
import com.cyberway.mp.bbc.api.application.service.ApiDatasourceApplicationService;
import com.cyberway.mp.bbc.api.domain.repository.ApiCallLogRepository;
import com.cyberway.mp.bbc.api.domain.repository.ApiDatasourceRepository;
import com.cyberway.mp.bbc.api.domain.service.ApiCallService;
import com.cyberway.mp.bbc.api.domain.service.ApiDatasourceCacheService;
import com.cyberway.mp.bbc.api.domain.service.ApiDatasourceLocalCacheService;
import com.cyberway.mp.bbc.api.domain.service.ApiDatasourceService;
import com.cyberway.mp.bc.cache.config.EnableMultiCaching;
import com.cyberway.mp.bc.common.annotation.EnableCommonControllerConfig;
import com.cyberway.mp.bc.common.annotation.EnableCommonFeignConfig;
import com.cyberway.mp.bc.dal.config.EnableDAL;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@MapperScan(value={"com.cyberway.mp.bbc.api.domain"})
@EnableDAL
@EnableCommonFeignConfig
@Configuration
@ComponentScan(basePackages={"com.cyberway.mp.bbc.api"})
@EnableCommonControllerConfig
@ConditionalOnProperty(prefix="mp.bbc.api", name={"mode"}, havingValue="local")
@EnableMultiCaching
public class BbcApiAutoConfiguration
implements BeanDefinitionRegistryPostProcessor,
BeanPostProcessor {
    private static final String API_LIQUIBASE_MANGER_BEAN_NAME = "bbcApiLiquibaseManger";
    @Value(value="${mp.bbc.api.local-cache.expire-seconds:300}")
    private int expireSeconds;
    private ConfigurableListableBeanFactory configurableListableBeanFactory;

    @Bean(name={"bbcApiLiquibaseManger"})
    @ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public SpringLiquibase apiLiquibaseManger(DataSource dataSource, ResourceLoader resourceLoader) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setResourceLoader(resourceLoader);
        liquibase.setChangeLog("classpath:bbc-api-liquibase-master.xml");
        liquibase.setDatabaseChangeLogTable("bbc_api_database_change_log");
        liquibase.setDatabaseChangeLogLockTable("bbc_api_database_change_log_lock");
        return liquibase;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory configurableListableBeanFactory) throws BeansException {
        this.configurableListableBeanFactory = configurableListableBeanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof SpringLiquibase) {
            if (API_LIQUIBASE_MANGER_BEAN_NAME.equals(beanName) || "configurationLiquibaseManger".equals(beanName)) {
                return bean;
            }
            this.configurableListableBeanFactory.getBean(API_LIQUIBASE_MANGER_BEAN_NAME);
        }
        return bean;
    }

    @Bean
    public ApiDatasourceLocalCacheService apiDatasourceLocalCacheService() {
        return new ApiDatasourceLocalCacheService(this.expireSeconds);
    }

    @Bean
    public ApiDatasourceService apiDatasourceService(ApiDatasourceRepository apiDatasourceRepository, ApiDatasourceLocalCacheService apiDatasourceLocalCacheService) {
        return new ApiDatasourceService(apiDatasourceRepository, apiDatasourceLocalCacheService);
    }

    @Bean
    public ApiDatasourceApi apiDatasourceApplicationService(ApiDatasourceService apiDatasourceService, @Autowired(required=false) ApiDatasourceCacheService cacheService) {
        return new ApiDatasourceApplicationService(apiDatasourceService, cacheService);
    }

    @Bean(name={"apiCallThreadPoolExecutor"})
    @ConditionalOnProperty(prefix="mp.bbc.api.default-executor", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public ExecutorService apiCallThreadPoolExecutor() {
        return TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(5, 20, 2L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    @Bean
    public ApiCallService apiCallService(@Autowired(required=false) @Qualifier(value="apiCallThreadPoolExecutor") ExecutorService executorService, ApiDatasourceService apiDatasourceService, ApiCallLogRepository apiCallLogRepository) {
        return new ApiCallService(executorService, apiDatasourceService, apiCallLogRepository);
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
    }
}

