/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.infra.http;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.net.url.UrlQuery;
import com.cyberway.mp.bbc.api.infra.http.HttpResponse;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpClientProvider {
    private static final String APPLICATION_JSON = "application/json";
    private final RestTemplate restTemplate = new RestTemplate();

    public HttpResponse execute(String url, String method, Map<String, String> headers, Map<String, String> params, String body) {
        if ("POST".equals(method = method.toUpperCase(Locale.ROOT))) {
            return this.doPost(url, headers, params, body);
        }
        if ("GET".equals(method)) {
            return this.doGet(url, headers, params);
        }
        if ("PUT".equals(method)) {
            return this.doPut(url, headers, params, body);
        }
        if ("DELETE".equals(method)) {
            return this.doDelete(url, headers, params);
        }
        return this.doGet(url, headers, params);
    }

    public HttpResponse doGet(String url, Map<String, String> headers, Map<String, String> params) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (MapUtils.isNotEmpty(headers)) {
            httpHeaders.setAll(headers);
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        UrlBuilder urlBuilder = HttpClientProvider.buildUrl(url, params);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(urlBuilder.build(), HttpMethod.GET, httpEntity, String.class, new Object[0]);
            return new HttpResponse(responseEntity.getStatusCodeValue(), (String)responseEntity.getBody(), true);
        }
        catch (Exception e) {
            return HttpResponse.error(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    private static UrlBuilder buildUrl(String url, Map<String, String> params) {
        UrlBuilder urlBuilder = UrlBuilder.of((String)url);
        if (MapUtils.isNotEmpty(params)) {
            urlBuilder.setQuery(UrlQuery.of(params));
        }
        return urlBuilder;
    }

    public HttpResponse doPost(String url, Map<String, String> headers, Map<String, String> params, String body) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", APPLICATION_JSON);
        if (MapUtils.isNotEmpty(headers)) {
            httpHeaders.setAll(headers);
        }
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        UrlBuilder urlBuilder = HttpClientProvider.buildUrl(url, params);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(urlBuilder.build(), HttpMethod.POST, httpEntity, String.class, new Object[0]);
            return new HttpResponse(responseEntity.getStatusCodeValue(), (String)responseEntity.getBody(), true);
        }
        catch (Exception e) {
            return HttpResponse.error(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public HttpResponse doPut(String url, Map<String, String> headers, Map<String, String> params, String body) {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.add("Content-Type", APPLICATION_JSON);
        if (MapUtils.isNotEmpty(headers)) {
            httpHeaders.setAll(headers);
        }
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)httpHeaders);
        UrlBuilder urlBuilder = HttpClientProvider.buildUrl(url, params);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(urlBuilder.build(), HttpMethod.PUT, httpEntity, String.class, new Object[0]);
            return new HttpResponse(responseEntity.getStatusCodeValue(), (String)responseEntity.getBody(), true);
        }
        catch (Exception e) {
            return HttpResponse.error(ExceptionUtils.getMessage((Throwable)e));
        }
    }

    public HttpResponse doDelete(String url, Map<String, String> headers, Map<String, String> params) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if (MapUtils.isNotEmpty(headers)) {
            httpHeaders.setAll(headers);
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)httpHeaders);
        UrlBuilder urlBuilder = HttpClientProvider.buildUrl(url, params);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(urlBuilder.build(), HttpMethod.DELETE, httpEntity, String.class, new Object[0]);
            return new HttpResponse(responseEntity.getStatusCodeValue(), (String)responseEntity.getBody(), true);
        }
        catch (Exception e) {
            return HttpResponse.error(ExceptionUtils.getMessage((Throwable)e));
        }
    }
}

