/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.api.infra.utils;

import com.alibaba.fastjson.JSON;
import com.cyberway.mp.bbc.api.api.dto.ApiDatasourceSelectDto;
import com.cyberway.mp.bbc.api.api.enums.ApiSource;
import com.cyberway.mp.bbc.api.api.enums.ApiType;
import com.cyberway.mp.bbc.api.api.enums.ShelfStatus;
import com.cyberway.mp.bbc.api.domain.entity.ApiDatasource;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class OpenDocUtil {
    private OpenDocUtil() {
    }

    public static List<ApiDatasourceSelectDto> extractSelectApisByContent(String docContent) {
        ParseOptions options = new ParseOptions();
        SwaggerParseResult parseResult = new OpenAPIParser().readContents(docContent, Collections.emptyList(), options);
        OpenAPI openAPI = parseResult.getOpenAPI();
        return OpenDocUtil.extractSelectApis(openAPI);
    }

    public static List<ApiDatasourceSelectDto> extractSelectApisByUrl(String docUrl) {
        ParseOptions options = new ParseOptions();
        SwaggerParseResult parseResult = new OpenAPIParser().readLocation(docUrl, Collections.emptyList(), options);
        OpenAPI openAPI = parseResult.getOpenAPI();
        return OpenDocUtil.extractSelectApis(openAPI);
    }

    public static List<ApiDatasourceSelectDto> extractSelectApis(OpenAPI openAPI) {
        if (openAPI == null || openAPI.getPaths() == null) {
            return Collections.emptyList();
        }
        ArrayList<ApiDatasourceSelectDto> result = new ArrayList<ApiDatasourceSelectDto>();
        openAPI.getPaths().forEach((path, pathItem) -> pathItem.readOperationsMap().forEach((httpMethod, operation) -> {
            ApiDatasourceSelectDto apiDto = new ApiDatasourceSelectDto();
            apiDto.setPath((String)path);
            apiDto.setMethod(httpMethod.name().toUpperCase());
            result.add(apiDto);
        }));
        return result;
    }

    public static List<ApiDatasource> buildApiDatasourceFromDocUrl(String serviceName, String routePath, String docUrl, List<ApiDatasourceSelectDto> selectApis) {
        ParseOptions options = new ParseOptions();
        SwaggerParseResult parseResult = new OpenAPIParser().readLocation(docUrl, Collections.emptyList(), options);
        OpenAPI openAPI = parseResult.getOpenAPI();
        return OpenDocUtil.buildApiDatasourceFromDoc(serviceName, routePath, openAPI, selectApis);
    }

    public static List<ApiDatasource> buildApiDatasourceFromDocContent(String serviceName, String routePath, String docContent, List<ApiDatasourceSelectDto> selectApis) {
        ParseOptions options = new ParseOptions();
        SwaggerParseResult parseResult = new OpenAPIParser().readContents(docContent, Collections.emptyList(), options);
        OpenAPI openAPI = parseResult.getOpenAPI();
        return OpenDocUtil.buildApiDatasourceFromDoc(serviceName, routePath, openAPI, selectApis);
    }

    public static List<ApiDatasource> buildApiDatasourceFromDoc(String serviceName, String routePath, OpenAPI openAPI, List<ApiDatasourceSelectDto> selectApis) {
        Map schemas = openAPI.getComponents().getSchemas();
        Paths paths = openAPI.getPaths();
        ArrayList<ApiDatasource> result = new ArrayList<ApiDatasource>();
        Set selectKeys = null != selectApis ? selectApis.stream().map(ApiDatasourceSelectDto::toKey).collect(Collectors.toSet()) : Collections.emptySet();
        paths.forEach((path, item) -> item.readOperationsMap().forEach((httpMethod, operation) -> {
            String method = httpMethod.name().toUpperCase();
            if (!selectKeys.isEmpty() && !selectKeys.contains(method + "|" + path)) {
                return;
            }
            ApiDatasource api = new ApiDatasource();
            api.setService(serviceName);
            api.setRoutePath(routePath);
            api.setMethod(method);
            api.setPath((String)path);
            api.setStatus(ShelfStatus.ON);
            api.initCode();
            OpenDocUtil.copyApiInfo(api, schemas, operation);
            result.add(api);
        }));
        return result;
    }

    private static void copyApiInfo(ApiDatasource api, Map<String, Schema> schemas, Operation operation) {
        api.setSource(ApiSource.APIDOC);
        api.setType(ApiType.INTERNAL);
        api.setName(operation.getOperationId());
        api.setDescription(StringUtils.defaultString((String)operation.getSummary()));
        api.setDocGroup(api.getService());
        api.setTag("");
        api.setResponseBody("");
        api.setRequestBody("");
        api.setResponseContentType("");
        api.setRequestContentType("");
        api.setHeaders("");
        api.setParamSchema("");
        api.setPathParams("");
        api.setUrlParams("");
        if (!CollectionUtils.isEmpty((Collection)operation.getTags())) {
            api.setTag((String)operation.getTags().get(0));
        }
        OpenDocUtil.parseParamType(api, operation.getParameters() == null ? Collections.emptyList() : operation.getParameters());
        HashSet<String> apiParamSchemaNames = new HashSet<String>();
        OpenDocUtil.parseAndSetRequestBody(api, operation.getRequestBody(), apiParamSchemaNames);
        if (api.getRequestContentType() == null) {
            api.setRequestContentType("application/x-www-form-urlencoded");
        }
        OpenDocUtil.parseAndSetResponseBody(api, operation.getResponses(), apiParamSchemaNames);
        OpenDocUtil.parseAndSetParamSchema(api, schemas, apiParamSchemaNames);
        api.setFieldAuthEnabled(false);
    }

    private static void parseAndSetRequestBody(ApiDatasource api, RequestBody requestBody, Set<String> schemesNames) {
        if (requestBody == null) {
            return;
        }
        Content content = requestBody.getContent();
        OpenDocUtil.handleBodyContent(content, schemesNames, api::setRequestContentType, api::setRequestBody);
    }

    private static void parseAndSetResponseBody(ApiDatasource api, ApiResponses responseBody, Set<String> schemesNames) {
        if (responseBody == null || responseBody.isEmpty()) {
            return;
        }
        ApiResponse apiResponse = responseBody.containsKey((Object)"200") ? (ApiResponse)responseBody.get((Object)"200") : (responseBody.containsKey((Object)"default") ? (ApiResponse)responseBody.get((Object)"default") : (ApiResponse)responseBody.values().iterator().next());
        Content content = apiResponse.getContent();
        OpenDocUtil.handleBodyContent(content, schemesNames, api::setResponseContentType, api::setResponseBody);
    }

    private static void handleBodyContent(Content content, Set<String> schemesNames, Consumer<String> contentTypeSetter, Consumer<String> bodySetter) {
        if (content == null || content.isEmpty()) {
            return;
        }
        String key = content.containsKey((Object)"application/json") ? "application/json" : (String)content.keySet().iterator().next();
        MediaType mediaType = (MediaType)content.get((Object)key);
        contentTypeSetter.accept(key);
        Schema schema = mediaType.getSchema();
        if (schema == null) {
            return;
        }
        String ref = schema.get$ref();
        if (StringUtils.isNotBlank((CharSequence)ref)) {
            schema.raw$ref(ref.replace("#/components/schemas/", ""));
            schemesNames.add(schema.get$ref());
        }
        bodySetter.accept(JSON.toJSONString((Object)content));
    }

    private static void parseParamType(ApiDatasource api, List<Parameter> parameters) {
        if (parameters.isEmpty()) {
            return;
        }
        ArrayList<Parameter> urlParamArr = new ArrayList<Parameter>();
        ArrayList<Parameter> pathParamArr = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            String paramType = parameter.getIn();
            if ("path".equals(paramType)) {
                pathParamArr.add(parameter);
                continue;
            }
            if (!"query".equals(paramType)) continue;
            urlParamArr.add(parameter);
        }
        if (!CollectionUtils.isEmpty(urlParamArr)) {
            api.setUrlParams(JSON.toJSONString(urlParamArr));
        }
        if (!CollectionUtils.isEmpty(pathParamArr)) {
            api.setPathParams(JSON.toJSONString(pathParamArr));
        }
    }

    private static void parseAndSetParamSchema(ApiDatasource api, Map<String, Schema> schemas, Set<String> apiParamSchemaNames) {
        if (schemas == null || schemas.isEmpty()) {
            return;
        }
        HashMap targetObj = new HashMap();
        OpenDocUtil.addAllTargetObjs(schemas, apiParamSchemaNames, targetObj);
        if (!targetObj.isEmpty()) {
            api.setParamSchema(JSON.toJSONString(targetObj));
        }
    }

    private static void addAllTargetObjs(Map<String, Schema> schemas, Set<String> apiParamSchemaNames, Map<String, Schema<?>> targetObj) {
        apiParamSchemaNames.forEach(name -> {
            if (targetObj.containsKey(name) || !schemas.containsKey(name)) {
                return;
            }
            Schema schema = (Schema)schemas.get(name);
            HashSet<String> allInnerObjNames = new HashSet<String>();
            OpenDocUtil.replaceRef(schema, allInnerObjNames);
            targetObj.put((String)name, (Schema<?>)schema);
            allInnerObjNames.removeAll(targetObj.keySet());
            if (!CollectionUtils.isEmpty(allInnerObjNames)) {
                OpenDocUtil.addAllTargetObjs(schemas, allInnerObjNames, targetObj);
            }
        });
    }

    private static void replaceRef(Collection<Schema> schemas, Set<String> allInnerObjNames) {
        if (schemas == null) {
            return;
        }
        schemas.forEach(schema -> OpenDocUtil.replaceRef(schema, allInnerObjNames));
    }

    private static void replaceRef(Map<String, Schema> schemas, Set<String> allInnerObjNames) {
        if (schemas == null) {
            return;
        }
        schemas.values().forEach(schema -> OpenDocUtil.replaceRef(schema, allInnerObjNames));
    }

    private static void replaceRef(Schema<?> schema, Set<String> allInnerObjNames) {
        if (schema == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)schema.get$ref())) {
            schema.raw$ref(schema.get$ref().replace("#/components/schemas/", ""));
            allInnerObjNames.add(schema.get$ref());
        }
        OpenDocUtil.replaceRef(schema.getAdditionalItems(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getItems(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getContains(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getContentSchema(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getNot(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getIf(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getThen(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getElse(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getPropertyNames(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getUnevaluatedItems(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getUnevaluatedProperties(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getProperties(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getDependentSchemas(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getPatternProperties(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getAllOf(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getAnyOf(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getOneOf(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getNot(), allInnerObjNames);
        OpenDocUtil.replaceRef(schema.getPrefixItems(), allInnerObjNames);
    }
}

