/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.api;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationFunction;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.springframework.util.CollectionUtils;

@Schema(title="\u4e2d\u5fc3\u529f\u80fd\u6811")
public class CenterFunctionTree {
    @Schema(title="\u4e3b\u952e")
    private Long id;
    @Schema(title="\u540d\u79f0")
    private String name;
    @Schema(title="\u7f16\u7801")
    private String code;
    @Schema(title="\u5bf9\u5e94\u6ce8\u518c\u4e2d\u5fc3\u7684\u670d\u52a1\u540d")
    private String serviceName;
    @Schema(title="\u63a5\u53e3\u5730\u5740\u8def\u5f84")
    private String urlRoutePath;
    @Schema(title="\u5b50\u6811")
    private List<CenterFunctionTree> children;

    public void refreshChildrenNodes() {
        if (null != this.children) {
            for (CenterFunctionTree child : this.children) {
                child.setServiceName(this.getServiceName());
                child.setUrlRoutePath(this.getUrlRoutePath());
                child.refreshChildrenNodes();
            }
        }
    }

    public List<ConfigurationFunction> toConfigurationFunctionList(CenterFunctionTree parent) {
        ArrayList<ConfigurationFunction> allNodes = new ArrayList<ConfigurationFunction>();
        ConfigurationFunction configurationFunction = new ConfigurationFunction();
        configurationFunction.setId(this.getId());
        configurationFunction.setCode(this.getCode());
        configurationFunction.setName(this.getName());
        configurationFunction.setParent(null == parent ? 0L : parent.getId());
        configurationFunction.setServiceName(this.getServiceName());
        allNodes.add(configurationFunction);
        if (!CollectionUtils.isEmpty(this.getChildren())) {
            for (CenterFunctionTree child : this.getChildren()) {
                allNodes.addAll(child.toConfigurationFunctionList(this));
            }
        }
        return allNodes;
    }

    public void validate(Set<Long> hasCheckedIds, Set<String> hasCheckedCodes) {
        if (hasCheckedIds.contains(this.getId())) {
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.FUNCTION_ID_REPEAT, new Object[]{this.getId()});
        }
        if (hasCheckedCodes.contains(this.getCode())) {
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.FUNCTION_CODE_REPEAT, new Object[]{this.getCode()});
        }
        hasCheckedIds.add(this.getId());
        hasCheckedCodes.add(this.getCode());
        if (null != this.getChildren()) {
            for (CenterFunctionTree child : this.getChildren()) {
                child.validate(hasCheckedIds, hasCheckedCodes);
            }
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getUrlRoutePath() {
        return this.urlRoutePath;
    }

    public void setUrlRoutePath(String urlRoutePath) {
        this.urlRoutePath = urlRoutePath;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public List<CenterFunctionTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<CenterFunctionTree> children) {
        this.children = children;
    }

    public boolean contains(Long id) {
        if (this.id.equals(id)) {
            return true;
        }
        if (null != this.children) {
            for (CenterFunctionTree child : this.children) {
                if (!child.contains(id)) continue;
                return true;
            }
        }
        return false;
    }
}

