/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.application.service;

import com.cyberway.mp.bbc.configuration.api.CenterFunctionTree;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.ConfigurationConstant;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueType;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationExportQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupCreateDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupOrderModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationImportParamDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationItemQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationRegisterDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationSingleQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.EnableRelateConfigurationMetadataQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.SpiRegisterDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationFullVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationGroupVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataTreeVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataVo;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationCacheService;
import com.cyberway.mp.bbc.configuration.domain.entity.Configuration;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationFunction;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationMetadata;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationFunctionService;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationGroupService;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationMetadataService;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationService;
import com.cyberway.mp.bbc.configuration.domain.service.SpiConfigurationRegister;
import com.cyberway.mp.bc.cache.annotation.MultiLevelEvict;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.lock.LockService;
import jakarta.validation.Valid;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
public class ConfigurationApplicationService
implements ConfigurationApi {
    private final ConfigurationGroupService configurationGroupService;
    private final ConfigurationService configurationService;
    private final ConfigurationMetadataService configurationMetadataService;
    private final ConfigurationFunctionService configurationFunctionService;
    private final ConfigurationCacheService configurationCacheService;
    private final LockService lockService;
    private final SpiConfigurationRegister spiConfigurationRegister;
    @Value(value="${spring.application.name:}")
    private String serviceName;

    public ConfigurationApplicationService(ConfigurationGroupService configurationGroupService, ConfigurationService configurationService, ConfigurationMetadataService configurationMetadataService, ConfigurationFunctionService configurationFunctionService, ConfigurationCacheService configurationCacheService, LockService lockService, SpiConfigurationRegister spiConfigurationRegister) {
        this.configurationGroupService = configurationGroupService;
        this.configurationService = configurationService;
        this.configurationMetadataService = configurationMetadataService;
        this.configurationFunctionService = configurationFunctionService;
        this.configurationCacheService = configurationCacheService;
        this.lockService = lockService;
        this.spiConfigurationRegister = spiConfigurationRegister;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyConfigurationGroupOrder(@Valid ConfigurationGroupOrderModifyDto orderModifyDto) {
        this.configurationGroupService.modifyOrder(orderModifyDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteConfigurationGroup(Long id) {
        this.configurationGroupService.delete(id);
        this.configurationService.moveToTargetGroup(id, 0L);
    }

    @Override
    public void modifyConfigurationGroup(Long id, @Valid ConfigurationGroupModifyDto modifyDto) {
        this.configurationGroupService.modify(id, modifyDto);
    }

    @Override
    public Long createConfigurationGroup(@Valid ConfigurationGroupCreateDto createDto) {
        this.configurationFunctionService.validateFunctionIds(this.serviceName, Collections.singleton(createDto.getFunctionId()));
        return this.configurationGroupService.create(createDto);
    }

    @Override
    public List<CenterFunctionTree> getFunctionTree() {
        return this.configurationFunctionService.getTree();
    }

    @Override
    public List<ConfigurationGroupVo> listConfigurationGroup(Long functionId, String name) {
        return this.configurationGroupService.queryByFunctionIdAndName(functionId, name);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @MultiLevelEvict(allEntries=true, value={"STR_SINGLE_CONFIGURATION", "STR_MULTI_CONFIGURATION", "OBJECT_MULTI_CONFIGURATION", "OBJECT_MAP_CONFIGURATION_UPGRADE", "OBJECT_MULTI_CONFIGURATION_UPGRADE"})
    public Long configRegister(@Valid ConfigurationRegisterDto registerDto) {
        this.configurationFunctionService.validateFunctionIds(this.serviceName, Collections.singleton(registerDto.getFunctionGroupId()));
        this.configurationFunctionService.validateFunctionCodes(this.serviceName, Collections.singleton(registerDto.getFunctionGroupCode()));
        ConfigurationMetadata metadata = this.configurationMetadataService.register(registerDto);
        this.configurationService.createConfigurationByMetadata(metadata);
        return (Long)metadata.getId();
    }

    @Override
    public List<ConfigurationMetadataVo> listConfigurationMetadata(ConfigurationMetadataQueryDto queryDto) {
        return this.configurationMetadataService.search(queryDto);
    }

    @Override
    public List<ConfigurationMetadataTreeVo> getConfigurationMetadataTree(ConfigurationMetadataQueryDto queryDto) {
        List<ConfigurationMetadataVo> list = this.configurationMetadataService.search(queryDto);
        return this.configurationMetadataService.buildTree(list);
    }

    private ConfigurationMetadataVo getNullableConfigurationMetadataVo(Long id) {
        ConfigurationMetadataVo configurationMetadataVo = null;
        if (null != id) {
            configurationMetadataVo = this.configurationMetadataService.get(id);
        }
        return configurationMetadataVo;
    }

    @Override
    public List<ConfigurationMetadataVo> getEnableRelateConfigurationMetadataList(@Valid EnableRelateConfigurationMetadataQueryDto queryDto) {
        ConfigurationMetadataVo parentConfigurationMetadata = this.getNullableConfigurationMetadataVo(queryDto.getParentConfigurationMetadataId());
        ConfigurationMetadataQueryDto configurationMetadataQueryDto = new ConfigurationMetadataQueryDto();
        configurationMetadataQueryDto.setFunctionGroupId(queryDto.getFunctionGroupId());
        configurationMetadataQueryDto.setGroupId(queryDto.getGroupId());
        List<ConfigurationMetadataVo> configurationMetadataVoList = this.configurationMetadataService.search(configurationMetadataQueryDto);
        LevelType parentMinLevelType = null;
        if (null != parentConfigurationMetadata) {
            parentMinLevelType = parentConfigurationMetadata.getMinLevelType();
        }
        LevelType finalParentMinLevelType = parentMinLevelType;
        return configurationMetadataVoList.stream().filter(c -> {
            if (null != finalParentMinLevelType) {
                return finalParentMinLevelType.equals((Object)c.getMinLevelType());
            }
            return true;
        }).filter(c -> {
            if (null != parentConfigurationMetadata) {
                return !c.getId().equals(parentConfigurationMetadata.getId()) && (0L == c.getParentId() || parentConfigurationMetadata.getId().equals(c.getParentId())) && !parentConfigurationMetadata.getAllParentId().contains("|" + c.getId() + "|");
            }
            return 0L == c.getParentId();
        }).filter(c -> {
            if (StringUtils.isNotBlank((CharSequence)queryDto.getConfigurationNameLike())) {
                return c.getName().contains(queryDto.getConfigurationNameLike());
            }
            return true;
        }).collect(Collectors.toList());
    }

    @Override
    public Page<ConfigurationMetadataVo> pageConfigurationMetadata(ConfigurationMetadataQueryDto queryDto) {
        return this.configurationMetadataService.page(queryDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyConfigurationMetadata(Long id, @Valid ConfigurationMetadataModifyDto dto) {
        ConfigurationMetadata metadata = this.configurationMetadataService.modify(id, dto);
        this.configurationService.modifyByMetadata(metadata);
    }

    @Override
    public ConfigurationMetadataVo getConfigurationMetadata(Long id) {
        return this.configurationMetadataService.get(id);
    }

    @Override
    public ConfigurationMetadataVo getConfigurationMetadataByKey(String key) {
        return this.configurationMetadataService.getByKey(key);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @MultiLevelEvict(allEntries=true, value={"STR_SINGLE_CONFIGURATION", "STR_MULTI_CONFIGURATION", "OBJECT_MULTI_CONFIGURATION", "OBJECT_MAP_CONFIGURATION_UPGRADE", "OBJECT_MULTI_CONFIGURATION_UPGRADE"})
    public void modifyConfiguration(Long id, ConfigurationModifyDto configurationModifyDto) {
        this.configurationService.modifyConfiguration(id, configurationModifyDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @MultiLevelEvict(allEntries=true, value={"STR_SINGLE_CONFIGURATION", "STR_MULTI_CONFIGURATION", "OBJECT_MULTI_CONFIGURATION", "OBJECT_MAP_CONFIGURATION_UPGRADE", "OBJECT_MULTI_CONFIGURATION_UPGRADE"})
    public void batchModifyConfiguration(@Valid List<ConfigurationModifyDto> modifyDtoList) {
        this.configurationService.batchModifyConfiguration(modifyDtoList);
    }

    @Override
    public List<ConfigurationFullVo> listConfiguration(@Valid ConfigurationQueryDto queryDto) {
        List<Configuration> allConfigList = this.configurationService.queryAllLevelConfiguration(queryDto);
        if (queryDto.getLevelType() != null) {
            allConfigList = allConfigList.stream().filter(config -> {
                LevelType minLevelType = config.getMinLevelType();
                return queryDto.getLevelType().ordinal() <= minLevelType.ordinal();
            }).collect(Collectors.toList());
        }
        List<Configuration> targetConfigList = this.configurationService.merge(queryDto, allConfigList, (Long)ObjectUtils.defaultIfNull((Object)queryDto.getBusinessZoneId(), (Object)ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID));
        List<ConfigurationMetadataVo> metadataList = this.configurationMetadataService.searchByConfigurationQueryDto(queryDto);
        if (queryDto.getLevelType() != null) {
            metadataList = metadataList.stream().filter(config -> {
                LevelType minLevelType = config.getMinLevelType();
                return queryDto.getLevelType().ordinal() <= minLevelType.ordinal();
            }).collect(Collectors.toList());
        }
        List<ConfigurationMetadataTreeVo> metadataTreeList = this.configurationMetadataService.buildTree(metadataList);
        return this.configurationService.buildFullVo(targetConfigList, metadataList, metadataTreeList, queryDto.getDesensitizeFlag());
    }

    @Override
    public String getStringValue(String functionGroupCode, String key, LevelType levelType, Long levelId) {
        return this.configurationCacheService.getStringValue(functionGroupCode, key, levelType, levelId, this.getRequestBusinessZoneId());
    }

    @Override
    public List<String> getStringValueList(List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getStringValueList(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public List<Object> getObjectValueList(@Valid List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getObjectValueList(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public List<Object> getObjectValueListWithoutLogin(@Valid List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getObjectValueListWithoutLogin(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public List<Object> getObjectValueListUpgrade(@Valid List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getObjectValueListUpgrade(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public Map<String, Object> getObjectValueMapUpgrade(@Valid List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getObjectValueMapUpgrade(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public Map<String, Object> buildConfigurationResultMap(List<ConfigurationItemQueryDto> queryList, List<Object> valueList) {
        return this.configurationCacheService.buildConfigurationResultMap(queryList, valueList);
    }

    @Override
    public List<ConfigurationExportData> queryExportData(ConfigurationExportQueryDto queryDto) {
        return this.configurationService.queryExportData(queryDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @MultiLevelEvict(allEntries=true, value={"STR_SINGLE_CONFIGURATION", "STR_MULTI_CONFIGURATION", "OBJECT_MULTI_CONFIGURATION", "OBJECT_MAP_CONFIGURATION_UPGRADE", "OBJECT_MULTI_CONFIGURATION_UPGRADE"})
    public void importByConfigurationExportData(ConfigurationImportParamDto paramDto) {
        this.configurationGroupService.importByConfigurationExportData(paramDto.getExportDataList());
        this.configurationMetadataService.importByConfigurationExportData(paramDto.getExportDataList());
        this.configurationService.importByConfigurationExportData(paramDto);
    }

    @Override
    public List<Object> getObjectValueListWithoutLoginUpgrade(@Valid List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getObjectValueListWithoutLoginUpgrade(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public Map<String, Object> getObjectValueMapWithoutLoginUpgrade(@Valid List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getObjectValueMapWithoutLoginUpgrade(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public List<String> getStringValueListWithoutLogin(List<ConfigurationItemQueryDto> queryList) {
        return this.configurationCacheService.getStringValueListWithoutLogin(queryList, this.getRequestBusinessZoneId());
    }

    @Override
    public String getStringValueWithoutLogin(String functionGroupCode, String key, LevelType levelType, Long levelId) {
        return this.configurationCacheService.getStringValueWithoutLogin(functionGroupCode, key, levelType, levelId, this.getRequestBusinessZoneId());
    }

    @Override
    public String getStringValue(@Valid ConfigurationSingleQueryDto queryDto) {
        return this.configurationCacheService.getStringValue(queryDto, this.getRequestBusinessZoneId());
    }

    @Override
    public String getStringValueWithoutLogin(@Valid ConfigurationSingleQueryDto queryDto) {
        return this.configurationCacheService.getStringValueWithoutLogin(queryDto, this.getRequestBusinessZoneId());
    }

    @Override
    public Map<String, String> getConfigMapByFunctionGroupCode(@Valid ConfigurationQueryDto queryDto) {
        return this.configurationService.getConfigMapByFunctionGroupCode(queryDto);
    }

    @Override
    public List<ConfigurationValueType> listConfigurationValueType() {
        return Arrays.asList(ConfigurationValueType.values());
    }

    @Override
    @MultiLevelEvict(allEntries=true, value={"STR_SINGLE_CONFIGURATION", "STR_MULTI_CONFIGURATION", "OBJECT_MULTI_CONFIGURATION", "OBJECT_MAP_CONFIGURATION_UPGRADE", "OBJECT_MULTI_CONFIGURATION_UPGRADE"})
    public void spiRegister(@Valid List<SpiRegisterDto> registerDtoList) {
        if (null == this.lockService) {
            throw new UnsupportedOperationException("spiRegister need LockService instance!");
        }
        List<ConfigurationFunction> functionList = this.configurationFunctionService.listByCodes(this.serviceName, registerDtoList.stream().map(SpiRegisterDto::getFunctionGroupCode).collect(Collectors.toSet()));
        this.configurationMetadataService.validateSpiRegisterDto(functionList, registerDtoList);
        for (SpiRegisterDto spiRegisterDto : registerDtoList) {
            boolean isLock = false;
            String lockKey = String.format("lock:post_spi_%s_%s", spiRegisterDto.getFunctionGroupCode(), spiRegisterDto.getConfigurationKey());
            try {
                isLock = this.lockService.tryLock(lockKey, TimeUnit.SECONDS, 1L, 10L);
                if (!isLock) continue;
                this.spiConfigurationRegister.register(spiRegisterDto);
                this.lockService.unlock(lockKey);
            }
            catch (Exception e) {
                if (isLock) {
                    this.lockService.unlock(lockKey);
                }
                throw new BaseException("00000001", "spi\u4e0a\u62a5\u5f02\u5e38");
            }
        }
    }

    private Long getRequestBusinessZoneId() {
        return (Long)ObjectUtils.defaultIfNull((Object)ServiceContext.getContext().getRequestBusinessZoneId(), (Object)ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID);
    }
}

