/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.application.service;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationConstant;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationItemQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationSingleQueryDto;
import com.cyberway.mp.bbc.configuration.domain.entity.Configuration;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationService;
import com.cyberway.mp.bbc.configuration.infra.facade.uc.UcFacadeService;
import com.cyberway.mp.bbc.configuration.infra.facade.uc.vo.AppInstanceInfoVo;
import com.cyberway.mp.bc.cache.annotation.MultiLevelCacheable;
import com.cyberway.mp.bc.cache.annotation.PosType;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

public class ConfigurationCacheService {
    private final ConfigurationService configurationService;
    private final UcFacadeService ucFacadeService;

    public ConfigurationCacheService(ConfigurationService configurationService, UcFacadeService ucFacadeService) {
        this.configurationService = configurationService;
        this.ucFacadeService = ucFacadeService;
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"STR_SINGLE_CONFIGURATION"}, posType=PosType.REMOTE)
    public String getStringValue(String functionGroupCode, String key, LevelType levelType, Long levelId, Long businessZoneId) {
        String stringValue;
        if (!ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID.equals(businessZoneId) && (stringValue = this.configurationService.getStringValue(functionGroupCode, key, LevelType.ZONE, businessZoneId)) != null) {
            return stringValue;
        }
        return this.configurationService.getStringValue(functionGroupCode, key, levelType, levelId);
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"STR_MULTI_CONFIGURATION"}, posType=PosType.REMOTE)
    public List<String> getStringValueList(List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        return this.getValueList(queryList, businessZoneId, this.configurationService::getStringValueList);
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"OBJECT_MULTI_CONFIGURATION"}, posType=PosType.REMOTE)
    public List<Object> getObjectValueList(@Valid List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        return this.getValueList(queryList, businessZoneId, this.configurationService::getObjectValueList);
    }

    private <T> List<T> getValueList(List<ConfigurationItemQueryDto> queryList, Long businessZoneId, Function<List<ConfigurationItemQueryDto>, List<T>> function) {
        if (CollectionUtils.isEmpty(queryList)) {
            return Collections.emptyList();
        }
        if (ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID.equals(businessZoneId)) {
            return function.apply(queryList);
        }
        List<T> result = function.apply(queryList.stream().map(dto -> this.convertToBusinessZoneDto((ConfigurationItemQueryDto)dto, businessZoneId)).collect(Collectors.toList()));
        ArrayList<Integer> nullIndex = new ArrayList<Integer>();
        ArrayList<ConfigurationItemQueryDto> nullDtoList = new ArrayList<ConfigurationItemQueryDto>();
        for (int i = 0; i < result.size(); ++i) {
            if (result.get(i) != null) continue;
            nullIndex.add(i);
            nullDtoList.add(queryList.get(i));
        }
        if (!nullDtoList.isEmpty()) {
            List<T> nullResult = function.apply(nullDtoList);
            for (int i = 0; i < nullResult.size(); ++i) {
                result.set((Integer)nullIndex.get(i), nullResult.get(i));
            }
        }
        return result;
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"OBJECT_MULTI_CONFIGURATION"}, posType=PosType.REMOTE)
    public List<Object> getObjectValueListWithoutLogin(@Valid List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        this.configurationService.checkConfigWitheList(queryList.stream().map(ConfigurationItemQueryDto::getFunctionGroupCode).collect(Collectors.toList()), queryList.stream().map(ConfigurationItemQueryDto::getKey).collect(Collectors.toList()));
        return this.getObjectValueList(queryList, businessZoneId);
    }

    private ConfigurationItemQueryDto convertToBusinessZoneDto(ConfigurationItemQueryDto dto, Long businessZoneId) {
        ConfigurationItemQueryDto newDto = new ConfigurationItemQueryDto();
        newDto.setKey(dto.getKey());
        newDto.setLevelType(LevelType.ZONE);
        newDto.setLevelId(businessZoneId);
        newDto.setFunctionGroupCode(dto.getFunctionGroupCode());
        return newDto;
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"OBJECT_MULTI_CONFIGURATION_UPGRADE"}, posType=PosType.REMOTE)
    public List<Object> getObjectValueListUpgrade(@Valid List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        if (queryList.isEmpty()) {
            return Collections.emptyList();
        }
        String splitStr = ":";
        List keyList = queryList.stream().map(dto -> dto.getFunctionGroupCode() + splitStr + dto.getKey()).collect(Collectors.toList());
        ArrayList resultConfiguration = new ArrayList(keyList.size());
        ArrayList<Object> result = new ArrayList<Object>(keyList.size());
        Map<LevelType, List<ConfigurationItemQueryDto>> queryMap = queryList.stream().collect(Collectors.groupingBy(ConfigurationItemQueryDto::getLevelType));
        queryMap.forEach((levelType, configurationItemQueryDtoList) -> {
            ConfigurationQueryDto queryDto = this.buildConfigurationQueryDto((List<ConfigurationItemQueryDto>)configurationItemQueryDtoList);
            resultConfiguration.addAll(this.configurationService.getObjectValueListUpgrade(queryDto, (List<ConfigurationItemQueryDto>)configurationItemQueryDtoList, businessZoneId));
        });
        for (String key : keyList) {
            Configuration target = resultConfiguration.stream().filter(c -> {
                if (null != c) {
                    String tempKey = c.getFunctionGroupCode() + splitStr + c.getConfigurationKey();
                    return tempKey.equals(key);
                }
                return false;
            }).findFirst().orElse(null);
            result.add(target == null ? null : target.getObjectVal());
        }
        return result;
    }

    private ConfigurationQueryDto buildConfigurationQueryDto(List<ConfigurationItemQueryDto> queryList) {
        if (org.springframework.util.CollectionUtils.isEmpty(queryList)) {
            return null;
        }
        LevelType levelType = queryList.get(0).getLevelType();
        Long levelId = queryList.get(0).getLevelId();
        for (int i = 1; i < queryList.size(); ++i) {
            if (Objects.equals(queryList.get(i).getLevelId(), levelId) && Objects.equals((Object)queryList.get(i).getLevelType(), (Object)levelType)) continue;
            throw new IllegalArgumentException("levelId or levelType not match");
        }
        ConfigurationQueryDto dto = new ConfigurationQueryDto();
        dto.setLevelType(levelType);
        switch (levelType) {
            case INSTANCE: {
                AppInstanceInfoVo instanceInfoVo = this.ucFacadeService.getAppInstance(levelId);
                if (null == instanceInfoVo) {
                    throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{levelId});
                }
                dto.setTenantId(instanceInfoVo.getTenantId());
                dto.setAppInstanceId(levelId);
                break;
            }
            case TENANT: {
                dto.setTenantId(levelId);
                break;
            }
            case ZONE: {
                throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.NOT_ALLOW_QUERY_LEVEL);
            }
        }
        return dto;
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"OBJECT_MAP_CONFIGURATION_UPGRADE"}, posType=PosType.REMOTE)
    public Map<String, Object> getObjectValueMapUpgrade(@Valid List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        List<Object> valueList = this.getObjectValueListUpgrade(queryList, businessZoneId);
        return this.buildConfigurationResultMap(queryList, valueList);
    }

    public Map<String, Object> buildConfigurationResultMap(List<ConfigurationItemQueryDto> queryList, List<Object> valueList) {
        if (null == queryList || valueList == null) {
            return Collections.emptyMap();
        }
        if (queryList.size() != valueList.size()) {
            throw new IllegalArgumentException("configuration size not match");
        }
        HashMap<String, Object> map = new HashMap<String, Object>(queryList.size());
        for (int i = 0; i < queryList.size(); ++i) {
            map.put(queryList.get(i).getKey(), valueList.get(i));
        }
        return map;
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"OBJECT_MULTI_CONFIGURATION_UPGRADE"}, posType=PosType.REMOTE)
    public List<Object> getObjectValueListWithoutLoginUpgrade(@Valid List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        this.configurationService.checkConfigWitheList(queryList.stream().map(ConfigurationItemQueryDto::getFunctionGroupCode).collect(Collectors.toList()), queryList.stream().map(ConfigurationItemQueryDto::getKey).collect(Collectors.toList()));
        return this.getObjectValueListUpgrade(queryList, businessZoneId);
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"OBJECT_MAP_CONFIGURATION_UPGRADE"}, posType=PosType.REMOTE)
    public Map<String, Object> getObjectValueMapWithoutLoginUpgrade(@Valid List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        List<Object> valueList = this.getObjectValueListWithoutLoginUpgrade(queryList, businessZoneId);
        return this.buildConfigurationResultMap(queryList, valueList);
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"STR_MULTI_CONFIGURATION"}, posType=PosType.REMOTE)
    public List<String> getStringValueListWithoutLogin(List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        this.configurationService.checkConfigWitheList(queryList.stream().map(ConfigurationItemQueryDto::getFunctionGroupCode).collect(Collectors.toList()), queryList.stream().map(ConfigurationItemQueryDto::getKey).collect(Collectors.toList()));
        return this.getStringValueList(queryList, businessZoneId);
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"STR_SINGLE_CONFIGURATION"}, posType=PosType.REMOTE)
    public String getStringValueWithoutLogin(String functionGroupCode, String key, LevelType levelType, Long levelId, Long businessZoneId) {
        this.configurationService.checkConfigWitheList(Collections.singletonList(functionGroupCode), Collections.singletonList(key));
        return this.getStringValue(functionGroupCode, key, levelType, levelId, businessZoneId);
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"STR_SINGLE_CONFIGURATION"}, posType=PosType.REMOTE)
    public String getStringValue(@Valid ConfigurationSingleQueryDto queryDto, Long businessZoneId) {
        return this.configurationService.getStringValue(queryDto, businessZoneId);
    }

    @MultiLevelCacheable(keyGenerator="configurationDefaultKeyGenerator", ttl=18000, value={"STR_SINGLE_CONFIGURATION"}, posType=PosType.REMOTE)
    public String getStringValueWithoutLogin(@Valid ConfigurationSingleQueryDto queryDto, Long businessZoneId) {
        this.configurationService.checkConfigWitheList(Collections.singletonList(queryDto.getFunctionGroupCode()), Collections.singletonList(queryDto.getConfigurationKey()));
        return this.getStringValue(queryDto, businessZoneId);
    }
}

