/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.application.service;

import com.cyberway.mp.bbc.configuration.api.CenterFunctionTree;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationExportQueryDto;
import com.cyberway.mp.bbc.configuration.infra.config.FunctionTreeProperties;
import com.cyberway.mp.bbc.configuration.infra.facade.aggregation.ConfigurationAggregationService;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class ConfigurationExportService {
    private final FunctionTreeProperties functionTreeProperties;
    private final ConfigurationAggregationService configurationAggregationService;

    public ConfigurationExportService(FunctionTreeProperties functionTreeProperties, ConfigurationAggregationService configurationAggregationService) {
        this.functionTreeProperties = functionTreeProperties;
        this.configurationAggregationService = configurationAggregationService;
    }

    public List<List<Object>> queryAllExportData(ConfigurationExportQueryDto queryDto) {
        Set<String> targetServiceNames = this.functionTreeProperties.getNodes().stream().map(CenterFunctionTree::getServiceName).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        List<ConfigurationExportData> configurationExportDataList = this.configurationAggregationService.queryExportData(targetServiceNames, queryDto);
        return configurationExportDataList.stream().map(d -> {
            ArrayList<Object> object = new ArrayList<Object>();
            object.add(d.getFunctionGroupId());
            object.add(d.getFunctionGroupName());
            object.add(d.getConfigurationGroupId());
            object.add(d.getConfigurationGroupName());
            object.add(d.getConfigurationGroupOrderNum());
            object.add(d.getConfigurationMetadataId());
            object.add(d.getConfigurationName());
            object.add(d.getConfigurationKey());
            object.add(d.getValueType());
            object.add(d.getDescription());
            object.add(d.getDefaultValue());
            object.add(d.getConfigurationItems());
            object.add(d.getInsertType());
            object.add(d.getSpiType());
            object.add(d.getParentId());
            object.add(d.getAllParentId());
            object.add(d.getRelateConfigurationItemValue());
            object.add(d.getConfigurationId());
            object.add(d.getTenantId());
            object.add(d.getBusinessZoneId());
            object.add(d.getAppInstanceId());
            object.add(d.getLevelType());
            object.add(d.getLevelId());
            object.add(d.getConfigurationValue());
            object.add(d.getEnableModify());
            object.add(d.getDesensitizeFlag());
            return object;
        }).collect(Collectors.toList());
    }
}

