/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.application.service;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationItem;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueInsertType;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationRegisterDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataVo;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationFunction;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationFunctionService;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.utils.BeanUtils;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import com.cyberway.mp.bc.poi.importer.AbstractImportExcelBatchHandler;
import com.cyberway.mp.bc.poi.importer.ImportResult;
import com.cyberway.mp.bc.poi.importer.model.WrapRow;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

@Deprecated(since="1.10.0")
public class ConfigurationImportApplicationService
extends AbstractImportExcelBatchHandler {
    @Value(value="${spring.application.name:}")
    private String serviceName;
    private static final String FUNCTION_LIST = "FUNCTION_LIST";
    private static final String FUNCTION_MAP = "FUNCTION_MAP";
    private static final String CONFIGURATION_MAP = "CONFIGURATION_MAP";
    private static final String CONFIGURATION_ITEM_MAP = "CONFIGURATION_ITEM_MAP";
    private final ExecutorService executorService;
    private final ConfigurationFunctionService configurationFunctionService;
    private final ConfigurationApi configurationApi;

    public ConfigurationImportApplicationService(ExecutorService executorService, ConfigurationFunctionService configurationFunctionService, ConfigurationApi configurationApi) {
        this.executorService = executorService;
        this.configurationFunctionService = configurationFunctionService;
        this.configurationApi = configurationApi;
    }

    public List<ImportResult> importConfiguration(InputStream is) {
        ServiceContext.getContext().setAttachment(FUNCTION_LIST, new ArrayList());
        ServiceContext.getContext().setAttachment(FUNCTION_MAP, new HashMap(16));
        ServiceContext.getContext().setAttachment(CONFIGURATION_MAP, new HashMap(16));
        ServiceContext.getContext().setAttachment(CONFIGURATION_ITEM_MAP, new HashMap(16));
        return super.importExcel((List)Lists.newArrayList((Object[])new Integer[]{0, 1, 2}), is);
    }

    public String handleRow(Integer sheetNo, WrapRow row) {
        switch (sheetNo) {
            case 0: {
                return this.processConfiguration(row);
            }
            case 1: {
                return this.processConfigurationItem(row);
            }
        }
        return null;
    }

    public void doAfterHandleRow(Integer sheetNo, ImportResult importResult) {
        if (sheetNo != 1) {
            return;
        }
        Map configurationRegisterMap = (Map)ServiceContext.getContext().get(CONFIGURATION_MAP);
        Map configurationItemMap = (Map)ServiceContext.getContext().get(CONFIGURATION_ITEM_MAP);
        ArrayList allFutures = new ArrayList();
        configurationRegisterMap.forEach((functionCode, configurationList) -> {
            ConfigurationFunction function = this.configurationFunctionService.getByCode(this.serviceName, (String)functionCode);
            Optional.ofNullable(function).orElseThrow(() -> new BaseI18nException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{"functionCode"}));
            List<String> configurationKeys = configurationList.stream().map(ConfigurationRegisterDto::getConfigurationKey).distinct().collect(Collectors.toList());
            ConfigurationMetadataQueryDto configurationMetadataQueryDto = new ConfigurationMetadataQueryDto();
            configurationMetadataQueryDto.setFunctionGroupId((Long)function.getId());
            configurationMetadataQueryDto.setConfigurationKeys(configurationKeys);
            List<ConfigurationMetadataVo> configurationMetadataVos = this.configurationApi.listConfigurationMetadata(configurationMetadataQueryDto);
            Map configurationMetadataVoMap = configurationMetadataVos.stream().collect(Collectors.toMap(ConfigurationMetadataVo::getConfigurationKey, Function.identity()));
            List futures = configurationList.stream().map(configurationRegisterDto -> {
                assert (this.executorService != null);
                return this.executorService.submit(() -> {
                    configurationRegisterDto.setFunctionGroupId((Long)function.getId());
                    configurationRegisterDto.setFunctionGroupCode(function.getCode());
                    List configurationItemList = (List)configurationItemMap.get(configurationRegisterDto.getConfigurationKey());
                    if (CollectionUtils.isNotEmpty((Collection)configurationItemList)) {
                        String defaultValue = configurationItemList.stream().filter(ConfigurationItem::isDefault).map(ConfigurationItem::getValue).collect(Collectors.joining(","));
                        configurationRegisterDto.setDefaultValue(defaultValue);
                    }
                    configurationRegisterDto.setConfigurationItemList(configurationItemList);
                    ConfigurationMetadataVo configurationMetadataVo = (ConfigurationMetadataVo)configurationMetadataVoMap.get(configurationRegisterDto.getConfigurationKey());
                    if (null != configurationMetadataVo) {
                        ConfigurationMetadataModifyDto configurationMetadataModifyDto = (ConfigurationMetadataModifyDto)BeanUtils.copyProperties((Object)new ConfigurationMetadataModifyDto(), (Object)configurationRegisterDto);
                        this.configurationApi.modifyConfigurationMetadata(configurationMetadataVo.getId(), configurationMetadataModifyDto);
                    } else {
                        this.configurationApi.configRegister((ConfigurationRegisterDto)configurationRegisterDto);
                    }
                });
            }).collect(Collectors.toList());
            allFutures.addAll(futures);
        });
        for (Future future : allFutures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                throw new BaseI18nException((Throwable)e);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new BaseI18nException((Throwable)ex);
            }
        }
    }

    private String processConfiguration(WrapRow row) {
        StringBuilder error = new StringBuilder();
        String functionGroupCode = row.readString(0);
        error.append(this.checkEmpty("\u6240\u5c5e\u80fd\u529b\u7f16\u7801", functionGroupCode));
        String name = row.readString(1);
        error.append(this.checkEmpty("\u914d\u7f6e\u9879\u540d\u79f0", name));
        String configurationKey = row.readString(2);
        error.append(this.checkEmpty("\u914d\u7f6e\u9879\u7f16\u7801", configurationKey));
        String configurationValueInsertType = row.readString(3);
        error.append(this.checkEmpty("\u914d\u7f6e\u9879\u503c\u7f16\u8f91\u65b9\u5f0f", configurationValueInsertType));
        String valueType = row.readString(4);
        error.append(this.checkEmpty("\u914d\u7f6e\u9879\u503c\u7c7b\u578b", valueType));
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return error.toString();
        }
        Map configurationRegisterMap = (Map)ServiceContext.getContext().get(CONFIGURATION_MAP);
        List configurationRegisterDtoList = null;
        configurationRegisterDtoList = configurationRegisterMap.containsKey(functionGroupCode) ? (List)configurationRegisterMap.get(functionGroupCode) : new ArrayList();
        ConfigurationRegisterDto configurationRegisterDto = new ConfigurationRegisterDto();
        configurationRegisterDto.setFunctionGroupCode(functionGroupCode);
        configurationRegisterDto.setName(name);
        configurationRegisterDto.setConfigurationKey(configurationKey);
        configurationRegisterDto.setConfigurationValueInsertType(ConfigurationValueInsertType.valueOf(configurationValueInsertType));
        configurationRegisterDto.setValueType(ConfigurationValueType.valueOf(valueType));
        configurationRegisterDtoList.add(configurationRegisterDto);
        configurationRegisterMap.put(functionGroupCode, configurationRegisterDtoList);
        ServiceContext.getContext().setAttachment(CONFIGURATION_MAP, (Object)configurationRegisterMap);
        return null;
    }

    private String processConfigurationItem(WrapRow row) {
        StringBuilder error = new StringBuilder();
        String configurationKey = row.readString(0);
        error.append(this.checkEmpty("\u6240\u5c5e\u914d\u7f6e\u9879\u7f16\u7801", configurationKey));
        String displayName = row.readString(1);
        error.append(this.checkEmpty("\u663e\u793a\u503c", displayName));
        String value = row.readString(2);
        error.append(this.checkEmpty("\u50a8\u5b58\u503c", value));
        String isDefault = row.readString(3);
        error.append(this.checkEmpty("\u662f\u5426\u9ed8\u8ba4", isDefault));
        if (StringUtils.isNotBlank((CharSequence)error)) {
            return error.toString();
        }
        Map configurationItemMap = (Map)ServiceContext.getContext().get(CONFIGURATION_ITEM_MAP);
        List configurationItemList = null;
        configurationItemList = configurationItemMap.containsKey(configurationKey) ? (List)configurationItemMap.get(configurationKey) : new ArrayList();
        ConfigurationItem configurationItem = new ConfigurationItem();
        configurationItem.setDisplayName(displayName);
        configurationItem.setValue(value);
        configurationItem.setDefault("\u662f".equals(isDefault));
        configurationItemList.add(configurationItem);
        configurationItemMap.put(configurationKey, configurationItemList);
        ServiceContext.getContext().setAttachment(CONFIGURATION_ITEM_MAP, (Object)configurationItemMap);
        return null;
    }

    private String checkEmpty(String fieldName, String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return fieldName + "\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return "";
    }

    public int getHeaderRowNum() {
        return 2;
    }
}

