/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.controller;

import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.longconverter.LongStringConverter;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationExportQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationImportParamDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationItemQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationSingleQueryDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationFullVo;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationExportService;
import com.cyberway.mp.bbc.configuration.infra.facade.aggregation.ConfigurationAggregationService;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/configuration"})
@ConditionalOnProperty(prefix="mp.bbc.configuration", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="configuration")
public class ConfigurationController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationApi configurationApi;
    private final ConfigurationAggregationService aggregationService;
    private final ConfigurationExportService configurationExportService;

    public ConfigurationController(ConfigurationApi configurationApi, ConfigurationAggregationService aggregationService, ConfigurationExportService configurationExportService) {
        this.configurationApi = configurationApi;
        this.aggregationService = aggregationService;
        this.configurationExportService = configurationExportService;
    }

    @GetMapping(value={"/getStringValue"})
    @Operation(summary="\u83b7\u53d6\u914d\u7f6e\u503c", operationId="getGetStringValue")
    public ResponseResult<String> getStringValue(@RequestParam(value="functionGroupCode") String functionGroupCode, @RequestParam(value="key") String key, @RequestParam(value="levelType") LevelType levelType, @RequestParam(value="levelId") Long levelId) {
        this.logger.debug("call ConfigurationController.getStringValue");
        return ResponseResult.successResult((Object)this.configurationApi.getStringValue(functionGroupCode, key, levelType, levelId));
    }

    @GetMapping(value={"/getStringValueWithoutLogin"})
    @Operation(summary="\u514d\u767b\u5f55\u83b7\u53d6\u914d\u7f6e\u503c", operationId="getGetStringValueWithoutLogin")
    public ResponseResult<String> getStringValueWithoutLogin(@RequestParam(value="functionGroupCode") String functionGroupCode, @RequestParam(value="key") String key, @RequestParam(value="levelType") LevelType levelType, @RequestParam(value="levelId") Long levelId) {
        this.logger.debug("call ConfigurationController.getStringValueWithoutLogin");
        return ResponseResult.successResult((Object)this.configurationApi.getStringValueWithoutLogin(functionGroupCode, key, levelType, levelId));
    }

    @PostMapping(value={"/getStringValue"})
    @Operation(summary="\u83b7\u53d6\u914d\u7f6e\u503c\uff0c\u83b7\u53d6\u4e0d\u5230\u6307\u5b9a\u5c42\u7ea7\u4f1a\u5411\u4e0a\u5339\u914d", operationId="postGetStringValue")
    public ResponseResult<String> getStringValue(@RequestBody ConfigurationSingleQueryDto queryDto) {
        this.logger.debug("call ConfigurationController.getStringValue");
        return ResponseResult.successResult((Object)this.configurationApi.getStringValue(queryDto));
    }

    @PostMapping(value={"/getStringValueList"})
    @Operation(summary="\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879")
    public ResponseResult<List<String>> getStringValueList(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getStringValueList");
        return ResponseResult.successResult(this.aggregationService.getStringValueList(queryList));
    }

    @PostMapping(value={"/getStringValueListWithoutLogin"})
    @Operation(summary="\u672a\u767b\u5f55\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879")
    public ResponseResult<List<String>> getStringValueListWithoutLogin(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getStringValueListWithoutLogin");
        return ResponseResult.successResult(this.aggregationService.getStringValueListWithoutLogin(queryList));
    }

    @PostMapping(value={"/getObjectValueList"})
    @Operation(summary="\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879\uff0c\u9664\u4e86\u65e5\u671f\u7c7b\u578b\u4f1a\u8f6c\u6362\u6210\u5bf9\u5e94\u6570\u636e\u7c7b\u578b")
    public ResponseResult<List<Object>> getObjectValueList(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getObjectValueList");
        return ResponseResult.successResult(this.aggregationService.getObjectValueList(queryList));
    }

    @PostMapping(value={"/getObjectValueListWithoutLogin"})
    @Operation(summary="\u672a\u767b\u5f55\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879\uff0c\u9664\u4e86\u65e5\u671f\u7c7b\u578b\u4f1a\u8f6c\u6362\u6210\u5bf9\u5e94\u6570\u636e\u7c7b\u578b")
    public ResponseResult<List<Object>> getObjectValueListWithoutLogin(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getObjectValueListWithoutLogin");
        return ResponseResult.successResult(this.aggregationService.getObjectValueListWithoutLogin(queryList));
    }

    @PostMapping(value={"/getObjectValueListUpgrade"})
    @Operation(summary="\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879\uff0c\u9664\u4e86\u65e5\u671f\u7c7b\u578b\u4f1a\u8f6c\u6362\u6210\u5bf9\u5e94\u6570\u636e\u7c7b\u578b\uff0c\u4f1a\u6839\u636e\u5bf9\u5e94\u5c42\u7ea7\u5411\u4e0a\u5339\u914d")
    public ResponseResult<List<Object>> getObjectValueListUpgrade(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getObjectValueListUpgrade");
        return ResponseResult.successResult(this.aggregationService.getObjectValueListUpgrade(queryList));
    }

    @PostMapping(value={"/getObjectValueMapUpgrade"})
    @Operation(summary="\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879\uff0c\u9664\u4e86\u65e5\u671f\u7c7b\u578b\u4f1a\u8f6c\u6362\u6210\u5bf9\u5e94\u6570\u636e\u7c7b\u578b\uff0c\u4f1a\u6839\u636e\u5bf9\u5e94\u5c42\u7ea7\u5411\u4e0a\u5339\u914d")
    public ResponseResult<Map<String, Object>> getObjectValueMapUpgrade(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getObjectValueMapUpgrade");
        return ResponseResult.successResult(this.aggregationService.getObjectValueMapUpgrade(queryList));
    }

    @PostMapping(value={"/getObjectValueListWithoutLoginUpgrade"})
    @Operation(summary="\u672a\u767b\u5f55\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879\uff0c\u9664\u4e86\u65e5\u671f\u7c7b\u578b\u4f1a\u8f6c\u6362\u6210\u5bf9\u5e94\u6570\u636e\u7c7b\u578b\uff0c\u4f1a\u6839\u636e\u5bf9\u5e94\u5c42\u7ea7\u5411\u4e0a\u5339\u914d")
    public ResponseResult<List<Object>> getObjectValueListWithoutLoginUpgrade(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getObjectValueListWithoutLoginUpgrade");
        return ResponseResult.successResult(this.aggregationService.getObjectValueListWithoutLoginUpgrade(queryList));
    }

    @PostMapping(value={"/getObjectValueMapWithoutLoginUpgrade"})
    @Operation(summary="\u672a\u767b\u5f55\u6279\u91cf\u83b7\u53d6\u914d\u7f6e\u9879\uff0c\u9664\u4e86\u65e5\u671f\u7c7b\u578b\u4f1a\u8f6c\u6362\u6210\u5bf9\u5e94\u6570\u636e\u7c7b\u578b\uff0c\u4f1a\u6839\u636e\u5bf9\u5e94\u5c42\u7ea7\u5411\u4e0a\u5339\u914d")
    public ResponseResult<Map<String, Object>> getObjectValueMapWithoutLoginUpgrade(@RequestBody List<ConfigurationItemQueryDto> queryList) {
        this.logger.debug("call ConfigurationController.getObjectValueMapWithoutLoginUpgrade");
        return ResponseResult.successResult(this.aggregationService.getObjectValueMapWithoutLoginUpgrade(queryList));
    }

    @PostMapping(value={"/getStringValueWithoutLogin"})
    @Operation(summary="\u514d\u767b\u5f55\u83b7\u53d6\u914d\u7f6e\u503c\uff0c\u83b7\u53d6\u4e0d\u5230\u6307\u5b9a\u5c42\u7ea7\u4f1a\u5411\u4e0a\u5339\u914d", operationId="postGetStringValueWithoutLogin")
    public ResponseResult<String> getStringValueWithoutLogin(@RequestBody ConfigurationSingleQueryDto queryDto) {
        this.logger.debug("call ConfigurationController.getStringValueWithoutLogin");
        return ResponseResult.successResult((Object)this.configurationApi.getStringValueWithoutLogin(queryDto));
    }

    @PostMapping(value={"/getConfigMapByFunctionGroupCode"})
    @Operation(summary="\u83b7\u53d6\u529f\u80fd\u5206\u7ec4\u4e0b\u7684\u914d\u7f6e\u952e\u503c\u5bf9\uff0c\u83b7\u53d6\u4e0d\u5230\u6307\u5b9a\u5c42\u7ea7\u4f1a\u5411\u4e0a\u5339\u914d")
    public ResponseResult<Map<String, String>> getConfigMapByFunctionGroupCode(@RequestBody ConfigurationQueryDto queryDto) {
        this.logger.debug("call ConfigurationController.getConfigMapByFunctionGroupCode");
        return ResponseResult.successResult(this.configurationApi.getConfigMapByFunctionGroupCode(queryDto));
    }

    @PostMapping(value={"/list"})
    @Operation(summary="\u5217\u8868\u67e5\u8be2")
    public ResponseResult<List<ConfigurationFullVo>> list(@RequestBody ConfigurationQueryDto queryDto) {
        this.logger.debug("call ConfigurationController.list");
        return ResponseResult.successResult(this.configurationApi.listConfiguration(queryDto));
    }

    @PostMapping(value={"/batchUpdate"})
    @Operation(summary="\u6279\u91cf\u66f4\u65b0\u914d\u7f6e\u9879")
    public ResponseResult<Void> batchUpdate(@RequestBody List<ConfigurationModifyDto> modifyDtoList) {
        this.logger.debug("call ConfigurationController.batchUpdate");
        this.configurationApi.batchModifyConfiguration(modifyDtoList);
        return ResponseResult.successResult();
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="\u914d\u7f6e\u9879\u4fee\u6539")
    public ResponseResult<Void> modify(@PathVariable(value="id") Long id, @RequestBody ConfigurationModifyDto modifyDto) {
        this.logger.debug("call ConfigurationController.modify");
        this.configurationApi.modifyConfiguration(id, modifyDto);
        return ResponseResult.successResult();
    }

    @PostMapping(value={"/queryExportData"})
    @Operation(summary="\u67e5\u8be2\u5bfc\u51fa\u6570\u636e")
    public ResponseResult<List<ConfigurationExportData>> queryExportData(@RequestBody ConfigurationExportQueryDto queryDto) {
        this.logger.debug("call ConfigurationController.queryExportData");
        return ResponseResult.successResult(this.configurationApi.queryExportData(queryDto));
    }

    @PostMapping(value={"/importByConfigurationExportData"})
    @Operation(summary="\u901a\u8fc7\u5bfc\u51fa\u6570\u636e\u8fdb\u884c\u5bfc\u5165")
    public ResponseResult<Void> importByConfigurationExportData(@RequestBody ConfigurationImportParamDto paramDto) {
        this.logger.debug("call ConfigurationController.importByConfigurationExportData");
        this.configurationApi.importByConfigurationExportData(paramDto);
        return ResponseResult.successResult();
    }

    @PostMapping(value={"/importData"})
    @Operation(summary="\u5bfc\u5165", description="\u73af\u5883\u8fc1\u79fb\u6570\u636e\u5bfc\u5165")
    public ResponseResult<Void> importData(@RequestParam(value="file") MultipartFile file, @RequestParam(required=false, defaultValue="0") int mode) {
        this.aggregationService.importData(file, mode);
        return ResponseResult.successResult();
    }

    @PostMapping(value={"/exportData"})
    @Operation(summary="\u5bfc\u51fa", description="\u73af\u5883\u8fc1\u79fb\u6570\u636e\u5bfc\u51fa")
    public void exportData(@RequestBody ConfigurationExportQueryDto queryDto, HttpServletResponse response) {
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u914d\u7f6e\u9879" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()), StandardCharsets.UTF_8).replace("+", "%20");
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName + ".xlsx");
            ((ExcelWriterBuilder)EasyExcelFactory.write((OutputStream)response.getOutputStream()).registerConverter((Converter)new LongStringConverter())).withTemplate(new ClassPathResource("template/\u914d\u7f6e\u6a21\u677f.xlsx").getInputStream()).build().write(this.configurationExportService.queryAllExportData(queryDto), EasyExcelFactory.writerSheet((Integer)0).build()).finish();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.BASE);
        }
    }
}

