/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.controller;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupCreateDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupOrderModifyDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationGroupVo;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/configurationGroup"})
@ConditionalOnProperty(prefix="mp.bbc.configuration", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="configurationGroup")
public class ConfigurationGroupController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationApi configurationApi;

    public ConfigurationGroupController(ConfigurationApi configurationApi) {
        this.configurationApi = configurationApi;
    }

    @GetMapping(value={"/listByFunction/{functionId}"})
    @Operation(summary="\u83b7\u53d6\u529f\u80fd\u4e0b\u7684\u914d\u7f6e\u5206\u7ec4")
    public ResponseResult<List<ConfigurationGroupVo>> listByFunction(@PathVariable(value="functionId") Long functionId, @RequestParam(name="name", required=false) String name) {
        this.logger.debug("call ConfigurationGroupController.listByFunction");
        return ResponseResult.successResult(this.configurationApi.listConfigurationGroup(functionId, name));
    }

    @PostMapping(value={"/"})
    @Operation(summary="\u521b\u5efa\u914d\u7f6e\u5206\u7ec4")
    public ResponseResult<Long> create(@RequestBody ConfigurationGroupCreateDto createDto) {
        this.logger.debug("call ConfigurationGroupController.create");
        return ResponseResult.successResult((Object)this.configurationApi.createConfigurationGroup(createDto));
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="\u66f4\u65b0\u914d\u7f6e\u5206\u7ec4")
    public ResponseResult<Void> modify(@PathVariable(value="id") Long id, @RequestBody ConfigurationGroupModifyDto modifyDto) {
        this.logger.debug("call ConfigurationGroupController.modify");
        this.configurationApi.modifyConfigurationGroup(id, modifyDto);
        return ResponseResult.successResult();
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="\u5220\u9664\u914d\u7f6e\u5206\u7ec4")
    public ResponseResult<Void> delete(@PathVariable(value="id") Long id) {
        this.logger.debug("call ConfigurationGroupController.delete");
        this.configurationApi.deleteConfigurationGroup(id);
        return ResponseResult.successResult();
    }

    @PutMapping(value={"/sort"})
    @Operation(summary="\u66f4\u65b0\u914d\u7f6e\u5206\u7ec4\u6392\u5e8f")
    public ResponseResult<Void> sort(@RequestBody ConfigurationGroupOrderModifyDto orderModifyDto) {
        this.logger.debug("call ConfigurationGroupController.sort");
        this.configurationApi.modifyConfigurationGroupOrder(orderModifyDto);
        return ResponseResult.successResult();
    }
}

