/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.controller;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationRegisterDto;
import com.cyberway.mp.bbc.configuration.api.dto.EnableRelateConfigurationMetadataQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.SpiRegisterDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataTreeVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataVo;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationImportApplicationService;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.bc.poi.importer.ImportResult;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/configurationMetadata"})
@ConditionalOnProperty(prefix="mp.bbc.configuration", name={"enabled"}, havingValue="true", matchIfMissing=true)
@Tag(name="configurationMetadata")
public class ConfigurationMetadataController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationApi configurationApi;
    private final ConfigurationImportApplicationService configurationImportApplicationService;

    public ConfigurationMetadataController(ConfigurationApi configurationApi, ConfigurationImportApplicationService configurationImportApplicationService) {
        this.configurationApi = configurationApi;
        this.configurationImportApplicationService = configurationImportApplicationService;
    }

    @PostMapping(value={"/register"})
    @Operation(summary="\u914d\u7f6e\u9879\u6ce8\u518c")
    public ResponseResult<Long> register(@RequestBody ConfigurationRegisterDto dto) {
        this.logger.debug("call ConfigurationMetadataController.register");
        return ResponseResult.successResult((Object)this.configurationApi.configRegister(dto));
    }

    @PostMapping(value={"/spi/register"})
    @Operation(summary="spi\u914d\u7f6e\u9879\u6ce8\u518c")
    public ResponseResult<Void> spiRegister(@RequestBody List<SpiRegisterDto> registerDtoList) {
        this.logger.debug("call ConfigurationMetadataController.spiRegister");
        this.configurationApi.spiRegister(registerDtoList);
        return ResponseResult.successResult();
    }

    @PostMapping(value={"/list"})
    @Operation(summary="\u914d\u7f6e\u9879\u5143\u6570\u636e\u5217\u8868\u67e5\u8be2")
    public ResponseResult<List<ConfigurationMetadataVo>> list(@RequestBody ConfigurationMetadataQueryDto queryDto) {
        this.logger.debug("call ConfigurationMetadataController.list");
        return ResponseResult.successResult(this.configurationApi.listConfigurationMetadata(queryDto));
    }

    @PostMapping(value={"/page"})
    @Operation(summary="\u914d\u7f6e\u9879\u5143\u6570\u636e\u5206\u9875\u67e5\u8be2")
    public ResponseResult<Page<ConfigurationMetadataVo>> page(@RequestBody ConfigurationMetadataQueryDto queryDto) {
        this.logger.debug("call ConfigurationMetadataController.page");
        return ResponseResult.successResult(this.configurationApi.pageConfigurationMetadata(queryDto));
    }

    @PostMapping(value={"/getConfigurationMetadataTree"})
    @Operation(summary="\u83b7\u53d6\u914d\u7f6e\u5143\u6570\u636e\u6811")
    public ResponseResult<List<ConfigurationMetadataTreeVo>> getConfigurationMetadataTree(@RequestBody ConfigurationMetadataQueryDto queryDto) {
        this.logger.debug("call ConfigurationMetadataController.getConfigurationMetadataTree");
        return ResponseResult.successResult(this.configurationApi.getConfigurationMetadataTree(queryDto));
    }

    @PostMapping(value={"/getEnableRelateConfigurationMetadataList"})
    @Operation(summary="\u83b7\u53d6\u5141\u8bb8\u5173\u8054\u7684\u5143\u6570\u636e\u5217\u8868")
    public ResponseResult<List<ConfigurationMetadataVo>> getEnableRelateConfigurationMetadataList(@RequestBody EnableRelateConfigurationMetadataQueryDto queryDto) {
        this.logger.debug("call ConfigurationMetadataController.getEnableRelateConfigurationMetadataList");
        return ResponseResult.successResult(this.configurationApi.getEnableRelateConfigurationMetadataList(queryDto));
    }

    @PutMapping(value={"/{id}"})
    @Operation(summary="\u914d\u7f6e\u9879\u5143\u6570\u636e\u4fee\u6539")
    public ResponseResult<Void> modify(@PathVariable(value="id") Long id, @RequestBody ConfigurationMetadataModifyDto modifyDto) {
        this.logger.debug("call ConfigurationMetadataController.modify");
        this.configurationApi.modifyConfigurationMetadata(id, modifyDto);
        return ResponseResult.successResult();
    }

    @GetMapping(value={"/{id}"})
    @Operation(summary="\u914d\u7f6e\u9879\u5143\u6570\u636e\u8be6\u60c5")
    public ResponseResult<ConfigurationMetadataVo> get(@PathVariable(value="id") Long id) {
        this.logger.debug("call ConfigurationMetadataController.get");
        return ResponseResult.successResult((Object)this.configurationApi.getConfigurationMetadata(id));
    }

    @GetMapping(value={"/getByKey/{key}"})
    @Operation(summary="\u914d\u7f6e\u9879\u5143\u6570\u636e\u8be6\u60c5")
    public ResponseResult<ConfigurationMetadataVo> getByKey(@PathVariable(value="key") String key) {
        this.logger.debug("call ConfigurationMetadataController.getByKey");
        return ResponseResult.successResult((Object)this.configurationApi.getConfigurationMetadataByKey(key));
    }

    @GetMapping(value={"/listConfigurationValueType"})
    @Operation(summary="\u83b7\u53d6\u914d\u7f6e\u503c\u7c7b\u578b\u5217\u8868")
    public ResponseResult<List<ConfigurationValueType>> listConfigurationValueType() {
        this.logger.debug("call ConfigurationMetadataController.listConfigurationValueType");
        return ResponseResult.successResult(this.configurationApi.listConfigurationValueType());
    }

    @PostMapping(value={"/import"})
    @Operation(summary="\u914d\u7f6e\u9879\u6ce8\u518c\u5bfc\u5165")
    public ResponseResult<List<ImportResult>> importEntity(@RequestParam(value="file") MultipartFile file) throws Exception {
        List<ImportResult> importResultList = this.configurationImportApplicationService.importConfiguration(file.getInputStream());
        return ResponseResult.successResult(importResultList);
    }
}

