/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.domain.entity;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueType;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationModifyDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationFullVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationItemVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataTreeVo;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationMetadata;
import com.cyberway.mp.bbc.configuration.domain.repository.ConfigurationRepository;
import com.cyberway.mp.bbc.configuration.domain.repository.query.ConfigurationQueryBean;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntityWithAppInstance;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

@Table(name="bd_configuration")
@LogicDelete
public class Configuration
extends BusinessEntityWithAppInstance {
    private Long levelId;
    private LevelType levelType;
    private String name;
    private String configurationKey;
    private ConfigurationValueType valueType;
    private String configurationValue;
    private String description;
    private Long functionGroupId;
    private String functionGroupCode;
    private Long sourceId;
    private String sourceType;
    private Boolean enableModify;
    private Long groupId;
    private Boolean desensitizeFlag = false;
    private LevelType minLevelType = LevelType.INSTANCE;

    public Configuration(ConfigurationMetadata metadata) {
        this.setDesensitizeFlag(metadata.getDesensitizeFlag());
        this.setMinLevelType(metadata.getMinLevelType());
        this.setFunctionGroupId(metadata.getFunctionGroupId());
        this.setFunctionGroupCode(metadata.getFunctionGroupCode());
        this.setLevelType(LevelType.GLOBAL);
        this.setName(metadata.getName());
        this.setConfigurationKey(metadata.getConfigurationKey());
        this.setValueType(metadata.getValueType());
        this.setConfigurationValue(metadata.getDefaultValue());
        this.setDescription(metadata.getDescription());
        this.setGroupId(metadata.getGroupId());
        this.setLevelId(0L);
    }

    public static Configuration fromConfigurationExportData(ConfigurationExportData configurationExportData) {
        Configuration configuration = new Configuration();
        configuration.setEnableModify(configurationExportData.getEnableModify());
        configuration.setLevelId(configurationExportData.getLevelId());
        configuration.setGroupId(configurationExportData.getConfigurationGroupId());
        configuration.setFunctionGroupId(configurationExportData.getFunctionGroupId());
        configuration.setFunctionGroupCode(configurationExportData.getFunctionGroupName());
        configuration.setLevelType(LevelType.forType(configurationExportData.getLevelType()));
        configuration.setName(configurationExportData.getConfigurationName());
        configuration.setConfigurationKey(configurationExportData.getConfigurationKey());
        configuration.setValueType(ConfigurationValueType.forName(configurationExportData.getValueType()));
        configuration.setConfigurationValue(configurationExportData.getConfigurationValue());
        configuration.setDescription(configurationExportData.getDescription());
        configuration.setSourceId(0L);
        configuration.setSourceType("");
        configuration.setBusinessZoneId(configurationExportData.getBusinessZoneId());
        configuration.setAppInstanceId(configurationExportData.getAppInstanceId());
        configuration.setTenantId(configurationExportData.getTenantId());
        configuration.setId(configurationExportData.getConfigurationId());
        configuration.setDesensitizeFlag(configurationExportData.getDesensitizeFlag());
        configuration.setMinLevelType(LevelType.valueOf(configurationExportData.getMinLevelType()));
        return configuration;
    }

    public LevelType getMinLevelType() {
        return this.minLevelType;
    }

    public void setMinLevelType(LevelType minLevelType) {
        this.minLevelType = minLevelType;
    }

    public Boolean getDesensitizeFlag() {
        return this.desensitizeFlag;
    }

    public void setDesensitizeFlag(Boolean desensitizeFlag) {
        this.desensitizeFlag = desensitizeFlag;
    }

    public Boolean getEnableModify() {
        return this.enableModify;
    }

    public void setEnableModify(Boolean enableModify) {
        this.enableModify = enableModify;
    }

    public Long getLevelId() {
        return this.levelId;
    }

    public void setLevelId(Long levelId) {
        this.levelId = levelId;
    }

    public Long getFunctionGroupId() {
        return this.functionGroupId;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public void setFunctionGroupId(Long functionGroupId) {
        this.functionGroupId = functionGroupId;
    }

    public String getFunctionGroupCode() {
        return this.functionGroupCode;
    }

    public void setFunctionGroupCode(String functionGroupCode) {
        this.functionGroupCode = functionGroupCode;
    }

    public LevelType getLevelType() {
        return this.levelType;
    }

    public void setLevelType(LevelType levelType) {
        this.levelType = levelType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfigurationKey() {
        return this.configurationKey;
    }

    public void setConfigurationKey(String configurationKey) {
        this.configurationKey = configurationKey;
    }

    public ConfigurationValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ConfigurationValueType valueType) {
        this.valueType = valueType;
    }

    public String getConfigurationValue() {
        return this.configurationValue;
    }

    public void setConfigurationValue(String configurationValue) {
        this.configurationValue = configurationValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public Configuration() {
    }

    public void modify(ConfigurationModifyDto configurationModifyDto, ConfigurationRepository configurationRepository) {
        this.validateEnableModify(configurationModifyDto, configurationRepository);
        this.setConfigurationValue(configurationModifyDto.getConfigurationValue());
        this.setEnableModify(configurationModifyDto.getEnableModify());
    }

    private void validateEnableModify(ConfigurationModifyDto configurationModifyDto, ConfigurationRepository configurationRepository) {
        if (LevelType.INSTANCE != configurationModifyDto.getLevelType() && Boolean.TRUE.equals(this.getEnableModify()) && Boolean.FALSE.equals(configurationModifyDto.getEnableModify())) {
            long count;
            ConfigurationQueryBean queryBean = new ConfigurationQueryBean();
            queryBean.setFunctionGroupCode(this.getFunctionGroupCode());
            queryBean.setConfigurationKey(this.getConfigurationKey());
            switch (configurationModifyDto.getLevelType()) {
                case GLOBAL: {
                    queryBean.setLevelType(Arrays.asList(LevelType.TENANT, LevelType.ZONE, LevelType.INSTANCE));
                    break;
                }
                case TENANT: {
                    queryBean.setTenantId(configurationModifyDto.getTenantId());
                    queryBean.setLevelType(Arrays.asList(LevelType.ZONE, LevelType.INSTANCE));
                    break;
                }
                case ZONE: {
                    queryBean.setBusinessZoneId(configurationModifyDto.getBusinessZoneId());
                    queryBean.setLevelType(Arrays.asList(LevelType.ZONE, LevelType.INSTANCE));
                    break;
                }
                default: {
                    queryBean = null;
                }
            }
            if (null != queryBean && (count = configurationRepository.countByQueryBean(queryBean)) > 0L) {
                throw new BaseException((ErrorCode)ConfigurationApiResultCode.NOT_ALLOW_MODIFY_ERROR, new Object[]{this.getConfigurationKey()});
            }
        }
    }

    public Configuration initFromModifyDto(ConfigurationModifyDto configurationModifyDto, ConfigurationRepository configurationRepository) {
        Configuration configuration = new Configuration();
        configuration.setFunctionGroupId(this.getFunctionGroupId());
        configuration.setFunctionGroupCode(this.getFunctionGroupCode());
        configuration.setName(this.getName());
        configuration.setConfigurationKey(this.getConfigurationKey());
        configuration.setValueType(this.getValueType());
        configuration.setDescription(this.getDescription());
        configuration.setSourceId(this.getSourceId());
        configuration.setSourceType(this.getSourceType());
        configuration.setGroupId(this.getGroupId());
        configuration.setConfigurationValue(configurationModifyDto.getConfigurationValue());
        configuration.setLevelType(configurationModifyDto.getLevelType());
        configuration.setEnableModify(configurationModifyDto.getEnableModify());
        configuration.setAppInstanceId(configurationModifyDto.getAppInstanceId());
        configuration.setBusinessZoneId(configurationModifyDto.getBusinessZoneId());
        configuration.setTenantId(configurationModifyDto.getTenantId());
        configuration.setLevelId(configurationModifyDto.getLevelId());
        this.validateEnableModify(configurationModifyDto, configurationRepository);
        configuration.setDesensitizeFlag(this.getDesensitizeFlag());
        configuration.setMinLevelType(this.getMinLevelType());
        return configuration;
    }

    public static List<ConfigurationFullVo> buildFullVoList(String relateConfigurationItemValue, List<ConfigurationMetadataTreeVo> metadataTreeList, Map<String, Configuration> configurationMap, Boolean desensitizeFlag) {
        if (null == metadataTreeList) {
            return Collections.emptyList();
        }
        return metadataTreeList.stream().filter(treeVo -> {
            if (StringUtils.isNotBlank((CharSequence)relateConfigurationItemValue)) {
                return relateConfigurationItemValue.equals(treeVo.getRelateConfigurationItemValue());
            }
            return true;
        }).map(treeVo -> {
            Configuration root = (Configuration)((Object)((Object)configurationMap.get(treeVo.getConfigurationKey())));
            if (Boolean.TRUE.equals(root.getDesensitizeFlag()) && Boolean.TRUE.equals(desensitizeFlag)) {
                root.setConfigurationValue("");
            }
            return root.toFullVo((ConfigurationMetadataTreeVo)treeVo, configurationMap, desensitizeFlag);
        }).collect(Collectors.toList());
    }

    public ConfigurationFullVo toFullVo(ConfigurationMetadataTreeVo metadataTreeVo, Map<String, Configuration> configurationMap, Boolean desensitizeFlag) {
        if (null == metadataTreeVo) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"metadataTreeVo"});
        }
        ConfigurationFullVo configurationFullVo = new ConfigurationFullVo();
        configurationFullVo.setId((Long)this.getId());
        configurationFullVo.setEnableModify(this.getEnableModify());
        configurationFullVo.setLevelType(this.getLevelType());
        configurationFullVo.setName(this.getName());
        configurationFullVo.setConfigurationKey(this.getConfigurationKey());
        configurationFullVo.setValueType(this.getValueType());
        configurationFullVo.setConfigurationValue(this.getConfigurationValue());
        configurationFullVo.setDescription(this.getDescription());
        configurationFullVo.setConfigurationValueInsertType(metadataTreeVo.getConfigurationValueInsertType());
        configurationFullVo.setDefaultValue(metadataTreeVo.getDefaultValue());
        configurationFullVo.setDesensitizeFlag(this.getDesensitizeFlag());
        configurationFullVo.setMinLevelType(this.getMinLevelType());
        configurationFullVo.setConfigurationItemList(this.buildItem(metadataTreeVo, configurationMap, desensitizeFlag));
        return configurationFullVo;
    }

    private List<ConfigurationItemVo> buildItem(ConfigurationMetadataTreeVo metadataTreeVo, Map<String, Configuration> configurationMap, Boolean desensitizeFlag) {
        if (null == metadataTreeVo.getConfigurationItemList()) {
            return Collections.emptyList();
        }
        return metadataTreeVo.getConfigurationItemList().stream().map(item -> {
            ConfigurationItemVo itemVo = new ConfigurationItemVo();
            BeanUtils.copyProperties((Object)item, (Object)itemVo);
            itemVo.setRelateConfigurationList(Configuration.buildFullVoList(item.getValue(), metadataTreeVo.getChildren(), configurationMap, desensitizeFlag));
            return itemVo;
        }).collect(Collectors.toList());
    }

    public Object getObjectVal() {
        switch (this.getValueType()) {
            case INT: {
                return Integer.parseInt(this.getConfigurationValue());
            }
            case BOOL: {
                return Boolean.valueOf(this.getConfigurationValue());
            }
            case DOUBLE: {
                return Double.parseDouble(this.getConfigurationValue());
            }
        }
        return this.getConfigurationValue();
    }

    public void modifyByByConfigurationExportData(ConfigurationExportData configurationExportData, boolean needUpdateValue) {
        this.setEnableModify(configurationExportData.getEnableModify());
        this.setLevelId(configurationExportData.getLevelId());
        this.setGroupId(configurationExportData.getConfigurationGroupId());
        this.setFunctionGroupId(configurationExportData.getFunctionGroupId());
        this.setFunctionGroupCode(configurationExportData.getFunctionGroupName());
        this.setLevelType(LevelType.forType(configurationExportData.getLevelType()));
        this.setName(configurationExportData.getConfigurationName());
        this.setConfigurationKey(configurationExportData.getConfigurationKey());
        this.setValueType(ConfigurationValueType.forName(configurationExportData.getValueType()));
        if (needUpdateValue) {
            this.setConfigurationValue(configurationExportData.getConfigurationValue());
        }
        this.setDescription(configurationExportData.getDescription());
        this.setBusinessZoneId(configurationExportData.getBusinessZoneId());
        this.setAppInstanceId(configurationExportData.getAppInstanceId());
        this.setTenantId(configurationExportData.getTenantId());
        this.setDesensitizeFlag(configurationExportData.getDesensitizeFlag());
        this.setMinLevelType(LevelType.valueOf(configurationExportData.getMinLevelType()));
    }
}

