/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.domain.entity;

import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupCreateDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupModifyDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationGroupVo;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.model.BusinessEntity;

@Table(name="bd_configuration_group")
public class ConfigurationGroup
extends BusinessEntity {
    private String name;
    private Boolean systemFlag;
    private Long functionId;
    private Integer orderNum;

    public ConfigurationGroup() {
    }

    public ConfigurationGroup(ConfigurationGroupCreateDto createDto) {
        this.functionId = createDto.getFunctionId();
        this.name = createDto.getName();
        this.orderNum = createDto.getOrderNum();
        this.systemFlag = false;
    }

    public static ConfigurationGroup fromConfigurationExportData(ConfigurationExportData configurationExportData) {
        ConfigurationGroup configurationGroup = new ConfigurationGroup();
        configurationGroup.setName(configurationExportData.getConfigurationName());
        configurationGroup.setSystemFlag(false);
        configurationGroup.setFunctionId(configurationExportData.getFunctionGroupId());
        configurationGroup.setOrderNum(configurationExportData.getConfigurationGroupOrderNum());
        configurationGroup.setId(configurationExportData.getConfigurationGroupId());
        return configurationGroup;
    }

    public ConfigurationGroupVo toVo() {
        ConfigurationGroupVo configurationGroupVo = new ConfigurationGroupVo();
        configurationGroupVo.setId((Long)this.getId());
        configurationGroupVo.setName(this.getName());
        configurationGroupVo.setSystemFlag(this.getSystemFlag());
        configurationGroupVo.setFunctionId(this.getFunctionId());
        configurationGroupVo.setOrderNum(this.getOrderNum());
        return configurationGroupVo;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Boolean getSystemFlag() {
        return this.systemFlag;
    }

    public void setSystemFlag(Boolean systemFlag) {
        this.systemFlag = systemFlag;
    }

    public Long getFunctionId() {
        return this.functionId;
    }

    public void setFunctionId(Long functionId) {
        this.functionId = functionId;
    }

    public Integer getOrderNum() {
        return this.orderNum;
    }

    public void setOrderNum(Integer orderNum) {
        this.orderNum = orderNum;
    }

    public void modify(ConfigurationGroupModifyDto modifyDto) {
        this.setName(modifyDto.getName());
    }

    public void modifyByConfigurationExportData(ConfigurationExportData configurationExportData) {
        this.setFunctionId(configurationExportData.getFunctionGroupId());
        this.setName(configurationExportData.getConfigurationGroupName());
        this.setOrderNum(configurationExportData.getConfigurationGroupOrderNum());
    }
}

