/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.domain.entity;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.ConfigurationItem;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueInsertType;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueType;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationRegisterDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataVo;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.common.utils.JsonUtils;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.annotation.query.IgnoreField;
import com.cyberway.mp.bc.dal.model.BusinessEntity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Table(name="bd_configuration_metadata")
public class ConfigurationMetadata
extends BusinessEntity {
    private String name;
    private String configurationKey;
    private ConfigurationValueType valueType;
    private Long functionGroupId;
    private String functionGroupCode;
    private String defaultValue;
    private String configurationItems;
    private ConfigurationValueInsertType configurationValueInsertType;
    private String description;
    private String spiType;
    private Long groupId;
    private Long parentId;
    private String allParentId;
    private String relateConfigurationItemValue;
    @IgnoreField
    private List<ConfigurationItem> configurationItemList;
    private Boolean desensitizeFlag = false;
    private LevelType minLevelType = LevelType.INSTANCE;

    public ConfigurationMetadata() {
    }

    public ConfigurationMetadata(ConfigurationRegisterDto registerDto) {
        this.setDesensitizeFlag(registerDto.getDesensitizeFlag());
        this.setName(registerDto.getName());
        this.setConfigurationKey(registerDto.getConfigurationKey());
        this.setValueType(registerDto.getValueType());
        this.setDescription(registerDto.getDescription());
        this.setFunctionGroupId(registerDto.getFunctionGroupId());
        this.setFunctionGroupCode(registerDto.getFunctionGroupCode());
        this.setDefaultValue(registerDto.getDefaultValue());
        this.setConfigurationItemList(registerDto.getConfigurationItemList());
        this.setConfigurationValueInsertType(registerDto.getConfigurationValueInsertType());
        this.setGroupId(registerDto.getGroupId());
        this.setMinLevelType(registerDto.getMinLevelType() != null ? registerDto.getMinLevelType() : LevelType.INSTANCE);
        if (this.groupId == null) {
            this.setGroupId(0L);
        }
        this.setParentId(0L);
        this.setAllParentId("|");
        this.validateConfigurationItems();
    }

    public static ConfigurationMetadata fromConfigurationExportData(ConfigurationMetadata parentMeta, ConfigurationExportData exportData) {
        ConfigurationMetadata configurationMetadata = new ConfigurationMetadata();
        configurationMetadata.updateParentMsg(parentMeta, exportData.getRelateConfigurationItemValue());
        configurationMetadata.setSpiType(exportData.getSpiType());
        configurationMetadata.setGroupId(exportData.getConfigurationGroupId());
        configurationMetadata.setFunctionGroupCode(exportData.getFunctionGroupName());
        configurationMetadata.setName(exportData.getConfigurationName());
        configurationMetadata.setConfigurationKey(exportData.getConfigurationKey());
        configurationMetadata.setValueType(ConfigurationValueType.forName(exportData.getValueType()));
        configurationMetadata.setDescription(exportData.getDescription());
        configurationMetadata.setFunctionGroupId(exportData.getFunctionGroupId());
        configurationMetadata.setDefaultValue(exportData.getDefaultValue());
        configurationMetadata.setConfigurationItems(exportData.getConfigurationItems());
        configurationMetadata.setConfigurationItems(exportData.getConfigurationItems());
        configurationMetadata.setConfigurationValueInsertType(ConfigurationValueInsertType.forName(exportData.getInsertType()));
        configurationMetadata.setId(exportData.getConfigurationMetadataId());
        configurationMetadata.setDesensitizeFlag(exportData.getDesensitizeFlag());
        configurationMetadata.setMinLevelType(LevelType.valueOf(exportData.getMinLevelType()));
        return configurationMetadata;
    }

    private void validateConfigurationItems() {
        if (this.configurationValueInsertType == ConfigurationValueInsertType.RADIO || this.configurationValueInsertType == ConfigurationValueInsertType.SELECT) {
            if (CollectionUtils.isEmpty(this.configurationItemList)) {
                throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"configurationItemList"});
            }
            this.configurationItemList.forEach(item -> {
                if (!StringUtils.hasLength((String)item.getDisplayName())) {
                    throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"configurationItem.displayName"});
                }
                if (!StringUtils.hasLength((String)item.getValue())) {
                    throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"configurationItem.value"});
                }
            });
        }
    }

    public LevelType getMinLevelType() {
        return this.minLevelType;
    }

    public void setMinLevelType(LevelType minLevelType) {
        this.minLevelType = minLevelType;
    }

    public Boolean getDesensitizeFlag() {
        return this.desensitizeFlag;
    }

    public void setDesensitizeFlag(Boolean desensitizeFlag) {
        this.desensitizeFlag = desensitizeFlag;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getAllParentId() {
        return this.allParentId;
    }

    public void setAllParentId(String allParentId) {
        this.allParentId = allParentId;
    }

    public String getRelateConfigurationItemValue() {
        return this.relateConfigurationItemValue;
    }

    public void setRelateConfigurationItemValue(String relateConfigurationItemValue) {
        this.relateConfigurationItemValue = relateConfigurationItemValue;
    }

    public String getSpiType() {
        return this.spiType;
    }

    public void setSpiType(String spiType) {
        this.spiType = spiType;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public String getFunctionGroupCode() {
        return this.functionGroupCode;
    }

    public void setFunctionGroupCode(String functionGroupCode) {
        this.functionGroupCode = functionGroupCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfigurationKey() {
        return this.configurationKey;
    }

    public void setConfigurationKey(String configurationKey) {
        this.configurationKey = configurationKey;
    }

    public ConfigurationValueType getValueType() {
        return this.valueType;
    }

    public void setValueType(ConfigurationValueType valueType) {
        this.valueType = valueType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getFunctionGroupId() {
        return this.functionGroupId;
    }

    public void setFunctionGroupId(Long functionGroupId) {
        this.functionGroupId = functionGroupId;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getConfigurationItems() {
        return this.configurationItems;
    }

    public void setConfigurationItems(String configurationItems) {
        this.configurationItems = configurationItems;
        this.configurationItemList = StringUtils.hasLength((String)configurationItems) ? JsonUtils.toListObject((String)configurationItems, ConfigurationItem.class) : null;
    }

    public List<ConfigurationItem> getConfigurationItemList() {
        return this.configurationItemList;
    }

    public void setConfigurationItemList(List<ConfigurationItem> configurationItemList) {
        if (!CollectionUtils.isEmpty(this.configurationItemList) && ConfigurationValueType.SPI != this.getValueType()) {
            this.configurationItemList.forEach(item -> {
                ConfigurationItem inputConfigurationItem = configurationItemList.stream().filter(inputItem -> item.getValue().equals(inputItem.getValue())).findFirst().orElse(null);
                if (null == inputConfigurationItem) {
                    throw new BaseException((ErrorCode)ConfigurationApiResultCode.CONFIG_ITEM_NOT_ALLOW_MODIFY, new Object[]{item.getValue()});
                }
            });
        }
        if (!CollectionUtils.isEmpty(configurationItemList)) {
            Map<String, List<ConfigurationItem>> groupMap = configurationItemList.stream().collect(Collectors.groupingBy(ConfigurationItem::getValue));
            groupMap.forEach((value, list) -> {
                if (list.size() > 1) {
                    throw new BaseException((ErrorCode)ConfigurationApiResultCode.CONFIG_ITEM_REPEAT, new Object[]{value});
                }
            });
        }
        this.configurationItemList = configurationItemList;
        this.configurationItems = CollectionUtils.isEmpty(configurationItemList) ? null : JsonUtils.toJson(configurationItemList);
    }

    public ConfigurationValueInsertType getConfigurationValueInsertType() {
        return this.configurationValueInsertType;
    }

    public void setConfigurationValueInsertType(ConfigurationValueInsertType configurationValueInsertType) {
        this.configurationValueInsertType = configurationValueInsertType;
    }

    public ConfigurationMetadataVo toVo() {
        ConfigurationMetadataVo configurationMetadataVo = new ConfigurationMetadataVo();
        configurationMetadataVo.setId((Long)this.getId());
        configurationMetadataVo.setName(this.name);
        configurationMetadataVo.setConfigurationKey(this.getConfigurationKey());
        configurationMetadataVo.setValueType(this.valueType);
        configurationMetadataVo.setFunctionGroupId(this.getFunctionGroupId());
        configurationMetadataVo.setFunctionGroupCode(this.functionGroupCode);
        configurationMetadataVo.setDefaultValue(this.defaultValue);
        configurationMetadataVo.setConfigurationValueInsertType(this.configurationValueInsertType);
        configurationMetadataVo.setDescription(this.description);
        configurationMetadataVo.setConfigurationItemList(this.configurationItemList);
        configurationMetadataVo.setGroupId(this.groupId);
        configurationMetadataVo.setParentId(this.getParentId());
        configurationMetadataVo.setAllParentId(this.getAllParentId());
        configurationMetadataVo.setRelateConfigurationItemValue(this.getRelateConfigurationItemValue());
        configurationMetadataVo.setDesensitizeFlag(this.desensitizeFlag);
        configurationMetadataVo.setMinLevelType(this.minLevelType);
        return configurationMetadataVo;
    }

    public void updateByMetadataModifyDto(ConfigurationMetadataModifyDto dto) {
        this.setName(dto.getName());
        this.setDescription(dto.getDescription());
        this.setDesensitizeFlag(dto.getDesensitizeFlag());
        this.setConfigurationItemList(dto.getConfigurationItemList());
        if (dto.getMinLevelType() != null) {
            this.setMinLevelType(dto.getMinLevelType());
        }
        this.validateConfigurationItems();
    }

    public void updateParentMsg(ConfigurationMetadata parent, String relateConfigurationItemValue) {
        if (null != parent) {
            this.setParentId((Long)parent.getId());
            this.setAllParentId(parent.getAllParentId() + parent.getId() + "|");
        } else {
            this.setParentId(0L);
            this.setAllParentId("|");
        }
        this.setRelateConfigurationItemValue(relateConfigurationItemValue);
    }

    public void updateTopParentMsg(ConfigurationMetadata parent) {
        String oldAllParent = this.getAllParentId();
        this.setAllParentId(parent.getAllParentId() + oldAllParent.substring(oldAllParent.indexOf(parent.getId() + "|")));
    }

    public void modifyByConfigurationExportData(ConfigurationMetadata parentMeta, ConfigurationExportData exportData) {
        this.updateParentMsg(parentMeta, exportData.getRelateConfigurationItemValue());
        this.setSpiType(exportData.getSpiType());
        this.setGroupId(exportData.getConfigurationGroupId());
        this.setFunctionGroupCode(exportData.getFunctionGroupName());
        this.setName(exportData.getConfigurationName());
        this.setConfigurationKey(exportData.getConfigurationKey());
        this.setValueType(ConfigurationValueType.forName(exportData.getValueType()));
        this.setDescription(exportData.getDescription());
        this.setFunctionGroupId(exportData.getFunctionGroupId());
        this.setDefaultValue(exportData.getDefaultValue());
        this.setConfigurationItems(exportData.getConfigurationItems());
        this.setConfigurationItems(exportData.getConfigurationItems());
        this.setConfigurationValueInsertType(ConfigurationValueInsertType.forName(exportData.getInsertType()));
        this.setDesensitizeFlag(exportData.getDesensitizeFlag());
        this.setMinLevelType(LevelType.valueOf(exportData.getMinLevelType()));
    }
}

