/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.domain.service;

import com.cyberway.mp.bbc.configuration.api.CenterFunctionTree;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationFunction;
import com.cyberway.mp.bbc.configuration.infra.config.FunctionTreeProperties;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.dal.model.Entity;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class ConfigurationFunctionService {
    private final FunctionTreeProperties functionTreeProperties;

    public ConfigurationFunctionService(FunctionTreeProperties functionTreeProperties) {
        functionTreeProperties.validate();
        this.functionTreeProperties = functionTreeProperties;
    }

    public List<CenterFunctionTree> getTree() {
        if (CollectionUtils.isEmpty(this.functionTreeProperties.getNodes())) {
            return Collections.emptyList();
        }
        for (CenterFunctionTree node : this.functionTreeProperties.getNodes()) {
            node.refreshChildrenNodes();
        }
        return this.functionTreeProperties.getNodes();
    }

    public List<ConfigurationFunction> listByCodes(String serviceName, Set<String> codes) {
        if (CollectionUtils.isEmpty(this.functionTreeProperties.getNodes()) || CollectionUtils.isEmpty(codes)) {
            return Collections.emptyList();
        }
        List<ConfigurationFunction> allNodes = this.getAllConfigurationFunctions();
        return allNodes.stream().filter(n -> codes.contains(n.getCode()) && ObjectUtils.nullSafeEquals((Object)n.getServiceName(), (Object)serviceName)).collect(Collectors.toList());
    }

    public List<ConfigurationFunction> listByIds(String serviceName, Set<Long> ids) {
        if (CollectionUtils.isEmpty(this.functionTreeProperties.getNodes()) || CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        List<ConfigurationFunction> allNodes = this.getAllConfigurationFunctions();
        return allNodes.stream().filter(n -> ids.contains(n.getId()) && ObjectUtils.nullSafeEquals((Object)n.getServiceName(), (Object)serviceName)).collect(Collectors.toList());
    }

    private List<ConfigurationFunction> getAllConfigurationFunctions() {
        ArrayList<ConfigurationFunction> allNodes = new ArrayList<ConfigurationFunction>();
        for (CenterFunctionTree node : this.functionTreeProperties.getNodes()) {
            node.refreshChildrenNodes();
            allNodes.addAll(node.toConfigurationFunctionList(null));
        }
        return allNodes;
    }

    public ConfigurationFunction getByCode(String serviceName, String code) {
        if (CollectionUtils.isEmpty(this.functionTreeProperties.getNodes()) || null == code) {
            return null;
        }
        List<ConfigurationFunction> allNodes = this.getAllConfigurationFunctions();
        return allNodes.stream().filter(n -> code.equals(n.getCode()) && (null == serviceName || serviceName.equals(n.getServiceName()))).findFirst().orElse(null);
    }

    public ConfigurationFunction getByCode(String code) {
        return this.getByCode(null, code);
    }

    public void validateFunctionIds(String serviceName, Set<Long> functionIds) {
        Map<Long, ConfigurationFunction> map = this.listByIds(serviceName, functionIds).stream().collect(Collectors.toMap(Entity::getId, c -> c));
        for (Long functionId : functionIds) {
            if (map.containsKey(functionId)) continue;
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.FUNCTION_ID_ERROR, new Object[]{functionId});
        }
    }

    public void validateFunctionCodes(String serviceName, Set<String> functionCodes) {
        Map<String, ConfigurationFunction> map = this.listByCodes(serviceName, functionCodes).stream().collect(Collectors.toMap(ConfigurationFunction::getCode, c -> c));
        for (String code : functionCodes) {
            if (map.containsKey(code)) continue;
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.FUNCTION_CODE_ERROR, new Object[]{code});
        }
    }
}

