/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.domain.service;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupCreateDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationGroupOrderModifyDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationGroupVo;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationGroup;
import com.cyberway.mp.bbc.configuration.domain.repository.ConfigurationGroupRepository;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.dal.model.Entity;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class ConfigurationGroupService {
    private final ConfigurationGroupRepository repository;

    public ConfigurationGroupService(ConfigurationGroupRepository repository) {
        this.repository = repository;
    }

    public List<ConfigurationGroupVo> queryByFunctionIdAndName(Long functionId, String name) {
        if (null == functionId) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"functionId"});
        }
        return this.repository.findByFunctionIdOrSystemFlagOrderByOrderNumAsc(functionId, true).stream().filter(group -> !StringUtils.hasLength((String)name) || group.getName().contains(name)).map(ConfigurationGroup::toVo).collect(Collectors.toList());
    }

    public Long create(ConfigurationGroupCreateDto createDto) {
        ConfigurationGroup group = new ConfigurationGroup(createDto);
        this.repository.save((Object)group);
        return (Long)group.getId();
    }

    public void modify(Long id, ConfigurationGroupModifyDto modifyDto) {
        ConfigurationGroup group = (ConfigurationGroup)((Object)this.repository.findOne(id));
        if (null == group) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{id});
        }
        group.modify(modifyDto);
        this.repository.updateById((Object)group, id);
    }

    public void delete(Long id) {
        ConfigurationGroup group = (ConfigurationGroup)((Object)this.repository.findOne(id));
        if (null == group) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{id});
        }
        if (Boolean.TRUE.equals(group.getSystemFlag())) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.SYSTEM_DATA_DEL_ERROR, new Object[]{id});
        }
        this.repository.delete(id);
    }

    public void modifyOrder(ConfigurationGroupOrderModifyDto orderModifyDto) {
        int counter = 1;
        for (Long id : orderModifyDto.getIds()) {
            if (0L == id) continue;
            this.repository.updateOrderNumById(counter++, id);
        }
    }

    public void importByConfigurationExportData(List<ConfigurationExportData> exportDataList) {
        Map<Long, ConfigurationGroup> allGroupById = this.repository.findAll().stream().collect(Collectors.toMap(Entity::getId, group -> group));
        for (ConfigurationExportData configurationExportData : exportDataList) {
            ConfigurationGroup configurationGroup = allGroupById.get(configurationExportData.getConfigurationGroupId());
            if (null != configurationGroup) {
                configurationGroup.modifyByConfigurationExportData(configurationExportData);
                this.repository.updateById((Object)configurationGroup, (Long)configurationGroup.getId());
                continue;
            }
            configurationGroup = ConfigurationGroup.fromConfigurationExportData(configurationExportData);
            this.repository.save((Object)configurationGroup);
            allGroupById.put((Long)configurationGroup.getId(), configurationGroup);
        }
    }
}

