/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.domain.service;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.ConfigurationItem;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueInsertType;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationMetadataQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationRegisterDto;
import com.cyberway.mp.bbc.configuration.api.dto.SpiRegisterDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataMinVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataTreeVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataVo;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationFunction;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationMetadata;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationMetadataDiff;
import com.cyberway.mp.bbc.configuration.domain.repository.ConfigurationMetadataRepository;
import com.cyberway.mp.bbc.configuration.domain.repository.query.ConfigurationMetadataQueryBean;
import com.cyberway.mp.bbc.configuration.infra.util.PageUtils;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.exception.AssertUtil;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;

public class ConfigurationMetadataService {
    private final ConfigurationMetadataRepository repository;

    public ConfigurationMetadataService(ConfigurationMetadataRepository repository) {
        this.repository = repository;
    }

    public ConfigurationMetadata register(ConfigurationRegisterDto registerDto) {
        ConfigurationMetadata configurationMetadata = new ConfigurationMetadata(registerDto);
        if (configurationMetadata.getValueType().equals((Object)ConfigurationValueType.SPI)) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.SPI_NOT_ALLOW_CREATE);
        }
        Set<Long> relateMetadataIds = this.getAndCheckRepeatRelateConfigurationMetadata(registerDto.getConfigurationItemList());
        List<ConfigurationMetadata> relateMetadataList = this.getAndValidateRelate(configurationMetadata, relateMetadataIds);
        this.insert(configurationMetadata);
        this.buildRelate(configurationMetadata, relateMetadataList);
        return configurationMetadata;
    }

    private void buildRelate(ConfigurationMetadata parentConfigurationMetadata, List<ConfigurationMetadata> needRelateMetadataList) {
        if (null != parentConfigurationMetadata && CollectionUtils.isNotEmpty(needRelateMetadataList)) {
            for (ConfigurationMetadata child : needRelateMetadataList) {
                child.updateParentMsg(parentConfigurationMetadata, this.findBindingItemValue(parentConfigurationMetadata, child));
                this.repository.updateById((Object)child, (Long)child.getId());
                this.updateChildTopParent(child);
            }
        }
    }

    private void updateChildTopParent(ConfigurationMetadata configurationMetadata) {
        List<ConfigurationMetadata> childList = this.repository.findByAllParentIdContains("|" + configurationMetadata.getId() + "|");
        for (ConfigurationMetadata child : childList) {
            child.updateTopParentMsg(configurationMetadata);
            this.repository.updateById((Object)child, (Long)child.getId());
        }
    }

    private String findBindingItemValue(ConfigurationMetadata parentConfigurationMetadata, ConfigurationMetadata child) {
        if (CollectionUtils.isNotEmpty(parentConfigurationMetadata.getConfigurationItemList())) {
            for (ConfigurationItem configurationItem : parentConfigurationMetadata.getConfigurationItemList()) {
                if (!CollectionUtils.isNotEmpty(configurationItem.getRelateConfigurationMetadataList())) continue;
                for (ConfigurationMetadataMinVo configurationMetadataMinVo : configurationItem.getRelateConfigurationMetadataList()) {
                    if (!configurationMetadataMinVo.getId().equals(child.getId())) continue;
                    return configurationItem.getValue();
                }
            }
        }
        return null;
    }

    private Set<Long> getAndCheckRepeatRelateConfigurationMetadata(List<ConfigurationItem> configurationItemList) {
        if (CollectionUtils.isNotEmpty(configurationItemList)) {
            HashSet<Long> relateIds = new HashSet<Long>(16);
            for (ConfigurationItem configurationItem : configurationItemList) {
                if (!CollectionUtils.isNotEmpty(configurationItem.getRelateConfigurationMetadataList())) continue;
                for (ConfigurationMetadataMinVo configurationMetadataMinVo : configurationItem.getRelateConfigurationMetadataList()) {
                    if (relateIds.contains(configurationMetadataMinVo.getId())) {
                        throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.CONFIG_ALREADY_RELATE_OTHER, new Object[]{configurationMetadataMinVo.getConfigurationKey()});
                    }
                    relateIds.add(configurationMetadataMinVo.getId());
                }
            }
            return relateIds;
        }
        return Collections.emptySet();
    }

    private List<ConfigurationMetadata> getAndValidateRelate(ConfigurationMetadata parentConfigurationMetadata, Set<Long> relateMetadataIds) {
        if (CollectionUtils.isEmpty(relateMetadataIds)) {
            return Collections.emptyList();
        }
        List<ConfigurationMetadata> relateConfigurationMetadataList = this.repository.findByIdIn(relateMetadataIds);
        if (relateConfigurationMetadataList.size() != relateMetadataIds.size()) {
            throw new IllegalArgumentException("\u4e0d\u5408\u6cd5\u7684\u7ed1\u5b9a\u5165\u53c2");
        }
        for (ConfigurationMetadata relateMetadata : relateConfigurationMetadataList) {
            if (!relateMetadata.getFunctionGroupId().equals(parentConfigurationMetadata.getFunctionGroupId())) {
                throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.RELATE_ERROR, new Object[]{"\u5173\u8054\u7684\u5b50\u914d\u7f6e\u4e0e\u5f53\u524d\u914d\u7f6e\u4e0d\u5c5e\u4e8e\u540c\u529f\u80fd\u5206\u7c7b"});
            }
            if (StringUtils.isNotBlank((CharSequence)parentConfigurationMetadata.getAllParentId()) && parentConfigurationMetadata.getAllParentId().contains(String.valueOf(relateMetadata.getId()))) {
                throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.RELATE_ERROR, new Object[]{"\u4e0d\u5141\u8bb8\u5faa\u73af\u7ed1\u5b9a"});
            }
            if (relateMetadata.getMinLevelType() == parentConfigurationMetadata.getMinLevelType()) continue;
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.RELATE_ERROR, new Object[]{"\u5173\u8054\u7684\u5b50\u914d\u7f6e\u4e0e\u5f53\u524d\u914d\u7f6e\u7684\u6700\u4f4e\u5c42\u7ea7\u4e0d\u4e00\u81f4"});
        }
        return relateConfigurationMetadataList;
    }

    private void insert(ConfigurationMetadata configurationMetadata) {
        int count = this.repository.countByFunctionGroupIdAndConfigurationKey(configurationMetadata.getFunctionGroupId(), configurationMetadata.getConfigurationKey());
        if (count > 0) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.CONFIG_KEY_REPEAT, new Object[]{configurationMetadata.getConfigurationKey()});
        }
        this.repository.save((Object)configurationMetadata);
    }

    public List<ConfigurationMetadataVo> search(ConfigurationMetadataQueryDto queryDto) {
        ConfigurationMetadataQueryBean queryBean = new ConfigurationMetadataQueryBean(queryDto);
        List<ConfigurationMetadata> list = this.repository.search(queryBean);
        return list.stream().map(ConfigurationMetadata::toVo).collect(Collectors.toList());
    }

    public Page<ConfigurationMetadataVo> page(ConfigurationMetadataQueryDto queryDto) {
        ConfigurationMetadataQueryBean queryBean = new ConfigurationMetadataQueryBean(queryDto);
        List<ConfigurationMetadata> list = this.repository.searchPage(queryBean, queryDto);
        List voList = list.stream().map(ConfigurationMetadata::toVo).collect(Collectors.toList());
        long total = this.repository.countByQueryBean(queryBean);
        return PageUtils.buildPageResult(voList, queryDto, total);
    }

    public ConfigurationMetadata modify(Long id, ConfigurationMetadataModifyDto dto) {
        ConfigurationMetadata parent;
        ConfigurationMetadata metadata = (ConfigurationMetadata)((Object)this.repository.findOne(id));
        if (null == metadata) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{id});
        }
        Long parentId = metadata.getParentId();
        if (null != parentId && 0L != parentId && dto.getMinLevelType() != null && null != (parent = (ConfigurationMetadata)((Object)this.repository.findOne(parentId))) && !parent.getMinLevelType().equals((Object)dto.getMinLevelType())) {
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.RELATE_ERROR, new Object[]{"\u5173\u8054\u7684\u7236\u914d\u7f6e\u4e0e\u5f53\u524d\u914d\u7f6e\u7684\u6700\u4f4e\u5c42\u7ea7\u4e0d\u4e00\u81f4"});
        }
        metadata.updateByMetadataModifyDto(dto);
        this.repository.updateById((Object)metadata, id);
        this.dropCurrentRelate(metadata);
        Set<Long> relateMetadataIds = this.getAndCheckRepeatRelateConfigurationMetadata(dto.getConfigurationItemList());
        List<ConfigurationMetadata> relateMetadataList = this.getAndValidateRelate(metadata, relateMetadataIds);
        this.buildRelate(metadata, relateMetadataList);
        return metadata;
    }

    private void dropCurrentRelate(ConfigurationMetadata metadata) {
        if (null == metadata || null == metadata.getId()) {
            return;
        }
        List<ConfigurationMetadata> allChildList = this.repository.findByAllParentIdContains("|" + metadata.getId() + "|");
        List<ConfigurationMetadata> firstRelateList = allChildList.stream().filter(c -> ((Long)metadata.getId()).equals(c.getParentId())).collect(Collectors.toList());
        firstRelateList.forEach(firstRelate -> {
            firstRelate.updateParentMsg(null, "");
            allChildList.stream().filter(c -> c.getAllParentId().contains(String.valueOf(firstRelate.getId()))).forEach(c -> c.updateTopParentMsg((ConfigurationMetadata)((Object)firstRelate)));
        });
        allChildList.forEach(c -> this.repository.updateById(c, (Long)c.getId()));
    }

    public ConfigurationMetadataVo get(Long id) {
        ConfigurationMetadata metadata = (ConfigurationMetadata)((Object)this.repository.findOne(id));
        if (null == metadata) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{id});
        }
        return metadata.toVo();
    }

    public ConfigurationMetadataVo getByKey(String key) {
        ConfigurationMetadata metadata = this.repository.findByConfigurationKey(key);
        if (null == metadata) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{key});
        }
        return metadata.toVo();
    }

    public List<ConfigurationMetadataVo> searchByConfigurationQueryDto(ConfigurationQueryDto queryDto) {
        ConfigurationMetadataQueryDto metadataQueryDto = new ConfigurationMetadataQueryDto();
        metadataQueryDto.setFunctionGroupCode(queryDto.getFunctionGroupCode());
        metadataQueryDto.setFunctionGroupId(queryDto.getFunctionGroupId());
        metadataQueryDto.setGroupId(queryDto.getGroupId());
        return this.search(metadataQueryDto);
    }

    public void validateSpiRegisterDto(List<ConfigurationFunction> functionList, List<SpiRegisterDto> registerDtoList) {
        if (CollectionUtils.isEmpty(registerDtoList)) {
            return;
        }
        Map<String, ConfigurationFunction> functionMap = functionList.stream().collect(Collectors.toMap(ConfigurationFunction::getCode, f -> f));
        HashSet<Long> functionIds = new HashSet<Long>();
        HashSet<String> configKeys = new HashSet<String>();
        registerDtoList.forEach(dto -> {
            if (!functionMap.containsKey(dto.getFunctionGroupCode())) {
                throw new BaseException((ErrorCode)ConfigurationApiResultCode.FUNCTION_CODE_ERROR, new Object[]{dto.getFunctionGroupCode()});
            }
            long functionGroupId = (Long)((ConfigurationFunction)((Object)((Object)functionMap.get(dto.getFunctionGroupCode())))).getId();
            dto.setFunctionGroupId(functionGroupId);
            functionIds.add(functionGroupId);
            configKeys.add(dto.getConfigurationKey());
        });
        ConfigurationMetadataQueryBean queryBean = new ConfigurationMetadataQueryBean();
        queryBean.setFunctionGroupIdIn(functionIds);
        queryBean.setConfigurationKeyIn(configKeys);
        List<ConfigurationMetadata> metadataList = this.repository.search(queryBean);
        Map<String, List<ConfigurationMetadata>> metadataGroupMap = metadataList.stream().collect(Collectors.groupingBy(configurationMetadata -> configurationMetadata.getFunctionGroupCode() + "_" + configurationMetadata.getConfigurationKey()));
        registerDtoList.forEach(dto -> {
            ConfigurationMetadata sameCodeMeta;
            String key = dto.getFunctionGroupCode() + "_" + dto.getConfigurationKey();
            List itemList = (List)metadataGroupMap.get(key);
            if (!CollectionUtils.isEmpty((Collection)itemList) && null != (sameCodeMeta = (ConfigurationMetadata)itemList.stream().filter(meta -> !dto.getSpiType().equals(meta.getSpiType())).findFirst().orElse(null))) {
                throw new BaseException((ErrorCode)ConfigurationApiResultCode.CONFIG_KEY_REPEAT, new Object[]{dto.getConfigurationKey()});
            }
        });
    }

    public ConfigurationMetadataDiff spiRegister(SpiRegisterDto spiRegisterDto) {
        ConfigurationMetadataQueryBean queryBean = new ConfigurationMetadataQueryBean();
        queryBean.setFunctionGroupCode(spiRegisterDto.getFunctionGroupCode());
        queryBean.setConfigurationKey(spiRegisterDto.getConfigurationKey());
        queryBean.setSpiType(spiRegisterDto.getSpiType());
        queryBean.setValueType(ConfigurationValueType.SPI);
        List<ConfigurationMetadata> metadataList = this.repository.search(queryBean);
        ConfigurationMetadataDiff diff = new ConfigurationMetadataDiff();
        if (CollectionUtils.isEmpty(metadataList)) {
            BeanUtils.copyProperties((Object)spiRegisterDto, (Object)diff);
            diff.setCreateFlag(true);
            ConfigurationMetadata metadata = new ConfigurationMetadata();
            BeanUtils.copyProperties((Object)spiRegisterDto, (Object)((Object)metadata));
            metadata.setValueType(ConfigurationValueType.SPI);
            this.repository.save((Object)metadata);
        } else {
            diff.setCreateFlag(false);
            ConfigurationMetadata oldMeta = metadataList.get(0);
            if (ConfigurationValueInsertType.RADIO.equals((Object)spiRegisterDto.getConfigurationValueInsertType()) && ConfigurationValueInsertType.SELECT.equals((Object)oldMeta.getConfigurationValueInsertType())) {
                diff.setMultiToSingle(true);
            }
            diff.setDeleteItem(new ArrayList<ConfigurationItem>());
            if (!CollectionUtils.isEmpty(oldMeta.getConfigurationItemList())) {
                Map<String, ConfigurationItem> oldItem = oldMeta.getConfigurationItemList().stream().collect(Collectors.toMap(ConfigurationItem::getValue, i -> i));
                Map<String, ConfigurationItem> newItem = spiRegisterDto.getConfigurationItemList().stream().collect(Collectors.toMap(ConfigurationItem::getValue, i -> i));
                oldItem.forEach((val, item) -> {
                    if (!newItem.containsKey(val)) {
                        diff.getDeleteItem().add((ConfigurationItem)item);
                    }
                });
            }
            BeanUtils.copyProperties((Object)spiRegisterDto, (Object)((Object)oldMeta));
            BeanUtils.copyProperties((Object)spiRegisterDto, (Object)diff);
            this.repository.updateById((Object)oldMeta, (Long)oldMeta.getId());
        }
        return diff;
    }

    public List<ConfigurationMetadataTreeVo> buildTree(List<ConfigurationMetadataVo> list) {
        if (null == list) {
            return Collections.emptyList();
        }
        return list.stream().filter(c -> c.getParentId().equals(0L)).map(c -> c.buildTree(list)).collect(Collectors.toList());
    }

    public void importByConfigurationExportData(List<ConfigurationExportData> exportDataList) {
        Map<String, ConfigurationMetadata> metadataByKey = this.repository.findAll().stream().collect(Collectors.toMap(ConfigurationMetadata::getConfigurationKey, m -> m));
        Map<String, List<ConfigurationExportData>> exportDataByKey = exportDataList.stream().collect(Collectors.groupingBy(ConfigurationExportData::getConfigurationKey));
        HashMap alreadyHandlerMetadataById = new HashMap(exportDataByKey.size());
        exportDataByKey.forEach((key, subList) -> {
            ConfigurationExportData configurationExportData = (ConfigurationExportData)subList.get(0);
            this.importByConfigurationExportData((String)key, metadataByKey, exportDataList, configurationExportData, alreadyHandlerMetadataById);
        });
    }

    private void importByConfigurationExportData(String configurationKey, Map<String, ConfigurationMetadata> metadataByKey, List<ConfigurationExportData> exportDataList, ConfigurationExportData exportData, Map<Long, ConfigurationMetadata> alreadyHandlerMetadataById) {
        String parentConfigurationKey = "";
        Long parentId = exportData.getParentId();
        if (null != parentId && !parentId.equals(0L)) {
            if (alreadyHandlerMetadataById.containsKey(parentId)) {
                return;
            }
            ConfigurationExportData parentExportData = exportDataList.stream().filter(e -> e.getConfigurationMetadataId().equals(parentId)).findFirst().orElse(null);
            AssertUtil.notNull((Object)parentExportData, (ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, (Object[])new Object[]{parentId});
            parentConfigurationKey = parentExportData.getConfigurationKey();
            this.importByConfigurationExportData(parentExportData.getConfigurationKey(), metadataByKey, exportDataList, parentExportData, alreadyHandlerMetadataById);
        }
        ConfigurationMetadata parentMeta = metadataByKey.get(parentConfigurationKey);
        ConfigurationMetadata configurationMetadata = metadataByKey.get(configurationKey);
        if (null == configurationMetadata) {
            configurationMetadata = ConfigurationMetadata.fromConfigurationExportData(parentMeta, exportData);
            this.repository.save((Object)configurationMetadata);
        } else {
            configurationMetadata.modifyByConfigurationExportData(parentMeta, exportData);
            this.repository.updateById((Object)configurationMetadata, (Long)configurationMetadata.getId());
        }
        metadataByKey.put(configurationMetadata.getConfigurationKey(), configurationMetadata);
        alreadyHandlerMetadataById.put((Long)configurationMetadata.getId(), configurationMetadata);
    }
}

