/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.domain.service;

import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationConstant;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.ConfigurationItem;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueType;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationExportQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationImportParamDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationItemQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationSingleQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.RelateConfigurationModifyDto;
import com.cyberway.mp.bbc.configuration.api.dto.SpiRegisterDto;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationFullVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataTreeVo;
import com.cyberway.mp.bbc.configuration.api.vo.ConfigurationMetadataVo;
import com.cyberway.mp.bbc.configuration.domain.entity.Configuration;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationMetadata;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationMetadataDiff;
import com.cyberway.mp.bbc.configuration.domain.repository.ConfigurationRepository;
import com.cyberway.mp.bbc.configuration.domain.repository.query.ConfigurationQueryBean;
import com.cyberway.mp.bbc.configuration.infra.config.BbcConfigurationProperties;
import com.cyberway.mp.bbc.remotejob.dto.TenantCopyItemDto;
import com.cyberway.mp.bbc.remotejob.dto.TenantCopyJobDto;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class ConfigurationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BbcConfigurationProperties bbcConfigurationProperties;
    private final ConfigurationRepository configurationRepository;
    private static final String TENANT_ID_FIELD_NAME = "tenantId";
    private static final String BUSINESS_ID_FIELD_NAME = "businessZoneId";
    private static final String APP_INSTANCE_ID_FIELD_NAME = "appInstanceId";

    public ConfigurationService(BbcConfigurationProperties bbcConfigurationProperties, ConfigurationRepository configurationRepository) {
        this.bbcConfigurationProperties = bbcConfigurationProperties;
        this.configurationRepository = configurationRepository;
    }

    public void modifyConfiguration(Long id, ConfigurationModifyDto configurationModifyDto) {
        Configuration sourceConfiguration = (Configuration)((Object)this.configurationRepository.findOne(id));
        if (null == sourceConfiguration) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.OBJECT_NOT_FOUND, new Object[]{id});
        }
        this.modifyConfiguration(configurationModifyDto, sourceConfiguration);
    }

    public void batchModifyConfiguration(List<ConfigurationModifyDto> modifyDtoList) {
        ArrayList<ConfigurationModifyDto> allModifyDtoList = new ArrayList<ConfigurationModifyDto>();
        for (ConfigurationModifyDto dto2 : modifyDtoList) {
            allModifyDtoList.add(dto2);
            allModifyDtoList.addAll(this.getAllChild(dto2));
        }
        List<Long> ids = allModifyDtoList.stream().filter(i -> null != i.getConfigurationValue()).map(ConfigurationModifyDto::getId).collect(Collectors.toList());
        Map<Long, ConfigurationModifyDto> dtoMap = allModifyDtoList.stream().filter(i -> null != i.getConfigurationValue()).collect(Collectors.toMap(ConfigurationModifyDto::getId, dto -> dto, (d1, d2) -> d1));
        if (!CollectionUtils.isEmpty(ids)) {
            List<Configuration> configurationList = this.configurationRepository.findByIdIn(ids);
            configurationList.forEach(configuration -> this.modifyConfiguration((ConfigurationModifyDto)dtoMap.get(configuration.getId()), (Configuration)((Object)configuration)));
        }
    }

    private List<ConfigurationModifyDto> getAllChild(ConfigurationModifyDto dto) {
        if (null != dto && CollectionUtils.isNotEmpty(dto.getConfigurationItemList())) {
            ArrayList<ConfigurationModifyDto> list = new ArrayList<ConfigurationModifyDto>();
            for (RelateConfigurationModifyDto relateConfigurationModifyDto : dto.getConfigurationItemList()) {
                if (!CollectionUtils.isNotEmpty(relateConfigurationModifyDto.getRelateConfigurationList())) continue;
                for (ConfigurationModifyDto configurationModifyDto : relateConfigurationModifyDto.getRelateConfigurationList()) {
                    list.add(configurationModifyDto);
                    list.addAll(this.getAllChild(configurationModifyDto));
                }
            }
            return list;
        }
        return Collections.emptyList();
    }

    private void modifyConfiguration(ConfigurationModifyDto configurationModifyDto, Configuration sourceConfiguration) {
        this.validateConfigurationModifyDto(configurationModifyDto);
        if (sourceConfiguration.getLevelType() == configurationModifyDto.getLevelType()) {
            this.modify(configurationModifyDto, sourceConfiguration);
        } else {
            if (Boolean.FALSE.equals(sourceConfiguration.getEnableModify())) {
                throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.LOW_LEVEL_CONFIG_NOT_ALLOW_MODIFY);
            }
            Long levelId = configurationModifyDto.getLevelId();
            Configuration targetConfiguration = this.configurationRepository.findByFunctionGroupCodeAndConfigurationKeyAndLevelTypeAndLevelId(sourceConfiguration.getFunctionGroupCode(), sourceConfiguration.getConfigurationKey(), configurationModifyDto.getLevelType(), levelId);
            if (null != targetConfiguration) {
                this.modify(configurationModifyDto, targetConfiguration);
            } else {
                this.create(configurationModifyDto, sourceConfiguration);
            }
        }
    }

    private void validateConfigurationModifyDto(ConfigurationModifyDto dto) {
        switch (dto.getLevelType()) {
            case TENANT: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                break;
            }
            case ZONE: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                this.validateField(dto.getLevelType(), dto.getBusinessZoneId(), BUSINESS_ID_FIELD_NAME);
                break;
            }
            case INSTANCE: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                this.validateField(dto.getLevelType(), dto.getAppInstanceId(), APP_INSTANCE_ID_FIELD_NAME);
                break;
            }
        }
    }

    private void validateConfigurationDto(ConfigurationDto dto) {
        switch (dto.getLevelType()) {
            case TENANT: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                break;
            }
            case ZONE: {
                throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.NOT_ALLOW_QUERY_LEVEL);
            }
            case INSTANCE: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                this.validateField(dto.getLevelType(), dto.getAppInstanceId(), APP_INSTANCE_ID_FIELD_NAME);
                break;
            }
        }
    }

    public void validateQueryDto(ConfigurationQueryDto dto) {
        if (null == dto.getFunctionGroupId() && StringUtils.isBlank((CharSequence)dto.getFunctionGroupCode())) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.FUNCTION_GROUP_ERROR);
        }
        switch (dto.getLevelType()) {
            case TENANT: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                break;
            }
            case ZONE: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                this.validateField(dto.getLevelType(), dto.getBusinessZoneId(), BUSINESS_ID_FIELD_NAME);
                break;
            }
            case INSTANCE: {
                this.validateField(dto.getLevelType(), dto.getTenantId(), TENANT_ID_FIELD_NAME);
                this.validateField(dto.getLevelType(), dto.getAppInstanceId(), APP_INSTANCE_ID_FIELD_NAME);
                break;
            }
        }
    }

    private void validateField(LevelType levelType, Long fieldValue, String fieldName) {
        if (null == fieldValue) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.LEVEL_EMPTY_VALUE, new Object[]{levelType.getName(), fieldName});
        }
    }

    private void create(ConfigurationModifyDto configurationModifyDto, Configuration configuration) {
        Configuration newConfiguration = configuration.initFromModifyDto(configurationModifyDto, this.configurationRepository);
        this.logger.info("create configuration[{}.{}]", (Object)newConfiguration.getLevelType().getName(), (Object)newConfiguration.getConfigurationKey());
        this.configurationRepository.save((Object)newConfiguration);
    }

    private void modify(ConfigurationModifyDto configurationModifyDto, Configuration configuration) {
        configuration.modify(configurationModifyDto, this.configurationRepository);
        this.logger.info("update configuration[{}.{}]", (Object)configuration.getLevelType().getName(), (Object)configuration.getConfigurationKey());
        this.configurationRepository.updateById((Object)configuration, (Long)configuration.getId());
    }

    public void createConfigurationByMetadata(ConfigurationMetadata metadata) {
        Configuration configuration = new Configuration(metadata);
        this.configurationRepository.save((Object)configuration);
    }

    public List<ConfigurationFullVo> buildFullVo(List<Configuration> targetConfigList, List<ConfigurationMetadataVo> metadataList, List<ConfigurationMetadataTreeVo> metadataTreeList, Boolean desensitizeFlag) {
        if (CollectionUtils.isEmpty(targetConfigList) || CollectionUtils.isEmpty(metadataList)) {
            return Collections.emptyList();
        }
        if (targetConfigList.size() != metadataList.size()) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.CONFIG_DATA_ERROR);
        }
        Map<String, Configuration> configurationMap = targetConfigList.stream().collect(Collectors.toMap(Configuration::getConfigurationKey, c -> c, (c1, c2) -> c1));
        return Configuration.buildFullVoList(null, metadataTreeList, configurationMap, desensitizeFlag);
    }

    public List<Configuration> queryAllLevelConfiguration(ConfigurationQueryDto queryDto) {
        this.validateQueryDto(queryDto);
        ConfigurationQueryBean queryBean = this.buildAllLevelQueryBean(queryDto, (Long)ObjectUtils.defaultIfNull((Object)queryDto.getBusinessZoneId(), (Object)ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID));
        queryBean.setFunctionGroupCode(queryDto.getFunctionGroupCode());
        queryBean.setFunctionGroupId(queryDto.getFunctionGroupId());
        queryBean.setGroupId(queryDto.getGroupId());
        return this.configurationRepository.search(queryBean);
    }

    private ConfigurationQueryBean buildAllLevelQueryBean(ConfigurationDto queryDto, Long businessZoneId) {
        ConfigurationQueryBean queryBean = new ConfigurationQueryBean();
        ArrayList<LevelType> queryLevelType = new ArrayList<LevelType>();
        ArrayList<Long> queryLevelId = new ArrayList<Long>();
        queryLevelType.add(LevelType.GLOBAL);
        queryLevelId.add(0L);
        if (!ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID.equals(businessZoneId)) {
            queryLevelType.add(LevelType.ZONE);
            queryLevelId.add(businessZoneId);
        }
        switch (queryDto.getLevelType()) {
            case ZONE: {
                if (queryDto.getAppInstanceId() != null) {
                    queryLevelType.add(LevelType.INSTANCE);
                    queryLevelId.add(queryDto.getAppInstanceId());
                }
                if (queryDto.getTenantId() == null) break;
                queryLevelType.add(LevelType.TENANT);
                queryLevelId.add(queryDto.getTenantId());
                break;
            }
            case TENANT: {
                queryLevelType.add(LevelType.TENANT);
                queryLevelId.add(queryDto.getTenantId());
                break;
            }
            case INSTANCE: {
                queryLevelType.add(LevelType.TENANT);
                queryLevelType.add(LevelType.INSTANCE);
                queryLevelId.add(queryDto.getTenantId());
                queryLevelId.add(queryDto.getAppInstanceId());
                break;
            }
        }
        queryBean.setLevelType(queryLevelType);
        queryBean.setLevelId(queryLevelId);
        return queryBean;
    }

    public List<Configuration> merge(ConfigurationDto configurationDto, List<Configuration> allLevelConfigList, Long businessZoneId) {
        HashMap mergeMap = new HashMap(allLevelConfigList.size());
        allLevelConfigList.stream().filter(item -> {
            switch (configurationDto.getLevelType()) {
                case INSTANCE: {
                    return this.isMatchInstance((Configuration)((Object)item), configurationDto) || this.isMatchBusinessZone((Configuration)((Object)item), businessZoneId) || this.isMatchTenant((Configuration)((Object)item), configurationDto) || this.isMatchGlobal((Configuration)((Object)item));
                }
                case TENANT: 
                case ZONE: {
                    return this.isMatchBusinessZone((Configuration)((Object)item), businessZoneId) || this.isMatchTenant((Configuration)((Object)item), configurationDto) || this.isMatchGlobal((Configuration)((Object)item));
                }
            }
            return this.isMatchBusinessZone((Configuration)((Object)item), businessZoneId) || this.isMatchGlobal((Configuration)((Object)item));
        }).filter(item -> LevelType.ZONE.equals((Object)item.getLevelType()) || item.getLevelType().getOrderNum() <= configurationDto.getLevelType().getOrderNum()).sorted((i1, i2) -> i2.getLevelType().getOrderNum() - i1.getLevelType().getOrderNum()).forEach(item -> {
            if (!mergeMap.containsKey(item.getConfigurationKey())) {
                mergeMap.put(item.getConfigurationKey(), item);
            }
        });
        return new ArrayList<Configuration>(mergeMap.values());
    }

    private boolean isMatchGlobal(Configuration item) {
        return LevelType.GLOBAL.equals((Object)item.getLevelType()) && Objects.equals(item.getLevelId(), 0L);
    }

    private boolean isMatchTenant(Configuration item, ConfigurationDto configurationDto) {
        return LevelType.TENANT.equals((Object)item.getLevelType()) && Objects.equals(item.getLevelId(), configurationDto.getTenantId());
    }

    private boolean isMatchBusinessZone(Configuration item, Long businessZoneId) {
        return LevelType.ZONE.equals((Object)item.getLevelType()) && Objects.equals(item.getLevelId(), businessZoneId) && !ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID.equals(businessZoneId);
    }

    private boolean isMatchInstance(Configuration item, ConfigurationDto configurationDto) {
        return LevelType.INSTANCE.equals((Object)item.getLevelType()) && Objects.equals(item.getLevelId(), configurationDto.getAppInstanceId());
    }

    public String getStringValue(String functionGroupCode, String key, LevelType levelType, Long levelId) {
        if (StringUtils.isBlank((CharSequence)functionGroupCode)) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"functionGroupCode"});
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"key"});
        }
        if (null == levelId) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"levelId"});
        }
        if (null == levelType) {
            throw new BaseException((ErrorCode)ConfigurationApiResultCode.EMPTY_VALUE, new Object[]{"levelType"});
        }
        Configuration configuration = this.configurationRepository.findByFunctionGroupCodeAndConfigurationKeyAndLevelTypeAndLevelId(functionGroupCode, key, levelType, levelId);
        return null == configuration ? null : configuration.getConfigurationValue();
    }

    public String getStringValue(ConfigurationSingleQueryDto dto, Long businessZoneId) {
        this.validateConfigurationDto(dto);
        ConfigurationQueryBean queryBean = this.buildAllLevelQueryBean(dto, businessZoneId);
        queryBean.setFunctionGroupCode(dto.getFunctionGroupCode());
        queryBean.setConfigurationKey(dto.getConfigurationKey());
        List<Configuration> configurationList = this.configurationRepository.search(queryBean);
        List<Configuration> mergeList = this.merge(dto, configurationList, businessZoneId);
        return CollectionUtils.isEmpty(mergeList) ? null : mergeList.get(0).getConfigurationValue();
    }

    public List<String> getStringValueList(List<ConfigurationItemQueryDto> queryList) {
        if (CollectionUtils.isEmpty(queryList)) {
            return Collections.emptyList();
        }
        ConfigurationQueryBean queryBean = new ConfigurationQueryBean();
        queryBean.setLevelType(queryList.stream().map(ConfigurationItemQueryDto::getLevelType).collect(Collectors.toList()));
        queryBean.setLevelId(queryList.stream().map(ConfigurationItemQueryDto::getLevelId).collect(Collectors.toList()));
        queryBean.setFunctionGroupCodeIn(queryList.stream().map(ConfigurationItemQueryDto::getFunctionGroupCode).collect(Collectors.toList()));
        queryBean.setConfigurationKeyIn(queryList.stream().map(ConfigurationItemQueryDto::getKey).collect(Collectors.toList()));
        List<Configuration> configurationList = this.configurationRepository.search(queryBean);
        ArrayList<String> result = new ArrayList<String>(queryList.size());
        for (ConfigurationItemQueryDto queryDto : queryList) {
            Configuration configuration = configurationList.stream().filter(c -> c.getFunctionGroupCode().equals(queryDto.getFunctionGroupCode()) && c.getConfigurationKey().equals(queryDto.getKey()) && c.getLevelType().equals((Object)queryDto.getLevelType()) && c.getLevelId().equals(queryDto.getLevelId())).findFirst().orElse(null);
            result.add(configuration == null ? null : configuration.getConfigurationValue());
        }
        return result;
    }

    public List<Object> getObjectValueList(List<ConfigurationItemQueryDto> queryList) {
        if (CollectionUtils.isEmpty(queryList)) {
            return Collections.emptyList();
        }
        ConfigurationQueryBean queryBean = new ConfigurationQueryBean();
        queryBean.setLevelType(queryList.stream().map(ConfigurationItemQueryDto::getLevelType).collect(Collectors.toList()));
        queryBean.setLevelId(queryList.stream().map(ConfigurationItemQueryDto::getLevelId).collect(Collectors.toList()));
        queryBean.setFunctionGroupCodeIn(queryList.stream().map(ConfigurationItemQueryDto::getFunctionGroupCode).collect(Collectors.toList()));
        queryBean.setConfigurationKeyIn(queryList.stream().map(ConfigurationItemQueryDto::getKey).collect(Collectors.toList()));
        List<Configuration> configurationList = this.configurationRepository.search(queryBean);
        ArrayList<Object> result = new ArrayList<Object>(queryList.size());
        for (ConfigurationItemQueryDto queryDto : queryList) {
            Configuration configuration = configurationList.stream().filter(c -> c.getFunctionGroupCode().equals(queryDto.getFunctionGroupCode()) && c.getConfigurationKey().equals(queryDto.getKey()) && c.getLevelType().equals((Object)queryDto.getLevelType()) && c.getLevelId().equals(queryDto.getLevelId())).findFirst().orElse(null);
            result.add(configuration == null ? null : configuration.getObjectVal());
        }
        return result;
    }

    public List<Configuration> getObjectValueListUpgrade(ConfigurationQueryDto queryDto, List<ConfigurationItemQueryDto> queryList, Long businessZoneId) {
        if (CollectionUtils.isEmpty(queryList) || null == queryDto) {
            return Collections.emptyList();
        }
        this.validateConfigurationDto(queryDto);
        ConfigurationQueryBean queryBean = this.buildAllLevelQueryBean(queryDto, businessZoneId);
        queryBean.setFunctionGroupCodeIn(queryList.stream().map(ConfigurationItemQueryDto::getFunctionGroupCode).collect(Collectors.toList()));
        queryBean.setConfigurationKeyIn(queryList.stream().map(ConfigurationItemQueryDto::getKey).collect(Collectors.toList()));
        List<Configuration> configurationList = this.configurationRepository.search(queryBean);
        List<Configuration> mergeList = this.merge(queryDto, configurationList, businessZoneId);
        ArrayList<Configuration> result = new ArrayList<Configuration>(queryList.size());
        for (ConfigurationItemQueryDto itemQueryDto : queryList) {
            Configuration configuration = mergeList.stream().filter(c -> c.getFunctionGroupCode().equals(itemQueryDto.getFunctionGroupCode()) && c.getConfigurationKey().equals(itemQueryDto.getKey())).findFirst().orElse(null);
            result.add(configuration);
        }
        return result;
    }

    public Map<String, String> getConfigMapByFunctionGroupCode(ConfigurationQueryDto queryDto) {
        List<Configuration> configurationList = this.queryAllLevelConfiguration(queryDto);
        List<Configuration> mergeList = this.merge(queryDto, configurationList, (Long)ObjectUtils.defaultIfNull((Object)queryDto.getBusinessZoneId(), (Object)ConfigurationConstant.EMPTY_BUSINESS_ZONE_ID));
        return CollectionUtils.isEmpty(mergeList) ? Collections.emptyMap() : mergeList.stream().collect(Collectors.toMap(Configuration::getConfigurationKey, Configuration::getConfigurationValue, (i1, i2) -> i1));
    }

    public void moveToTargetGroup(Long sourceGroupId, long targetGroupId) {
        this.configurationRepository.updateGroupIdByGroupId(sourceGroupId, targetGroupId);
    }

    public void modifyByMetadata(ConfigurationMetadata metadata) {
        this.configurationRepository.updateNameAndDescription(metadata.getName(), metadata.getDescription(), metadata.getDesensitizeFlag(), metadata.getFunctionGroupId(), metadata.getConfigurationKey());
    }

    public void updateSpiConfigVal(SpiRegisterDto spiRegisterDto, ConfigurationMetadataDiff diff) {
        if (Boolean.TRUE.equals(diff.getCreateFlag())) {
            ConfigurationMetadata metadata = new ConfigurationMetadata();
            BeanUtils.copyProperties((Object)spiRegisterDto, (Object)((Object)metadata));
            metadata.setValueType(ConfigurationValueType.SPI);
            this.createConfigurationByMetadata(metadata);
        } else if (Boolean.TRUE.equals(diff.getMultiToSingle()) || !CollectionUtils.isEmpty(diff.getDeleteItem())) {
            ConfigurationQueryBean queryBean = new ConfigurationQueryBean();
            queryBean.setFunctionGroupId(diff.getFunctionGroupId());
            queryBean.setConfigurationKey(diff.getConfigurationKey());
            List<Configuration> configurationList = this.configurationRepository.search(queryBean);
            if (!CollectionUtils.isEmpty(configurationList)) {
                this.updateSpiConfigList(diff, configurationList);
            }
        }
    }

    private void updateSpiConfigList(ConfigurationMetadataDiff diff, List<Configuration> configurationList) {
        ArrayList needToDeleteConfigs = new ArrayList(configurationList.size());
        if (Boolean.TRUE.equals(diff.getMultiToSingle())) {
            configurationList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getConfigurationValue()) && c.getConfigurationValue().contains(",")).forEach(needToDeleteConfigs::add);
        }
        if (!CollectionUtils.isEmpty(diff.getDeleteItem())) {
            Set deleteItemVal = diff.getDeleteItem().stream().map(ConfigurationItem::getValue).collect(Collectors.toSet());
            configurationList.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getConfigurationValue()) && deleteItemVal.contains(c.getConfigurationValue())).forEach(needToDeleteConfigs::add);
        }
        HashSet<Long> needToDeleteConfigIds = new HashSet<Long>(needToDeleteConfigs.size());
        boolean updateGlobal = false;
        for (Configuration needToDeleteConfig : needToDeleteConfigs) {
            if (LevelType.GLOBAL == needToDeleteConfig.getLevelType()) {
                if (updateGlobal) continue;
                updateGlobal = true;
                needToDeleteConfig.setConfigurationValue(diff.getDefaultValue());
                this.configurationRepository.updateById((Object)needToDeleteConfig, (Long)needToDeleteConfig.getId());
                continue;
            }
            needToDeleteConfigIds.add((Long)needToDeleteConfig.getId());
        }
        if (!CollectionUtils.isEmpty(needToDeleteConfigIds)) {
            this.configurationRepository.deleteByIdIn(needToDeleteConfigIds);
        }
    }

    public void checkConfigWitheList(List<String> functionGroupCodes, List<String> keys) {
        if (CollectionUtils.isEmpty(functionGroupCodes) || CollectionUtils.isEmpty(keys)) {
            return;
        }
        if (functionGroupCodes.size() != keys.size()) {
            throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.BASE);
        }
        Map<String, Set<String>> witheList = this.bbcConfigurationProperties.getWhiteList();
        if (MapUtils.isEmpty(witheList)) {
            this.logger.error("\u65e0\u914d\u7f6e\u9879\u767d\u540d\u5355");
        } else {
            for (int i = 0; i < functionGroupCodes.size(); ++i) {
                String key;
                String code = functionGroupCodes.get(i);
                Set<String> configurationKeys = witheList.get(code);
                if (CollectionUtils.isEmpty(configurationKeys)) {
                    this.logger.error("\u529f\u80fd\u7f16\u7801[{}]\u672a\u914d\u7f6e\u767d\u540d\u5355", (Object)code);
                }
                if (configurationKeys.contains(key = keys.get(i))) continue;
                this.logger.error("\u914d\u7f6ekey[{}]\u4e0d\u5728\u767d\u540d\u5355\u4e2d", (Object)key);
            }
        }
    }

    public void copyTenant(TenantCopyJobDto dto) {
        ArrayList<Long> levelIds = new ArrayList<Long>();
        levelIds.add(dto.getSourceTenantId());
        if (dto.getCopyAppInstances() != null && !dto.getCopyAppInstances().isEmpty()) {
            levelIds.addAll(dto.getCopyAppInstances().keySet());
        }
        if (dto.getCopyBusinessZones() != null && !dto.getCopyBusinessZones().isEmpty()) {
            levelIds.addAll(dto.getCopyBusinessZones().keySet());
        }
        ConfigurationQueryBean queryBean = new ConfigurationQueryBean();
        queryBean.setLevelType(List.of(LevelType.TENANT, LevelType.ZONE, LevelType.INSTANCE));
        queryBean.setLevelId(levelIds);
        List<Configuration> list = this.configurationRepository.search(queryBean);
        ArrayList<Configuration> copyList = new ArrayList<Configuration>();
        for (Configuration configuration : list) {
            this.copyConfiguration(dto, copyList, configuration);
        }
        if (!copyList.isEmpty()) {
            this.configurationRepository.batchInsert(copyList);
        }
    }

    private void copyConfiguration(TenantCopyJobDto dto, List<Configuration> copyList, Configuration configuration) {
        switch (configuration.getLevelType()) {
            case TENANT: {
                if (!configuration.getLevelId().equals(dto.getSourceTenantId())) break;
                copyList.add(this.copyConfiguration(configuration, dto));
                break;
            }
            case ZONE: {
                if (dto.getCopyBusinessZones() == null || !dto.getCopyBusinessZones().containsKey(configuration.getLevelId())) break;
                copyList.add(this.copyConfiguration(configuration, dto));
                break;
            }
            case INSTANCE: {
                if (dto.getCopyAppInstances() == null || !dto.getCopyAppInstances().containsKey(configuration.getLevelId())) break;
                copyList.add(this.copyConfiguration(configuration, dto));
                break;
            }
        }
    }

    private Configuration copyConfiguration(Configuration source, TenantCopyJobDto dto) {
        Configuration target = new Configuration();
        target.setConfigurationKey(source.getConfigurationKey());
        target.setConfigurationValue(StringUtils.defaultString((String)source.getConfigurationValue()));
        target.setName(StringUtils.defaultString((String)source.getName()));
        target.setValueType(source.getValueType());
        target.setDescription(StringUtils.defaultString((String)source.getDescription()));
        target.setGroupId((Long)ObjectUtils.defaultIfNull((Object)source.getGroupId(), (Object)0L));
        target.setEnableModify(Boolean.TRUE.equals(source.getEnableModify()));
        target.setFunctionGroupCode(StringUtils.defaultString((String)source.getFunctionGroupCode()));
        target.setFunctionGroupId((Long)ObjectUtils.defaultIfNull((Object)source.getFunctionGroupId(), (Object)0L));
        target.setSourceType(StringUtils.defaultString((String)source.getSourceType()));
        target.setSourceId((Long)ObjectUtils.defaultIfNull((Object)source.getSourceId(), (Object)0L));
        target.setLevelType(source.getLevelType());
        target.setTenantId(dto.getTargetTenantId());
        switch (target.getLevelType()) {
            case TENANT: {
                target.setLevelId(dto.getTargetTenantId());
                target.setBusinessZoneId(0L);
                target.setAppInstanceId(0L);
                break;
            }
            case ZONE: {
                target.setLevelId(((TenantCopyItemDto)dto.getCopyBusinessZones().get(source.getLevelId())).getId());
                target.setBusinessZoneId(target.getLevelId());
                target.setAppInstanceId(0L);
                break;
            }
            case INSTANCE: {
                target.setLevelId(((TenantCopyItemDto)dto.getCopyAppInstances().get(source.getLevelId())).getId());
                target.setBusinessZoneId(0L);
                target.setAppInstanceId(target.getLevelId());
                break;
            }
        }
        return target;
    }

    public List<ConfigurationExportData> queryExportData(ConfigurationExportQueryDto queryDto) {
        if (CollectionUtils.isEmpty(queryDto.getLevelTypeIn())) {
            queryDto.setLevelTypeIn(List.of(LevelType.GLOBAL, LevelType.TENANT, LevelType.ZONE, LevelType.INSTANCE));
        }
        return this.configurationRepository.queryExportData(queryDto);
    }

    public void importByConfigurationExportData(ConfigurationImportParamDto paramDto) {
        List<ConfigurationExportData> exportDataList = paramDto.getExportDataList();
        Map<String, Configuration> configurationMap = this.configurationRepository.findAll().stream().collect(Collectors.toMap(c -> c.getConfigurationKey() + c.getLevelType() + c.getLevelId(), c -> c));
        for (ConfigurationExportData configurationExportData : exportDataList) {
            String key = configurationExportData.getConfigurationKey() + configurationExportData.getLevelType() + configurationExportData.getLevelId();
            Configuration configuration = configurationMap.get(key);
            if (null != configuration) {
                configuration.modifyByByConfigurationExportData(configurationExportData, 1 == paramDto.getMode());
                this.configurationRepository.updateById((Object)configuration, (Long)configuration.getId());
                continue;
            }
            configuration = Configuration.fromConfigurationExportData(configurationExportData);
            this.configurationRepository.save((Object)configuration);
        }
    }
}

