/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.infra.config;

import com.alibaba.ttl.threadpool.TtlExecutors;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationApplicationService;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationCacheService;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationExportService;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationImportApplicationService;
import com.cyberway.mp.bbc.configuration.domain.repository.ConfigurationGroupRepository;
import com.cyberway.mp.bbc.configuration.domain.repository.ConfigurationMetadataRepository;
import com.cyberway.mp.bbc.configuration.domain.repository.ConfigurationRepository;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationFunctionService;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationGroupService;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationMetadataService;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationService;
import com.cyberway.mp.bbc.configuration.domain.service.SpiConfigurationRegister;
import com.cyberway.mp.bbc.configuration.infra.config.BbcConfigurationProperties;
import com.cyberway.mp.bbc.configuration.infra.config.ConfigurationLiquibaseBeanPostProcessor;
import com.cyberway.mp.bbc.configuration.infra.config.DefaultKeyGenerator;
import com.cyberway.mp.bbc.configuration.infra.config.FunctionTreeProperties;
import com.cyberway.mp.bbc.configuration.infra.facade.aggregation.ConfigurationAggregationService;
import com.cyberway.mp.bbc.configuration.infra.facade.aggregation.ConfigurationFeignClientFactory;
import com.cyberway.mp.bbc.configuration.infra.facade.uc.UcFacadeService;
import com.cyberway.mp.bbc.configuration.infra.facade.uc.UcFacadeServiceImpl;
import com.cyberway.mp.bbc.configuration.infra.handler.TenantCopyConfigurationHandler;
import com.cyberway.mp.bc.common.annotation.EnableCommonControllerConfig;
import com.cyberway.mp.bc.common.annotation.EnableCommonFeignConfig;
import com.cyberway.mp.bc.dal.config.EnableDAL;
import com.cyberway.mp.bc.lock.LockService;
import com.cyberway.mp.user.api.appinstance.AppInstanceApi;
import com.cyberway.mp.user.api.businesszone.BusinessZoneApi;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;

@MapperScan(value={"com.cyberway.mp.bbc.configuration.domain"})
@EnableDAL
@EnableCommonFeignConfig
@Configuration
@ComponentScan(basePackages={"com.cyberway.mp.bbc.configuration"})
@EnableCommonControllerConfig
@Import(value={FunctionTreeProperties.class, BbcConfigurationProperties.class})
@EnableFeignClients(basePackages={"com.cyberway.mp.bbc.configuration.infra.facade.mc"})
public class AutoConfiguration {
    public static final String CONFIGURATION_LIQUIBASE_MANGER_BEAN_NAME = "configurationLiquibaseManger";
    private static final String CONFIGURATION_EXECUTOR_SERVICE_BEAN_NAME = "configurationExecutorService";

    @Bean(name={"configurationExecutorService"})
    public ExecutorService configurationExecutorService() {
        return TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(5, 20, 2L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(100), Executors.defaultThreadFactory(), new ThreadPoolExecutor.CallerRunsPolicy()));
    }

    @Bean
    public ConfigurationFunctionService configurationFunctionService(FunctionTreeProperties functionTreeProperties) {
        return new ConfigurationFunctionService(functionTreeProperties);
    }

    @Bean
    public ConfigurationGroupService configurationGroupService(ConfigurationGroupRepository configurationGroupRepository) {
        return new ConfigurationGroupService(configurationGroupRepository);
    }

    @Bean
    public ConfigurationMetadataService configurationMetadataService(ConfigurationMetadataRepository configurationMetadataRepository) {
        return new ConfigurationMetadataService(configurationMetadataRepository);
    }

    @Bean
    public ConfigurationService configurationService(BbcConfigurationProperties bbcConfigurationProperties, ConfigurationRepository configurationRepository) {
        return new ConfigurationService(bbcConfigurationProperties, configurationRepository);
    }

    @Bean
    public SpiConfigurationRegister spiConfigurationRegister(ConfigurationService configurationService, ConfigurationMetadataService configurationMetadataService) {
        return new SpiConfigurationRegister(configurationService, configurationMetadataService);
    }

    @Bean
    @ConditionalOnMissingBean
    public UcFacadeService ucFacadeService(@Autowired(required=false) AppInstanceApi appInstanceApi, @Autowired(required=false) BusinessZoneApi businessZoneApi) {
        return new UcFacadeServiceImpl(appInstanceApi, businessZoneApi);
    }

    @Bean
    public ConfigurationCacheService configurationCacheService(ConfigurationService configurationService, UcFacadeService ucFacadeService) {
        return new ConfigurationCacheService(configurationService, ucFacadeService);
    }

    @Bean
    public ConfigurationApi configurationApplicationService(ConfigurationGroupService configurationGroupService, ConfigurationService configurationService, ConfigurationMetadataService configurationMetadataService, ConfigurationFunctionService configurationFunctionService, ConfigurationCacheService configurationCacheService, @Autowired(required=false) LockService lockService, SpiConfigurationRegister spiConfigurationRegister) {
        return new ConfigurationApplicationService(configurationGroupService, configurationService, configurationMetadataService, configurationFunctionService, configurationCacheService, lockService, spiConfigurationRegister);
    }

    @Bean
    public ConfigurationImportApplicationService configurationImportApplicationService(@Autowired @Qualifier(value="configurationExecutorService") ExecutorService configurationExecutorService, ConfigurationFunctionService configurationFunctionService, ConfigurationApi configurationApi) {
        return new ConfigurationImportApplicationService(configurationExecutorService, configurationFunctionService, configurationApi);
    }

    @Bean
    public ConfigurationExportService configurationImportAndExportService(FunctionTreeProperties functionTreeProperties, ConfigurationAggregationService configurationAggregationService) {
        return new ConfigurationExportService(functionTreeProperties, configurationAggregationService);
    }

    @Bean(name={"configurationDefaultKeyGenerator"})
    public KeyGenerator defaultKeyGenerator() {
        return new DefaultKeyGenerator();
    }

    @Bean
    public ConfigurationFeignClientFactory configurationFeignClientFactory() {
        return new ConfigurationFeignClientFactory();
    }

    @Bean
    public ConfigurationAggregationService configurationAggregationService(ConfigurationApi configurationApi, @Qualifier(value="configurationExecutorService") ExecutorService executorService, ConfigurationFunctionService configurationFunctionService, ConfigurationFeignClientFactory configurationFeignClientFactory, FunctionTreeProperties functionTreeProperties) {
        return new ConfigurationAggregationService(configurationApi, executorService, configurationFunctionService, configurationFeignClientFactory, functionTreeProperties);
    }

    @Bean(name={"configurationLiquibaseManger"})
    @ConditionalOnProperty(prefix="spring.liquibase", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public SpringLiquibase configurationLiquibaseManger(DataSource dataSource, ResourceLoader resourceLoader) {
        SpringLiquibase liquibase = new SpringLiquibase();
        liquibase.setDataSource(dataSource);
        liquibase.setResourceLoader(resourceLoader);
        liquibase.setChangeLog("classpath:configuration-liquibase-master.xml");
        liquibase.setDatabaseChangeLogTable("configuration_database_change_log");
        liquibase.setDatabaseChangeLogLockTable("configuration_database_change_log_lock");
        return liquibase;
    }

    @Bean
    public TenantCopyConfigurationHandler tenantCopyConfigurationHandler(ConfigurationService configurationService) {
        return new TenantCopyConfigurationHandler(configurationService);
    }

    @Bean
    public ConfigurationLiquibaseBeanPostProcessor configurationLiquibaseBeanPostProcessor() {
        return new ConfigurationLiquibaseBeanPostProcessor();
    }
}

