/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.infra.facade.aggregation;

import com.cyberway.mp.bbc.configuration.api.CenterFunctionTree;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApiResultCode;
import com.cyberway.mp.bbc.configuration.api.ConfigurationExportData;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationExportQueryDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationImportParamDto;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationItemQueryDto;
import com.cyberway.mp.bbc.configuration.application.service.ConfigurationImportService;
import com.cyberway.mp.bbc.configuration.domain.entity.ConfigurationFunction;
import com.cyberway.mp.bbc.configuration.domain.service.ConfigurationFunctionService;
import com.cyberway.mp.bbc.configuration.infra.config.FunctionTreeProperties;
import com.cyberway.mp.bbc.configuration.infra.facade.aggregation.ConfigurationFeignClient;
import com.cyberway.mp.bbc.configuration.infra.facade.aggregation.ConfigurationFeignClientFactory;
import com.cyberway.mp.bc.common.api.exception.ErrorCode;
import com.cyberway.mp.bc.i18n.api.exception.BaseI18nException;
import jakarta.validation.Valid;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.util.Pair;
import org.springframework.web.multipart.MultipartFile;

public class ConfigurationAggregationService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConfigurationApi configurationApi;
    private final ExecutorService executorService;
    private final ConfigurationFunctionService configurationFunctionService;
    private final ConfigurationFeignClientFactory feignClientFactory;
    @Value(value="${spring.application.name:}")
    private String serviceName;
    private final FunctionTreeProperties functionTreeProperties;

    public ConfigurationAggregationService(ConfigurationApi configurationApi, ExecutorService executorService, ConfigurationFunctionService configurationFunctionService, ConfigurationFeignClientFactory feignClientFactory, FunctionTreeProperties functionTreeProperties) {
        this.configurationApi = configurationApi;
        this.executorService = executorService;
        this.configurationFunctionService = configurationFunctionService;
        this.feignClientFactory = feignClientFactory;
        this.functionTreeProperties = functionTreeProperties;
    }

    public List<String> getStringValueList(List<ConfigurationItemQueryDto> queryList) {
        Function localFunction = this.configurationApi::getStringValueList;
        Function remoteFunction = pair -> {
            ConfigurationFeignClient feignClient = this.feignClientFactory.getClient((String)pair.getFirst());
            return (List)feignClient.getStringValueList((List)pair.getSecond()).getData();
        };
        return this.call(queryList, localFunction, remoteFunction);
    }

    public List<String> getStringValueListWithoutLogin(List<ConfigurationItemQueryDto> queryList) {
        Function localFunction = this.configurationApi::getStringValueListWithoutLogin;
        Function remoteFunction = pair -> {
            ConfigurationFeignClient feignClient = this.feignClientFactory.getClient((String)pair.getFirst());
            return (List)feignClient.getStringValueListWithoutLogin((List)pair.getSecond()).getData();
        };
        return this.call(queryList, localFunction, remoteFunction);
    }

    public List<Object> getObjectValueList(List<ConfigurationItemQueryDto> queryList) {
        Function localFunction = this.configurationApi::getObjectValueList;
        Function remoteFunction = pair -> {
            ConfigurationFeignClient feignClient = this.feignClientFactory.getClient((String)pair.getFirst());
            return (List)feignClient.getObjectValueList((List)pair.getSecond()).getData();
        };
        return this.call(queryList, localFunction, remoteFunction);
    }

    public List<Object> getObjectValueListWithoutLogin(List<ConfigurationItemQueryDto> queryList) {
        Function localFunction = this.configurationApi::getObjectValueListWithoutLogin;
        Function remoteFunction = pair -> {
            ConfigurationFeignClient feignClient = this.feignClientFactory.getClient((String)pair.getFirst());
            return (List)feignClient.getObjectValueListWithoutLogin((List)pair.getSecond()).getData();
        };
        return this.call(queryList, localFunction, remoteFunction);
    }

    public List<Object> getObjectValueListUpgrade(List<ConfigurationItemQueryDto> queryList) {
        Function localFunction = this.configurationApi::getObjectValueListUpgrade;
        Function remoteFunction = pair -> {
            ConfigurationFeignClient feignClient = this.feignClientFactory.getClient((String)pair.getFirst());
            return (List)feignClient.getObjectValueListUpgrade((List)pair.getSecond()).getData();
        };
        return this.call(queryList, localFunction, remoteFunction);
    }

    public Map<String, Object> getObjectValueMapUpgrade(List<ConfigurationItemQueryDto> queryList) {
        List<Object> valueList = this.getObjectValueListUpgrade(queryList);
        return this.configurationApi.buildConfigurationResultMap(queryList, valueList);
    }

    public List<Object> getObjectValueListWithoutLoginUpgrade(List<ConfigurationItemQueryDto> queryList) {
        Function localFunction = this.configurationApi::getObjectValueListWithoutLoginUpgrade;
        Function remoteFunction = pair -> {
            ConfigurationFeignClient feignClient = this.feignClientFactory.getClient((String)pair.getFirst());
            return (List)feignClient.getObjectValueListWithoutLoginUpgrade((List)pair.getSecond()).getData();
        };
        return this.call(queryList, localFunction, remoteFunction);
    }

    public void importData(MultipartFile file, int mode) {
        ConfigurationImportService configurationImportService = new ConfigurationImportService();
        try {
            configurationImportService.importExcel(file.getInputStream());
            List<ConfigurationExportData> dataList = configurationImportService.getDataList();
            HashMap<String, List> exportDataMapByService = new HashMap<String, List>(this.functionTreeProperties.getNodes().size());
            for (ConfigurationExportData configurationExportData : dataList) {
                String targetServiceName = this.findServiceNameByFunctionGroupId(configurationExportData.getFunctionGroupId());
                List subList = exportDataMapByService.getOrDefault(targetServiceName, new ArrayList());
                subList.add(configurationExportData);
                exportDataMapByService.put(targetServiceName, subList);
            }
            exportDataMapByService.forEach((targetService, list) -> this.executorService.submit(() -> {
                try {
                    ConfigurationImportParamDto paramDto = new ConfigurationImportParamDto();
                    paramDto.setMode(mode);
                    paramDto.setExportDataList((List<ConfigurationExportData>)list);
                    if (targetService.equals(this.serviceName)) {
                        this.configurationApi.importByConfigurationExportData(paramDto);
                    } else {
                        this.feignClientFactory.getClient((String)targetService).importByConfigurationExportData(paramDto);
                    }
                }
                catch (Exception e) {
                    this.logger.error("\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff0c\u670d\u52a1\u540d:{" + targetService + "}", (Throwable)e);
                }
            }));
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u5165\u5f02\u5e38", (Throwable)e);
        }
    }

    private String findServiceNameByFunctionGroupId(Long functionGroupId) {
        for (CenterFunctionTree parentNode : this.functionTreeProperties.getNodes()) {
            if (!parentNode.contains(functionGroupId)) continue;
            return parentNode.getServiceName();
        }
        throw new BaseI18nException((ErrorCode)ConfigurationApiResultCode.FUNCTION_ID_ERROR, new Object[]{functionGroupId});
    }

    public List<ConfigurationExportData> queryExportData(Set<String> targetServiceNames, ConfigurationExportQueryDto queryDto) {
        if (CollectionUtils.isEmpty(targetServiceNames)) {
            return Collections.emptyList();
        }
        ArrayList<Future> futureList = new ArrayList<Future>(targetServiceNames.size());
        for (String string : targetServiceNames) {
            Future future = this.executorService.submit(() -> {
                List<ConfigurationExportData> result = Collections.emptyList();
                try {
                    result = string.equals(this.serviceName) ? this.configurationApi.queryExportData(queryDto) : (List<ConfigurationExportData>)this.feignClientFactory.getClient(string).queryExportData(queryDto).getData();
                }
                catch (Exception e) {
                    this.logger.error("\u67e5\u8be2\u5bfc\u51fa\u6570\u636e\u5f02\u5e38\uff0c\u670d\u52a1\u540d:{" + string + "}", (Throwable)e);
                }
                return result;
            });
            futureList.add(future);
        }
        ArrayList<ConfigurationExportData> resultList = new ArrayList<ConfigurationExportData>();
        try {
            for (Future future : futureList) {
                resultList.addAll((Collection)future.get());
            }
            resultList.sort(Comparator.comparing(ConfigurationExportData::getFunctionGroupId));
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new BaseI18nException("00000001", "InterruptedException");
        }
        catch (ExecutionException executionException) {
            throw new BaseI18nException("00000001", "ExecutionException");
        }
        return resultList;
    }

    public Map<String, Object> getObjectValueMapWithoutLoginUpgrade(@Valid List<ConfigurationItemQueryDto> queryList) {
        List<Object> valueList = this.getObjectValueListWithoutLoginUpgrade(queryList);
        return this.configurationApi.buildConfigurationResultMap(queryList, valueList);
    }

    private <T> List<T> call(List<ConfigurationItemQueryDto> queryList, Function<List<ConfigurationItemQueryDto>, List<T>> localFunction, Function<Pair<String, List<ConfigurationItemQueryDto>>, List<T>> remoteFunction) {
        Map<String, List<ConfigurationItemQueryDto>> groupByService = this.groupQueryList(queryList);
        ConcurrentHashMap resultMap = new ConcurrentHashMap(16);
        ArrayList futureList = new ArrayList(groupByService.size());
        groupByService.forEach((targetServiceName, subQueryList) -> futureList.add(this.executorService.submit(() -> this.executeFunction(localFunction, remoteFunction, (String)targetServiceName, (List<ConfigurationItemQueryDto>)subQueryList, resultMap))));
        try {
            for (Future future : futureList) {
                future.get();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            e.printStackTrace();
            throw new BaseI18nException("00000001", "InterruptedException");
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            throw new BaseI18nException("00000001", "ExecutionException");
        }
        if (resultMap.size() != groupByService.size()) {
            this.logger.error("\u914d\u7f6e\u9879\u805a\u5408\u83b7\u53d6\u5f02\u5e38");
        }
        ArrayList resultList = new ArrayList(queryList.size());
        for (ConfigurationItemQueryDto queryDto : queryList) {
            boolean found = false;
            for (Map.Entry<String, List<ConfigurationItemQueryDto>> entry : groupByService.entrySet()) {
                String targetServiceName2 = entry.getKey();
                List<ConfigurationItemQueryDto> subQueryList2 = entry.getValue();
                if (!resultMap.containsKey(targetServiceName2)) continue;
                for (int i = 0; i < subQueryList2.size(); ++i) {
                    if (!queryDto.equals(subQueryList2.get(i))) continue;
                    resultList.add(((List)resultMap.get(targetServiceName2)).get(i));
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (found) continue;
            resultList.add(null);
        }
        return resultList;
    }

    private <T> void executeFunction(Function<List<ConfigurationItemQueryDto>, List<T>> localFunction, Function<Pair<String, List<ConfigurationItemQueryDto>>, List<T>> remoteFunction, String targetServiceName, List<ConfigurationItemQueryDto> subQueryList, Map<String, List<T>> resultMap) {
        try {
            List<T> result = targetServiceName.equals(this.serviceName) ? localFunction.apply(subQueryList) : remoteFunction.apply((Pair<String, List<ConfigurationItemQueryDto>>)Pair.of((Object)targetServiceName, subQueryList));
            resultMap.put(targetServiceName, result);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Map<String, List<ConfigurationItemQueryDto>> groupQueryList(List<ConfigurationItemQueryDto> queryList) {
        if (CollectionUtils.isEmpty(queryList)) {
            return Collections.emptyMap();
        }
        HashMap<String, List<ConfigurationItemQueryDto>> result = new HashMap<String, List<ConfigurationItemQueryDto>>();
        for (ConfigurationItemQueryDto dto : queryList) {
            ConfigurationFunction configurationFunction = this.configurationFunctionService.getByCode(dto.getFunctionGroupCode());
            String serviceNameByCode = null;
            if (null == configurationFunction) {
                this.logger.error("\u529f\u80fd\u7f16\u7801[{}]\u9519\u8bef", (Object)dto.getFunctionGroupCode());
                continue;
            }
            serviceNameByCode = configurationFunction.getServiceName();
            List subList = result.computeIfAbsent(serviceNameByCode, k -> new ArrayList());
            subList.add(dto);
        }
        return result;
    }
}

