/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.infra.facade.aggregation;

import com.cyberway.mp.bbc.configuration.infra.facade.aggregation.ConfigurationFeignClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.cloud.openfeign.FeignClientBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ConfigurationFeignClientFactory
implements ApplicationContextAware {
    private FeignClientBuilder feignClientBuilder;
    private final Map<String, ConfigurationFeignClient> cacheMap = new ConcurrentHashMap<String, ConfigurationFeignClient>(16);

    public ConfigurationFeignClient getClient(String serviceName) {
        if (StringUtils.isBlank((CharSequence)serviceName)) {
            throw new IllegalArgumentException("serviceName must not blank");
        }
        if (this.cacheMap.containsKey(serviceName)) {
            return this.cacheMap.get(serviceName);
        }
        ConfigurationFeignClient feignClient = this.buildClient(serviceName);
        this.cacheMap.put(serviceName, feignClient);
        return feignClient;
    }

    private ConfigurationFeignClient buildClient(String serviceName) {
        return (ConfigurationFeignClient)this.feignClientBuilder.forType(ConfigurationFeignClient.class, serviceName).path("/api/configuration").build();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.feignClientBuilder = new FeignClientBuilder(applicationContext);
    }
}

