/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.configuration.infra.facade.uc;

import com.cyberway.mp.bbc.configuration.infra.facade.uc.UcFacadeService;
import com.cyberway.mp.bbc.configuration.infra.facade.uc.vo.AppInstanceInfoVo;
import com.cyberway.mp.bbc.configuration.infra.facade.uc.vo.BusinessZoneInfoVo;
import com.cyberway.mp.user.api.appinstance.AppInstanceApi;
import com.cyberway.mp.user.api.businesszone.BusinessZoneApi;
import org.springframework.beans.BeanUtils;

public class UcFacadeServiceImpl
implements UcFacadeService {
    private final AppInstanceApi appInstanceApi;
    private final BusinessZoneApi businessZoneApi;

    public UcFacadeServiceImpl(AppInstanceApi appInstanceApi, BusinessZoneApi businessZoneApi) {
        this.appInstanceApi = appInstanceApi;
        this.businessZoneApi = businessZoneApi;
    }

    @Override
    public AppInstanceInfoVo getAppInstance(Long instanceId) {
        if (null == this.appInstanceApi) {
            throw new UnsupportedOperationException("AppInstanceApi instance is null!");
        }
        com.cyberway.mp.user.api.appinstance.vo.AppInstanceInfoVo sourceVo = this.appInstanceApi.getAppInstance(instanceId.longValue());
        AppInstanceInfoVo targetVo = new AppInstanceInfoVo();
        BeanUtils.copyProperties((Object)sourceVo, (Object)targetVo);
        targetVo.setId(sourceVo.getId());
        return targetVo;
    }

    @Override
    public BusinessZoneInfoVo getBusinessZone(Long zoneId) {
        if (null == this.appInstanceApi) {
            throw new UnsupportedOperationException("BusinessZoneApi instance is null!");
        }
        com.cyberway.mp.user.api.businesszone.vo.BusinessZoneInfoVo sourceVo = this.businessZoneApi.getBusinessZone(zoneId.longValue());
        BusinessZoneInfoVo targetVo = new BusinessZoneInfoVo();
        BeanUtils.copyProperties((Object)sourceVo, (Object)targetVo);
        targetVo.setId(sourceVo.getId());
        return targetVo;
    }
}

