/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.password.decode;

import cn.hutool.core.util.HexUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationItemQueryDto;
import com.cyberway.mp.bbc.password.decode.config.PasswordDecodeProperties;
import com.cyberway.mp.bc.common.config.SpringContextUtil;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.crypto.CryptoConfig;
import com.cyberway.mp.bc.common.crypto.CryptoProvider;
import com.cyberway.mp.bc.common.crypto.CryptoProviderFactory;
import com.cyberway.mp.bc.common.crypto.asymmetric.AsymmetricAlgorithmType;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestPasswordDecoder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BASE64_PATTERN = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    private final PasswordDecodeProperties passwordDecodeProperties;
    private CryptoProvider passwordDecoder;
    private String currentEncryptType;

    public RequestPasswordDecoder(PasswordDecodeProperties passwordDecodeProperties) {
        this.passwordDecodeProperties = passwordDecodeProperties;
    }

    public String doDecode(String requestBody) {
        if (StringUtils.isBlank((CharSequence)requestBody)) {
            return requestBody;
        }
        boolean enableEncrypt = true;
        String encryptType = null;
        try {
            Object configurationApiObj = SpringContextUtil.getBean((String)"configurationApplicationService");
            if (null != configurationApiObj) {
                Pair<LevelType, Long> levelTypeLongPair = this.getLevelTypeLongPair();
                ConfigurationApi configurationApi = (ConfigurationApi)configurationApiObj;
                ConfigurationItemQueryDto enableEncryptQuery = new ConfigurationItemQueryDto();
                enableEncryptQuery.setKey("enable_password_encrypt");
                enableEncryptQuery.setFunctionGroupCode("security-setting");
                enableEncryptQuery.setLevelType((LevelType)levelTypeLongPair.getLeft());
                enableEncryptQuery.setLevelId((Long)levelTypeLongPair.getRight());
                ConfigurationItemQueryDto encryptTypeQuery = new ConfigurationItemQueryDto();
                encryptTypeQuery.setKey("encrypt_type");
                encryptTypeQuery.setFunctionGroupCode("security-setting");
                encryptTypeQuery.setLevelType((LevelType)levelTypeLongPair.getLeft());
                encryptTypeQuery.setLevelId((Long)levelTypeLongPair.getRight());
                List values = configurationApi.getObjectValueListUpgrade(Arrays.asList(enableEncryptQuery, encryptTypeQuery));
                enableEncrypt = "true".equalsIgnoreCase((String)values.get(0));
                encryptType = (String)values.get(1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!enableEncrypt) {
            return requestBody;
        }
        if (null == encryptType) {
            encryptType = this.passwordDecodeProperties.getType();
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)this.currentEncryptType, (CharSequence)encryptType)) {
            this.initPasswordDecoder(encryptType);
        }
        if (null != this.passwordDecoder) {
            return this.decodeResponse(requestBody);
        }
        return requestBody;
    }

    private String decodeResponse(String requestBody) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)requestBody);
            for (String key : jsonObject.keySet()) {
                String password;
                if (!this.matchNeedDecodeFieldName(key) || !this.isBase64(password = jsonObject.getString(key)) && !HexUtil.isHexNumber((String)password)) continue;
                String decodePassword = this.decode(password);
                jsonObject.put(key, (Object)decodePassword);
            }
            requestBody = jsonObject.toJSONString();
        }
        catch (Exception e) {
            this.logger.warn("\u5bc6\u7801\u89e3\u7801\u62e6\u622a\u5668\u89e3\u6790\u53c2\u6570\u5f02\u5e38");
        }
        return requestBody;
    }

    private void initPasswordDecoder(String encryptType) {
        this.currentEncryptType = encryptType;
        if ("RSA".equalsIgnoreCase(encryptType)) {
            this.passwordDecoder = CryptoProviderFactory.build((CryptoConfig)CryptoConfig.asymmetric().asymmetricAlgorithm(AsymmetricAlgorithmType.RSA_ECB_PKCS1.name()).privateKeyBase64(this.passwordDecodeProperties.getPriKey()).build());
        } else if ("SM2".equalsIgnoreCase(encryptType)) {
            this.passwordDecoder = CryptoProviderFactory.build((CryptoConfig)CryptoConfig.asymmetric().asymmetricAlgorithm(AsymmetricAlgorithmType.SM2.name()).privateKeyBase64(this.passwordDecodeProperties.getPriKey()).build());
        } else {
            throw new IllegalArgumentException("\u5bc6\u7801\u89e3\u7801\u7c7b\u578b\u4e0d\u6301\uff1a" + this.passwordDecodeProperties.getType());
        }
    }

    private Pair<LevelType, Long> getLevelTypeLongPair() {
        Long appInstanceId = ServiceContext.getContext().getRequestAppInstanceId();
        if (null != appInstanceId) {
            return Pair.of((Object)LevelType.INSTANCE, (Object)appInstanceId);
        }
        Long tenantId = ServiceContext.getContext().getRequestTenantId();
        if (null != tenantId) {
            return Pair.of((Object)LevelType.TENANT, (Object)tenantId);
        }
        return Pair.of((Object)LevelType.GLOBAL, (Object)0L);
    }

    private boolean matchNeedDecodeFieldName(String key) {
        String needDecodeFiledNames = this.passwordDecodeProperties.getPasswordFieldNames();
        if (StringUtils.isNotBlank((CharSequence)needDecodeFiledNames) && StringUtils.isNotBlank((CharSequence)key)) {
            String[] fieldArr;
            for (String field : fieldArr = needDecodeFiledNames.split(",")) {
                if (!field.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    private String decode(String encodePassword) {
        try {
            if (this.isBase64(encodePassword)) {
                return this.passwordDecoder.decodeBase64(encodePassword);
            }
            if (HexUtil.isHexNumber((String)encodePassword)) {
                return this.passwordDecoder.decodeHex(encodePassword);
            }
        }
        catch (Exception e) {
            this.logger.error("decode password error", (Throwable)e);
        }
        return encodePassword;
    }

    private boolean isBase64(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return false;
        }
        return Pattern.matches(BASE64_PATTERN, input);
    }
}

