/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.password.decode.interceptor;

import cn.hutool.core.util.HexUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cyberway.mp.bbc.configuration.api.ConfigurationApi;
import com.cyberway.mp.bbc.configuration.api.LevelType;
import com.cyberway.mp.bbc.configuration.api.dto.ConfigurationItemQueryDto;
import com.cyberway.mp.bbc.password.decode.config.PasswordDecodeProperties;
import com.cyberway.mp.bbc.password.decode.filter.RepeatableRequestWrapper;
import com.cyberway.mp.bc.common.config.SpringContextUtil;
import com.cyberway.mp.bc.common.crypto.CryptoConfig;
import com.cyberway.mp.bc.common.crypto.CryptoProvider;
import com.cyberway.mp.bc.common.crypto.CryptoProviderFactory;
import com.cyberway.mp.bc.common.crypto.asymmetric.AsymmetricAlgorithmType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.servlet.HandlerInterceptor;

@Deprecated
public class PasswordDecodeInterceptor
implements HandlerInterceptor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BASE64_PATTERN = "^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$";
    private final PasswordDecodeProperties passwordDecodeProperties;
    private CryptoProvider passwordDecoder;
    private String currentEncryptType;

    public PasswordDecodeInterceptor(PasswordDecodeProperties passwordDecodeProperties) {
        this.passwordDecodeProperties = passwordDecodeProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        boolean enableEncrypt = true;
        String encryptType = null;
        try {
            Object configurationApiObj = SpringContextUtil.getBean((String)"configurationApplicationService");
            if (null != configurationApiObj) {
                ConfigurationApi configurationApi = (ConfigurationApi)configurationApiObj;
                ConfigurationItemQueryDto enableEncryptQuery = new ConfigurationItemQueryDto();
                enableEncryptQuery.setKey("enable_password_encrypt");
                enableEncryptQuery.setFunctionGroupCode("security-setting");
                enableEncryptQuery.setLevelType(LevelType.GLOBAL);
                enableEncryptQuery.setLevelId(Long.valueOf(0L));
                ConfigurationItemQueryDto encryptTypeQuery = new ConfigurationItemQueryDto();
                encryptTypeQuery.setKey("encrypt_type");
                encryptTypeQuery.setFunctionGroupCode("security-setting");
                encryptTypeQuery.setLevelType(LevelType.GLOBAL);
                encryptTypeQuery.setLevelId(Long.valueOf(0L));
                List values = configurationApi.getObjectValueListUpgrade(Arrays.asList(enableEncryptQuery, encryptTypeQuery));
                enableEncrypt = "true".equalsIgnoreCase((String)values.get(0));
                encryptType = (String)values.get(1);
            }
        }
        catch (Exception configurationApiObj) {
            // empty catch block
        }
        if (null == encryptType) {
            encryptType = this.passwordDecodeProperties.getType();
        }
        if (enableEncrypt && !StringUtils.equalsIgnoreCase((CharSequence)this.currentEncryptType, (CharSequence)encryptType)) {
            this.initPasswordDecoder(encryptType);
        }
        if (null != this.passwordDecoder && request instanceof RepeatableRequestWrapper && this.isNeedHandleMethod(request.getMethod())) {
            RepeatableRequestWrapper requestWrapper = (RepeatableRequestWrapper)request;
            String body = requestWrapper.getBody();
            this.logger.debug("\u5904\u7406\u524d\u7684\u8bf7\u6c42\u4f53\uff1a{}", (Object)body);
            if (StringUtils.isNotBlank((CharSequence)body)) {
                body = this.decodeResponse(body);
            }
            this.logger.debug("\u5904\u7406\u540e\u7684\u8bf7\u6c42\u4f53\uff1a{}", (Object)body);
            requestWrapper.setBody(body);
        }
        return true;
    }

    private String decodeResponse(String body) {
        try {
            JSONObject jsonObject = JSON.parseObject((String)body);
            for (String key : jsonObject.keySet()) {
                String password;
                if (!this.matchNeedDecodeFieldName(key) || !this.isBase64(password = jsonObject.getString(key)) && !HexUtil.isHexNumber((String)password)) continue;
                String decodePassword = this.decode(password);
                jsonObject.put(key, (Object)decodePassword);
            }
            body = jsonObject.toJSONString();
        }
        catch (Exception e) {
            this.logger.warn("\u5bc6\u7801\u89e3\u7801\u62e6\u622a\u5668\u89e3\u6790\u53c2\u6570\u5f02\u5e38");
        }
        return body;
    }

    private void initPasswordDecoder(String encryptType) {
        this.currentEncryptType = encryptType;
        if ("RSA".equalsIgnoreCase(encryptType)) {
            this.passwordDecoder = CryptoProviderFactory.build((CryptoConfig)CryptoConfig.asymmetric().asymmetricAlgorithm(AsymmetricAlgorithmType.RSA_ECB_PKCS1.name()).privateKeyBase64(this.passwordDecodeProperties.getPriKey()).build());
        } else if ("SM2".equalsIgnoreCase(encryptType)) {
            this.passwordDecoder = CryptoProviderFactory.build((CryptoConfig)CryptoConfig.asymmetric().asymmetricAlgorithm(AsymmetricAlgorithmType.SM2.name()).privateKeyBase64(this.passwordDecodeProperties.getPriKey()).build());
        } else {
            throw new IllegalArgumentException("\u5bc6\u7801\u89e3\u7801\u7c7b\u578b\u4e0d\u6301\uff1a" + this.passwordDecodeProperties.getType());
        }
    }

    private boolean isNeedHandleMethod(String method) {
        return HttpMethod.POST.matches(method) || HttpMethod.PUT.matches(method);
    }

    private boolean matchNeedDecodeFieldName(String key) {
        String needDecodeFiledNames = this.passwordDecodeProperties.getPasswordFieldNames();
        if (StringUtils.isNotBlank((CharSequence)needDecodeFiledNames) && StringUtils.isNotBlank((CharSequence)key)) {
            String[] fieldArr;
            for (String field : fieldArr = needDecodeFiledNames.split(",")) {
                if (!field.equals(key)) continue;
                return true;
            }
        }
        return false;
    }

    private String decode(String encodePassword) {
        try {
            if (this.isBase64(encodePassword)) {
                return this.passwordDecoder.decodeBase64(encodePassword);
            }
            if (HexUtil.isHexNumber((String)encodePassword)) {
                return this.passwordDecoder.decodeHex(encodePassword);
            }
        }
        catch (Exception e) {
            this.logger.error("decode password error", (Throwable)e);
        }
        return encodePassword;
    }

    private boolean isBase64(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return false;
        }
        return Pattern.matches(BASE64_PATTERN, input);
    }
}

