/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.remotejob.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.cyberway.mp.bbc.remotejob.dto.RemoteJobHandleDto;
import com.cyberway.mp.bbc.remotejob.dto.RemoteJobSendConfig;
import com.cyberway.mp.bbc.remotejob.dto.RemoteJobSendDto;
import com.cyberway.mp.bbc.remotejob.handler.RemoteJobCallbackHandler;
import com.cyberway.mp.bbc.remotejob.handler.RemoteJobFinishHandler;
import com.cyberway.mp.bbc.remotejob.handler.RemoteJobHandler;
import com.cyberway.mp.bbc.remotejob.vo.RemoteJobInstanceResultVo;
import com.cyberway.mp.bbc.remotejob.vo.RemoteJobResultVo;
import com.cyberway.mp.bc.common.context.ServiceContext;
import com.cyberway.mp.bc.common.controller.ResponseResult;
import com.cyberway.mp.bc.common.utils.UrlCoderUtil;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;

public class RemoteJobService {
    public static final MediaType JSON_MEDIA_TYPE = MediaType.get((String)"application/json; charset=utf-8");
    public static final Set<String> SERVICE_CONTEXT_HEADERS = Set.of("appId", "auth-app-key");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final DiscoveryClient discoveryClient;
    private final List<RemoteJobHandler> remoteJobHandlers;
    @Value(value="${mp.remote-job.cache-enable:true}")
    private boolean cacheEnable;
    private final OkHttpClient defaultHttpClient;
    private static final Cache<String, List<String>> ALL_SERVICES_CACHE = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private static final Cache<String, List<ServiceInstance>> INSTANCES_CACHE = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();

    public RemoteJobService(DiscoveryClient discoveryClient, List<RemoteJobHandler> remoteJobHandlers) {
        this.discoveryClient = discoveryClient;
        this.remoteJobHandlers = remoteJobHandlers;
        this.defaultHttpClient = this.buildDefaultHttpClient();
    }

    private OkHttpClient buildDefaultHttpClient() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        return clientBuilder.connectionPool(new ConnectionPool(20, 1L, TimeUnit.MINUTES)).build();
    }

    public void sendJob(RemoteJobSendDto dto, RemoteJobSendConfig sendConfig) {
        this.sendJob(dto, sendConfig, vo -> {}, vo -> {});
    }

    public void sendJob(RemoteJobSendDto dto, RemoteJobSendConfig sendConfig, RemoteJobFinishHandler finishHandler) {
        this.sendJob(dto, sendConfig, vo -> {}, finishHandler);
    }

    public void sendJob(RemoteJobSendDto dto, RemoteJobSendConfig sendConfig, RemoteJobCallbackHandler callbackHandler, RemoteJobFinishHandler finishHandler) {
        List<String> services = sendConfig.getAllowServiceIds() != null && !sendConfig.getAllowServiceIds().isEmpty() ? sendConfig.getAllowServiceIds() : this.getAllServices();
        ArrayList<RemoteJobInstanceResultVo> resultVoList = new ArrayList<RemoteJobInstanceResultVo>();
        for (String service : services) {
            this.sendJobToService(dto, sendConfig, callbackHandler, resultVoList, service);
        }
        finishHandler.handle(resultVoList);
    }

    private List<String> getAllServices() {
        if (this.cacheEnable) {
            return (List)ALL_SERVICES_CACHE.get((Object)"allServices", key -> this.discoveryClient.getServices());
        }
        return this.discoveryClient.getServices();
    }

    private List<ServiceInstance> getInstances(String service) {
        if (this.cacheEnable) {
            return (List)INSTANCES_CACHE.get((Object)service, key -> this.discoveryClient.getInstances(service));
        }
        return this.discoveryClient.getInstances(service);
    }

    private void sendJobToService(RemoteJobSendDto dto, RemoteJobSendConfig sendConfig, RemoteJobCallbackHandler callbackHandler, List<RemoteJobInstanceResultVo> resultVoList, String service) {
        List<ServiceInstance> instances = this.getInstances(service);
        if (instances.isEmpty()) {
            if (sendConfig.isCallbackWhenServiceNotFound()) {
                RemoteJobInstanceResultVo resultVo = new RemoteJobInstanceResultVo();
                resultVo.setServiceId(service);
                resultVo.setResults(Collections.emptyList());
                resultVo.setSuccess(false);
                resultVo.setExceptionMsg("ServiceNotFound");
                callbackHandler.handle(resultVo);
                resultVoList.add(resultVo);
            }
            return;
        }
        OkHttpClient httpClient = this.defaultHttpClient;
        if (sendConfig.getConnectionTimeout() != null || sendConfig.getReadTimeout() != null || sendConfig.getWriteTimeout() != null) {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            if (sendConfig.getConnectionTimeout() != null) {
                clientBuilder.connectTimeout(sendConfig.getConnectionTimeout());
            }
            if (sendConfig.getReadTimeout() != null) {
                clientBuilder.readTimeout(sendConfig.getReadTimeout());
            }
            if (sendConfig.getWriteTimeout() != null) {
                clientBuilder.writeTimeout(sendConfig.getWriteTimeout());
            }
            httpClient = clientBuilder.build();
        }
        if (Boolean.TRUE.equals(sendConfig.isSendToAllInstance())) {
            for (ServiceInstance instance : instances) {
                RemoteJobInstanceResultVo resultVo = this.sendJobToInstance(dto, httpClient, instance);
                if (resultVo == null) continue;
                resultVoList.add(resultVo);
                callbackHandler.handle(resultVo);
            }
        } else {
            RemoteJobInstanceResultVo resultVo = this.sendJobToInstance(dto, httpClient, instances.get(0));
            if (resultVo != null) {
                resultVoList.add(resultVo);
                callbackHandler.handle(resultVo);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RemoteJobInstanceResultVo sendJobToInstance(RemoteJobSendDto dto, OkHttpClient httpClient, ServiceInstance instance) {
        RemoteJobInstanceResultVo vo = new RemoteJobInstanceResultVo();
        vo.setServiceId(instance.getServiceId());
        vo.setInstanceId(instance.getInstanceId());
        RemoteJobHandleDto handleDto = RemoteJobHandleDto.fromRemoteJobSendDto(dto, instance.getServiceId(), instance.getInstanceId());
        Request.Builder requestBuilder = new Request.Builder().url(new HttpUrl.Builder().scheme("http").host(instance.getHost()).port(instance.getPort()).encodedPath("/api/remoteJob/handle").build()).post(RequestBody.create((MediaType)JSON_MEDIA_TYPE, (String)JSON.toJSONString((Object)handleDto)));
        this.addServiceContextHeader(requestBuilder);
        Request request = requestBuilder.build();
        try (Response response = httpClient.newCall(request).execute();){
            if (response.isSuccessful() && response.body() != null) {
                ResponseResult responseResult = (ResponseResult)JSON.parseObject((String)response.body().string(), (TypeReference)new TypeReference<ResponseResult<RemoteJobInstanceResultVo>>(){}, (Feature[])new Feature[0]);
                RemoteJobInstanceResultVo remoteJobInstanceResultVo = (RemoteJobInstanceResultVo)responseResult.getData();
                return remoteJobInstanceResultVo;
            }
            if (response.code() == 408 || response.code() == 500 || response.code() == 502 || response.code() == 503 || response.code() == 504) {
                vo.setSuccess(false);
                vo.setExceptionMsg(this.tryGetResponseMsg(response));
                return vo;
            }
            RemoteJobInstanceResultVo remoteJobInstanceResultVo = null;
            return remoteJobInstanceResultVo;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            vo.setSuccess(false);
            vo.setExceptionMsg(e.getMessage());
        }
        return vo;
    }

    private void addServiceContextHeader(Request.Builder requestBuilder) {
        try {
            Map attachments = ServiceContext.getContext().getKeys();
            attachments.forEach((headerName, headerValue) -> {
                if (headerName.startsWith("req.") || SERVICE_CONTEXT_HEADERS.contains(headerName)) {
                    requestBuilder.header(headerName, UrlCoderUtil.encoder((String)headerValue.toString()));
                }
            });
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private String tryGetResponseMsg(Response response) {
        block3: {
            ResponseBody body = response.body();
            if (body != null && body.contentLength() > 0L) {
                String bodyString = null;
                try {
                    bodyString = body.string();
                    JSONObject jsonObject = JSON.parseObject((String)bodyString);
                    return StringUtils.defaultString((String)jsonObject.getString("msg"));
                }
                catch (Exception e) {
                    this.logger.warn(e.getMessage(), (Throwable)e);
                    if (bodyString == null) break block3;
                    this.logger.warn("\u89e3\u6790\u54cd\u5e94\u4f53\u5931\u8d25, \u54cd\u5e94\u4f53\u5185\u5bb9\u4e3a[{}]", (Object)bodyString);
                }
            }
        }
        return "\u8bf7\u6c42\u5931\u8d25, \u54cd\u5e94\u7801\u4e3a" + response.code();
    }

    public RemoteJobInstanceResultVo handle(RemoteJobHandleDto dto) {
        RemoteJobInstanceResultVo vo = new RemoteJobInstanceResultVo();
        vo.setServiceId(dto.getServiceId());
        vo.setInstanceId(dto.getInstanceId());
        ArrayList<RemoteJobResultVo> results = new ArrayList<RemoteJobResultVo>();
        vo.setResults(results);
        vo.setSuccess(true);
        HashSet<String> skipHandlerIds = new HashSet<String>();
        if (dto.getSkipHandlerIds() != null) {
            skipHandlerIds.addAll(dto.getSkipHandlerIds());
        }
        if (dto.getServiceSkipHandlerIds() != null && dto.getServiceSkipHandlerIds().containsKey(dto.getServiceId())) {
            skipHandlerIds.addAll((Collection)dto.getServiceSkipHandlerIds().get(dto.getServiceId()));
        }
        List handlers = this.remoteJobHandlers.stream().filter(h -> h.supportHandler(dto.getJobType()) && !skipHandlerIds.contains(h.getHandlerId())).collect(Collectors.toList());
        for (RemoteJobHandler handler : handlers) {
            try {
                results.add(handler.handle(dto.getParam()));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                RemoteJobResultVo result = new RemoteJobResultVo();
                result.setSuccess(false);
                result.setHandlerId(handler.getHandlerId());
                result.setExceptionMsg(e.getMessage());
                results.add(result);
            }
        }
        return vo;
    }
}

