/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bbc.spi;

import com.cyberway.mp.bbc.configuration.api.ConfigurationItem;
import com.cyberway.mp.bbc.configuration.api.ConfigurationValueInsertType;
import com.cyberway.mp.bbc.configuration.api.dto.SpiRegisterDto;
import com.cyberway.mp.bbc.spi.ISpiHelper;
import com.cyberway.mp.bbc.spi.bean.SpiImplDefinition;
import com.cyberway.mp.bbc.spi.bean.SpiPointDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public abstract class AbstractSpiHelper
implements ISpiHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected SpiRegisterDto buildAndCheckSpiRegisterDto(SpiPointDefinition spiPointDefinition, List<SpiImplDefinition> spiImplDefinitions) {
        List<SpiImplDefinition> currentImplList = spiImplDefinitions.stream().filter(impl -> impl.getInterfaceType() == spiPointDefinition.getType()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentImplList)) {
            this.logger.warn("SPIPoint:" + spiPointDefinition.getType() + " is missing SPIImpl implementation");
            return null;
        }
        SpiRegisterDto dto = new SpiRegisterDto();
        dto.setName(spiPointDefinition.getName());
        dto.setConfigurationKey(spiPointDefinition.getCode());
        dto.setDescription(spiPointDefinition.getDescription());
        dto.setFunctionGroupCode(spiPointDefinition.getFunctionCode());
        dto.setGroupId(Long.valueOf(spiPointDefinition.getGroupId()));
        dto.setConfigurationValueInsertType(Boolean.TRUE.equals(spiPointDefinition.getSingleChoice()) ? ConfigurationValueInsertType.RADIO : ConfigurationValueInsertType.SELECT);
        dto.setSpiType(spiPointDefinition.getType().getName());
        ArrayList defaultItem = new ArrayList(currentImplList.size());
        ArrayList allItem = new ArrayList(currentImplList.size());
        currentImplList.forEach(spiImplDefinition -> {
            ConfigurationItem item = new ConfigurationItem();
            item.setValue(spiImplDefinition.getType().getName());
            item.setDisplayName(spiImplDefinition.getName());
            item.setDescription(spiImplDefinition.getDescription());
            allItem.add(item);
            if (spiImplDefinition.getDefaultFlag()) {
                defaultItem.add(item);
            }
        });
        StringBuilder defaultValueBuilder = new StringBuilder();
        for (ConfigurationItem configurationItem : defaultItem) {
            defaultValueBuilder.append(configurationItem.getValue()).append(",");
        }
        String defaultValue = defaultValueBuilder.substring(0, defaultValueBuilder.lastIndexOf(","));
        if (Boolean.TRUE.equals(spiPointDefinition.getSingleChoice()) && defaultItem.size() > 1) {
            throw new IllegalStateException("SPIPoint: " + spiPointDefinition.getType() + " is singleChoice but found multi implementation:[" + defaultValue + "]");
        }
        dto.setDefaultValue(defaultValue);
        dto.setConfigurationItemList(allItem);
        return dto;
    }
}

